#! /bin/bash

# Verbose shell execution.
set -x
set -e

# Print a usage message and exit if the argument count is wrong.
if [ $# != 1 ]; then
echo "Usage: "$0" kbd-data-package" 1>&2
        cat 1>&2 << EOF

        kbd-data: the Debian package containing the keymaps.
EOF
        exit -1
fi

package=$1

. common.sh

case "$arch" in
m68k)
	export keymaps="atari/atari-de.map.gz atari/atari-se.map.gz atari/atari-uk.map.gz atari/atari-us.map.gz amiga/amiga-de.map.gz amiga/amiga-us.map.gz mac/mac-us-std.map.gz mac/mac-us-ext.map.gz mac/mac-fr2-ext.map.gz"
	;;
powerpc)
        export keymaps="i386/azerty/be-latin1.map.gz i386/qwerty/bg.map.gz i386/qwerty/cf.map.gz i386/qwertz/croat.map.gz i386/qwerty/cz-lat2.map.gz i386/qwertz/de-latin1-nodeadkeys.map.gz i386/qwerty/dk-latin1.map.gz i386/dvorak/dvorak.map.gz i386/qwerty/es.map.gz i386/qwerty/fi-latin1.map.gz i386/azerty/fr-latin1.map.gz i386/qwerty/gr.map.gz i386/qwerty/hebrew.map.gz i386/qwertz/hu.map.gz i386/qwerty/is-latin1.map.gz i386/qwerty/it.map.gz i386/qwerty/jp106.map.gz i386/qwerty/no-latin1.map.gz i386/qwerty/pl.map.gz i386/qwerty/ru.map.gz i386/qwerty/se-latin1.map.gz i386/qwertz/slovene.map.gz i386/fgGIod/tr_f-latin5.map.gz i386/qwerty/uk.map.gz i386/qwerty/us.map.gz mac/mac-us-std.map.gz mac/mac-us-ext.map.gz mac/mac-fr2-ext.map.gz mac/mac-de-latin1-nodeadkeys.map.gz"
	;;
sparc)
	export keymaps="sun/sunkeymap.map.gz sun/sunt4-es.map.gz sun/sunt5-de-latin1.map.gz sun/sunt5-es.map.gz sun/sunt5-fi-latin1.map.gz sun/sunt5-fr-latin1.map.gz sun/sunt5-ru.map.gz i386/azerty/be-latin1.map.gz i386/qwerty/bg.map.gz i386/qwerty/cf.map.gz i386/qwertz/croat.map.gz i386/qwerty/cz-lat2.map.gz i386/qwertz/de-latin1-nodeadkeys.map.gz i386/qwerty/dk-latin1.map.gz i386/dvorak/dvorak.map.gz i386/qwerty/es.map.gz i386/qwerty/fi-latin1.map.gz i386/azerty/fr-latin1.map.gz i386/qwerty/gr.map.gz i386/qwerty/hebrew.map.gz i386/qwertz/hu.map.gz i386/qwerty/is-latin1.map.gz i386/qwerty/it.map.gz i386/qwerty/jp106.map.gz i386/qwerty/no-latin1.map.gz i386/qwerty/pl.map.gz i386/qwerty/ru.map.gz i386/qwerty/se-latin1.map.gz i386/qwertz/slovene.map.gz i386/fgGIod/tr_f-latin5.map.gz i386/qwerty/uk.map.gz i386/qwerty/us.map.gz"
	;;
*)
        export keymaps="i386/azerty/be-latin1.map.gz i386/qwerty/bg.map.gz i386/qwerty/cf.map.gz i386/qwertz/croat.map.gz i386/qwerty/cz-lat2.map.gz i386/qwertz/de-latin1-nodeadkeys.map.gz i386/qwerty/dk-latin1.map.gz i386/dvorak/dvorak.map.gz i386/qwerty/es.map.gz i386/qwerty/fi-latin1.map.gz i386/azerty/fr-latin1.map.gz i386/qwerty/gr.map.gz i386/qwerty/hebrew.map.gz i386/qwertz/hu.map.gz i386/qwerty/is-latin1.map.gz i386/qwerty/it.map.gz i386/qwerty/jp106.map.gz i386/qwerty/no-latin1.map.gz i386/qwerty/pl.map.gz i386/qwerty/ru.map.gz i386/qwerty/se-latin1.map.gz i386/qwertz/slovene.map.gz i386/fgGIod/tr_f-latin5.map.gz i386/qwerty/uk.map.gz i386/qwerty/us.map.gz"
	;;
esac

extractdir=/var/tmp/extract-tmp-$$
tmpdir=/var/tmp/tmp-$$
scriptdir=`pwd`/utilities/writemaps

rm -rf $extractdir
mkdir $extractdir

if [ ! -f $package ]; then
	echo "Unable to find kbd-data package: $package"
	return 1;
fi
dpkg-deb --extract $package $extractdir; \

######## creating binary keymaps
rm -rf $tmpdir
mkdir $tmpdir

# Save current keymap
dumpkeys -f >/var/tmp/keymap-$$
(cd $extractdir
    for i in $keymaps; do
        j=`basename $i .map.gz`
	k=`dirname $i`
	echo $i
	loadkeys usr/share/keymaps/$i
	mkdir -p $tmpdir/$k
	dumpkeys | $scriptdir/loadkeys -b > $tmpdir/$k/$j\.bmap
    done
)
# Restore saved keymap
loadkeys /var/tmp/keymap-$$

rm -rf $extractdir /var/tmp/keymap-$$

# creating keymaps.tgz

(cd $tmpdir;tar cf - *|gzip -9 ) > keymaps.tgz

rm -rf $tmpdir

ls -l keymaps.tgz
