#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/mount.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include INCLINGUA

extern int fdflush(const char *filename);
extern int set_loop (const char *, const char *, int, int *);
extern int del_loop (const char *);

extern char *pattern[];
extern char *altpattern[];
extern int patidx;

/* ED: try to read an image through the loop service to determine if it resides
 * on local disk or NFS server.  In the latter case, the loop service cannot be
 * used as is.  The workaround is to copy the image locally before mounting it.
 */
static int
check_loop(const char *loop_dev ) {
  int fd;
  int i;
  int err=0;
  fd=open(loop_dev,O_RDONLY);
  if (!fd)
    return -1;
  if (read(fd,prtbuf,PRTBUFSIZE>>1) != PRTBUFSIZE>>1)
    err=-1;
  close(fd);
  /* 2.2 kernels allow to read from the device but the data is all zero */
  for(i=0;i<PRTBUFSIZE>>1;i++) if (prtbuf[i]) break;
  if (i>=PRTBUFSIZE>>1)
    err=-1;
  return err;
}

static char*
copy_to_local(const char* diskimage,int nfsroot)
{
  char* dev;
  int status;
  if (nfsroot) {
    /* if nfs-root, cannot copy to local.  Instead use a ramdisk */
    sprintf(prtbuf, "dd < %s/%s > /dev/ram 2> /dev/null",Archive_Dir,diskimage);
    status = system(prtbuf);
    dev = "/dev/ram";
  }
  else {
    int ro=1;
    sprintf(prtbuf,"cp %s/%s /target/image.bin",Archive_Dir,diskimage);
    status = system(prtbuf);
    dev = "/dev/loop0";
    status = set_loop("/dev/loop0","/target/image.bin",0,&ro);
  }
  if (status)
    return NULL;
  return dev;
}

static char*
get_device(const char* diskimage)
{
  char* device;
  if (is_nfs_partition("/target")) {
    /* diskless install cannot cope with loop device.  Use ramdisk instead */
    sprintf(prtbuf,MSG_BROKEN_LOOP_DEV,diskimage);
    pleaseWaitBox(prtbuf);
    device=copy_to_local(diskimage,1);
    boxPopWindow();
  }
  else {
    int ro=1;
#ifdef LOOP_IN_MODULE
    sprintf(prtbuf,"insmod loop");
    system(prtbuf);
#endif
    sprintf(prtbuf,"%s/%s",Archive_Dir,diskimage);
    device="/dev/loop0";
    set_loop(device,prtbuf,0,&ro);
    if (check_loop(device)) {
      /* image is on an NFS server -> loop device is broken, copy to local */
      del_loop(device);
      sprintf(prtbuf,MSG_BROKEN_LOOP_DEV,diskimage);
      pleaseWaitBox(prtbuf);
      device=copy_to_local(diskimage,0);
      boxPopWindow();
    }
  }
  return device;
}

static void
release_device(const char* device)
{
  if (is_nfs_partition("/target")) {
    /* free ramdisk */
    int f=open(device,O_RDWR);
    if (f >= 0) {
      ioctl(f,BLKFLSBUF);
      close(f);
    }
  }
  else {
    del_loop(device);
    unlink("/target/image.bin");
  }
}


extern int mount_one(char *blockDevice, char *directory, char *filesystemType, 
  unsigned long flags, char *string_flags, int noMtab, int fake);

static int install_floppy (char *device, const char *type, const char *text) {
  int status;

  if (mount_and_check_floppy(device,type,text)) return 1;
  sprintf(prtbuf,MSG_INSTALLING_FLOPPY,text);
  if (strncmp(device,"/dev/loop",9) ) {
   strcat(prtbuf,"...");
  } else {
   strcat(prtbuf,MSG_FROM_FLOPPY_IMAGES);
  }
  pleaseWaitBox(prtbuf);
  chdir("/floppy");
  status=system("./install.sh /target");
  chdir("/");
  do_umount("/floppy",0);
  boxPopWindow();
  if (status) {
    return 1;
  }
  return 0;
}

int extract_kernel_and_modules (void) {
  DIR* dp;
  char *diskimage;
  struct dirent *dirp;
  int found=0,status=0;
  struct fdisk_partition *p;
  char* device;

  disqtype=kernel;

  /* Only verify root choice if it is not empty. */

  dp = opendir("/target/.");
  while (NULL != (dirp = readdir(dp))) {
    if (( 0 != strcmp(dirp->d_name, ".")) &&
        ( 0 != strcmp(dirp->d_name, "..")) &&
        ( 0 != strcmp(dirp->d_name, "lost+found"))) {
      found = 1;
      break;
    }
  }

  if (found) {
    sprintf(prtbuf,MSG_MOUNTED_FS);
    p = mounted_partitions;
    while (p) {
      if (! strncmp(p->mount_point,"/target",
                                   strlen("/target") ) ) {
	char *begg;
        strcat(prtbuf,"\n");
        strcat(prtbuf,p->name);
        strcat(prtbuf," on ");
	begg=(p->mount_point)+strlen("/target");
	if (*begg=='\0')
		strcat(prtbuf,"/");
	else
		strcat(prtbuf,begg);
      }
      p = p->next_in_use;
    }
    if (! yesNoBox(prtbuf,MSG_VERIFY_FS) ) return 1;
  }
  if ( choose_medium() ) return 1;
  
  if (! strncmp(Archive_Dir,"/dev/fd",7)
#ifdef SCSI_FLOPPY
  ||  ! strncmp(Archive_Dir,"/dev/sfd",8)
#endif
	) {
#ifdef SCSI_FLOPPY
    if (strncmp(Archive_Dir,"/dev/sfd",8)) /* not scsi floppy */
#endif
      fdflush(Archive_Dir);
    status=install_floppy(Archive_Dir,"rescue",MSG_RESCUE_FLOPPY);
    if (status) {
/* FIXME:  write_it_down "The attempt to extract the rescue floppy failed." */
      eject_floppy(Archive_Dir);
      sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_RESCUE_FLOPPY);
      problemBox(prtbuf, MSG_FLOPPY_ERROR);
    } else {
#ifdef SCSI_FLOPPY
      if (strncmp(Archive_Dir,"/dev/sfd",8)) /* not scsi floppy */
#endif
        fdflush(Archive_Dir);
      eject_floppy(Archive_Dir);
      status=install_floppy(Archive_Dir,"drivers",MSG_DRIVERS_FLOPPY);
#ifdef SCSI_FLOPPY
      if (strncmp(Archive_Dir,"/dev/sfd",8)) /* not scsi floppy */
#endif
        fdflush(Archive_Dir);
      eject_floppy(Archive_Dir);
      if (status) {
/* FIXME:  write_it_down "The attempt to extract the drivers floppy failed." */
        sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_DRIVERS_FLOPPY);
        problemBox(prtbuf, MSG_FLOPPY_ERROR);
      }
    }
  } else {
    diskimage=kernel_image_filename;
    device=get_device(diskimage);
    if (device) {
      status=install_floppy(device,"rescue",MSG_RESCUE_FLOPPY);
      release_device(device);
    }
    else
      status=-1;
    if (status) {
/* FIXME:  write_it_down "The attempt to extract the rescue floppy failed." */
      sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_RESCUE_FLOPPY);
      problemBox(prtbuf, MSG_FLOPPY_ERROR);
    } else {
      diskimage=drivers_image_filename;
      device=get_device(diskimage);
      if (device) {
        status=install_floppy(device,"drivers",MSG_DRIVERS_FLOPPY);
        sync();
	release_device(device);
      }
      else
	status=-1;
      if (status) {
/* FIXME:  write_it_down "The attempt to extract the drivers floppy failed." */
        sprintf(prtbuf,MSG_EXTRACT_FLOPPY_FAILED,MSG_DRIVERS_FLOPPY);
        problemBox(prtbuf, MSG_FLOPPY_ERROR);
      }
    }
    do_umount("/instmnt",0);
  }
/*  free(Archive_Dir); */
/*  Archive_Dir=NULL; */
  return status;
}

/* vi: set sw=2 ts=8: */
