// most_negative_float().

// General includes.
#include "cl_sysdep.h"

CL_PROVIDE(cl_F_mostneg)

// Specification.
#include "cl_float.h"

// Implementation.

#include "cl_F.h"
#include "cl_SF.h"
#include "cl_FF.h"
#include "cl_DF.h"
#include "cl_LF.h"
#include "cl_LF_impl.h"

// Exponent so gro wie mglich, Mantisse 1...1, Vorzeichen -.

static cl_SF most_negative_SF =
	make_SF(-1,SF_exp_high,bit(SF_mant_len+1)-1);

static cl_FF most_negative_FF =
	encode_FF(-1,FF_exp_high-FF_exp_mid,bit(FF_mant_len+1)-1);

static cl_DF most_negative_DF =
#if (cl_word_size==64)
	encode_DF(-1,DF_exp_high-DF_exp_mid,bit(DF_mant_len+1)-1);
#else
	encode_DF(-1,DF_exp_high-DF_exp_mid,bit(DF_mant_len-32+1)-1,bitm(32)-1);
#endif

inline cl_LF most_negative_LF (uintC len)
{
	var Lfloat erg = allocate_lfloat(len,LF_exp_high,-1);
	fill_loop_up(&TheLfloat(erg)->data[0],len,~(uintD)0);
	return erg;
}

cl_F most_negative_float (cl_float_format_t f)
{
	floatformatcase((uintL)f
	,	return most_negative_SF;
	,	return most_negative_FF;
	,	return most_negative_DF;
	,	return most_negative_LF(len);
	);
}

CL_PROVIDE_END(cl_F_mostneg)
