#ifndef _complex_
#define _complex_

#include <math.h>

typedef struct {
	double	real,
			imag;
} complex;

typedef complex sl2c_matrix[2][2];

#ifndef PROTOTYPES
Please #include options.h BEFORE complex.h.
#endif

#if PROTOTYPES
extern complex	cplx_minus(complex, complex),
				cplx_plus(complex, complex),
				cplx_mult(complex, complex),
				cplx_div(complex, complex);
extern double	modulus(complex);
extern complex	cplx_sqrt(complex);
extern void		sl2c_mult(sl2c_matrix, sl2c_matrix, sl2c_matrix);
extern void		sl2c_copy(sl2c_matrix, sl2c_matrix);
extern void		sl2c_normalize(sl2c_matrix);
extern void		sl2c_invert(sl2c_matrix, sl2c_matrix);
extern double	sl2c_norm_squared(sl2c_matrix);
extern void		sl2c_adjoint(sl2c_matrix, sl2c_matrix);
extern double	acosh(double);
#else
extern complex	cplx_minus(),
				cplx_plus(),
				cplx_mult(),
				cplx_div();
extern double	modulus();
extern complex	cplx_sqrt();
extern double	sl2c_norm_squared();
/*extern double	acosh();*/
#endif

extern complex zero;
extern complex one;

#endif
