/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "ndmeshP.h"
#include "mesh.h"	/* plain old 3-D mesh */
#include "mgP.h"

#include "meshP.h"
#include "mgP.h"
#include "hpointn.h"
#include <stdlib.h>
#ifndef alloca
#include <alloca.h>
#endif

static
draw_projected_ndmesh(mgmapfunc NDmap, void *NDinfo, NDMesh *mesh)
{
    Mesh m;
    HPointN **op;
    HPoint3 *np;
    int i, colored = 0;
    int npts = mesh->mdim[0] * mesh->mdim[1];

    memset(&m, 0, sizeof(m));
    m.p = (HPoint3 *)alloca(npts*sizeof(HPoint3));
    m.n = NULL;
    m.c = (ColorA *)alloca(npts*sizeof(ColorA));
    m.nu = mesh->mdim[0];
    m.nv = mesh->mdim[1];
    m.flag = mesh->flag & ~MESH_4D;
    for(i = 0, op = mesh->p, np = m.p; i < npts; i++, op++, np++) {
	/* Set the point's first four components from our N-D mesh vertex */
	colored = (*NDmap)(NDinfo, *op, np, &m.c[i]);
    }
    if(colored) m.flag |= MESH_C;
    MeshComputeNormals(&m);
    mgmesh(m.flag, m.nu, m.nv, m.p, m.n, colored ? m.c : mesh->c);
    OOGLFree(m.n);
}

NDMesh *
NDMeshDraw(register NDMesh *mesh)
{
  Transform T;
  float focallen;

  if(_mgc->NDinfo) {
    mgpushtransform();
    CamGet(_mgc->cam, CAM_FOCUS, &focallen);
    TmTranslate(T, 0., 0., -focallen);
    TmConcat(T, _mgc->C2W, T);
    mgsettransform(T);
    draw_projected_ndmesh(_mgc->NDmap, _mgc->NDinfo, mesh);
    mgpoptransform();
  }
  return mesh;
}


