/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

Quad *
QuadCopy(oq)
	register Quad *oq;
{
	register Quad *q;

        if (!oq) return NULL;
        q = OOGLNewE(Quad, "new Quad");
	q->p = OOGLNewNE(QuadP, oq->maxquad, "quad verts");

	q->flag = oq->flag;
	q->maxquad = oq->maxquad;
	memcpy(q->p, oq->p, oq->maxquad * sizeof(QuadP));

	if(oq->flag & QUAD_N) {
	    q->n = OOGLNewNE(QuadN, oq->maxquad, "quad normals");
	    memcpy(q->n, oq->n, oq->maxquad * sizeof(QuadN));
	} else
	    q->n = NULL;

	if(oq->flag & QUAD_C) {
	    q->c = OOGLNewNE(QuadC, oq->maxquad, "quad colors");
	    memcpy(q->c, oq->c, oq->maxquad * sizeof(QuadC));
	} else
	    q->c = NULL;

	return q;
}
