#include "ooglutil.h"
#include "geom.h"
#include "listP.h"
#include "pointlistP.h"


void *list_PointList_get(int sel, Geom *geom, va_list args);
void *list_PointList_fillin(int sel, Geom *geom, va_list args);
void *list_PointList_set(int sel, Geom *geom, va_list args);
void *list_PointList_length(int sel, Geom *geom, va_list args);

#define MAX_METHODS 4

static SpecFunc methods[] = {
  "PointList_get", list_PointList_get,
  "PointList_fillin", list_PointList_fillin,
  "PointList_set", list_PointList_set,
  "PointList_length", list_PointList_length
  };

static char msg[] = "ptlList.c";

ptlList_init() {
  pointlist_initspec(methods, MAX_METHODS, GeomClassLookup("list"));
}

void *list_PointList_get(int sel, Geom *geom, va_list args) {
  List *l = (List *)geom;
  HPoint3 *plist;
  TransformPtr t;
  
  plist = OOGLNewNE(HPoint3, 
		    (int)GeomCall(GeomMethodSel("PointList_length"), geom), 
		     msg);
  t = va_arg(args, TransformPtr);

  return(GeomCall(GeomMethodSel("PointList_fillin"), geom, t, 0, plist));

}

void *list_PointList_fillin(int sel, Geom *geom, va_list args) {
  TransformPtr t;
  int n_points1;
  HPoint3 *plist;
  List *l = (List *)geom;

  t = va_arg(args, TransformPtr);
  va_arg(args, int);
  plist = va_arg(args, HPoint3 *);

  n_points1 = (int)GeomCall(GeomMethodSel("PointList_length"), l->car);

  GeomCall(GeomMethodSel("PointList_fillin"), l->car, t, 0, plist);
  GeomCall(GeomMethodSel("PointList_fillin"), (Geom *)l->cdr, t, 0, 
	   &plist[n_points1]);
  return plist;
}


void *list_PointList_set(int sel, Geom *geom, va_list args) {
  HPoint3 *pt1;
  int n_points1, coordsys;
  List *l = (List *)geom;

  coordsys = va_arg(args, int);
  pt1 = va_arg(args, HPoint3 *);
  n_points1 = (int)GeomCall(GeomMethodSel("PointList_length"), l->car);

  GeomCall(GeomMethodSel("PointList_set"), l->car, coordsys, pt1);
  GeomCall(GeomMethodSel("PointList_set"), (Geom *)l->cdr, 
	   coordsys, &pt1[n_points1]);

  return geom;
}

void *list_PointList_length(int sel, Geom *geom, va_list args) {
  List *l = (List *)geom;
  return  (void *)
    ((int)GeomCall(GeomMethodSel("PointList_length"), l->car) + 
     (int)GeomCall(GeomMethodSel("PointList_length"), (Geom *)l->cdr));
}

