.TH "hmmemit" 1 "March 1998" "HMMER 2.0" "HMMER Manual"

.SH NAME
.TP 
hmmemit - generate sequences from a profile HMM

.SH SYNOPSIS
.B hmmemit
.I [options]
.I hmmfile

.SH DESCRIPTION

.B hmmemit
reads an HMM file from
.I hmmfile
and generates a number of sequences from it.
This can be useful for various applications in which one needs a simulation
of sequences consistent with a sequence family consensus. By default,
.B hmmemit
generates 10 sequences and outputs them in FASTA (unaligned) format.

.SH OPTIONS

.TP
.B -a
Write the generated sequences in an aligned format (SELEX) rather than
FASTA.

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.BI -n " <n>"
Generate
.I <n> 
sequences. Default is 10.

.TP
.BI -o " <f>"
Save the sequences to file
.I <f>
rather than writing them to stdout.

.TP
.B -q
Quiet; suppress all output except for the sequences themselves.
Useful for piping or directing the output.

.SH EXPERT OPTIONS

.TP
.BI --seed " <n>"
Set the random seed to
.I <n>,
where 
.I <n> 
is a positive integer. The default is to use 
.B time()
to generate a different seed for each run, which
means that two different runs of
.B hmmemit
on the same HMM will give slightly different
results.  You can use
this option to generate reproducible results.

.SH SEE ALSO

.PP
hmmalign(1), hmmbuild(1), hmmcalibrate(1),
hmmconvert(1), hmmer(1), hmmpfam(1), hmmsearch(1)
.PP
User guide and tutorial: Userguide.ps
.PP
WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is Copyright (C) 1992-1998 Washington
University School of Medicine.  It is freely distributable under terms
of the GNU General Public License. See COPYING in the source code
distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


