% $Id: corHF.Rd,v 1.4 1998/04/02 18:53:11 pinheiro Exp $
\name{corHF}
\title{Huyn-Feldt Correlation Structure}
\usage{
corHF(value, form)
}
\alias{corHF}
\arguments{
 \item{value}{an optional vector with the parameter values. Default is
   \code{numeric(0)}, which results in a vector of zeros of appropriate
   dimension being assigned to the parameters when \code{object} is
   initialized (corresponding to an identity correlation structure).}
 \item{form}{a one sided formula of the form \code{~ t}, or code{~ t |
     g}, specifying a time covariate \code{t} and,  optionally, a
   grouping factor \code{g}. A covariate for this correlation structure
   must be integer valued. When a grouping factor is present in
   \code{form}, the correlation structure is assumed to apply only
   to observations within the same grouping level; observations with
   different grouping levels are assumed to be uncorrelated. Defaults to
   \code{~ 1}, which corresponds to using the order of the observations
   in the data as a covariate, and no groups.}  
}
\description{
  This function is a constructor for the \code{corHF} class,
  representing a correlation structure satisfying the Huyn-Feldt
  conditions \eqn{\rho_{ij} = \gamma_i + \gamma_j + (1 -
    2\gamma_i)\delta_{ij}}{r(i,j)=g(i)+g(j)+(1-2*g(i))*d(i,j)},
  where \eqn{\rho_{ij}}{r(i,j)} denotes the
  correlation between observations \code{i} and \code{j},
  \eqn{\gamma_i}{g(i)} and \eqn{\gamma_j}{g(j)} are the corresponding
  parameter values, and \eqn{\delta_{ij}}{d(i,j)} is an indicator
  variable assuming value 1 when \eqn{i=j} and 0
  otherwise. Objects created using this constructor need to be later
  initialized using the  appropriate \code{initialize} method. 
}
\value{
  an object of class \code{corHF}, representing an  Huyn-Feldt
  correlation structure. 
}
\references{
  Milliken, G. A. and Johnson, D. E. (1992) "Analysis of Messy Data,
  Volume I: Designed Experiments", Van Nostrand Reinhold.
}
\author{Jose Pinheiro and Douglas Bates}

\seealso{\code{\link{initialize.corHF}}}

\examples{
library(lme)
## covariate is observation order and grouping factor is Subject
cs1 <- corHF(form = ~ 1 | Subject)
}
\keyword{models}
