\name{gamma.dispersion}
\alias{gamma.dispersion}
\title{
Calculate the MLE of the Gamma Dispersion Parameter in a GLM Fit
}
\description{
A front end to \code{gamma.shape} for convenience.  Finds the
reciprocal of the estimate of the shape parameter only.
}
\usage{
gamma.dispersion(fm, \dots)
}
\arguments{
\item{fm}{
Fitted model object giving the gamma fit.
}
\item{...}{
Additional arguments passed on to \code{gamma.shape}.
}}
\value{
The MLE of the dispersion parameter of the gamma distribution.
}
\seealso{
\code{\link{gamma.shape.glm}}, including the example in its help page.
}
\examples{
# The function is currently defined as
function(fm, \dots)
1/gamma.shape(fm, \dots)[[1]]
}
\keyword{models}
% Converted by Sd2Rd version 0.3-1.
