"coda.options" <-
function (...) 
{
        #Set and display coda options
        #Works like options() and par(), ie
        #MTP start
        #Displays current values if no arguments are given
        #Displays current values of selected arguments if arguments are names
        #Resets values if argument is a named list
        #Like par it returns a value (rather than a list) if asked to
        #display one argument 
        #In addition
        #Resets to defaults if the "default=T" argument is given.
        #TODO put in value checking. Currently only checks mode
        #MTP finish
        single <- FALSE
        if (nargs() == 0) {
                return(.Coda.Options)
        }
        else {
                args <- list(...)
                if (length(args) == 1) {
                        if (is.list(args[[1]])) 
                                args <- args[[1]]
                        else if (is.null(names(args))) 
                                single <- TRUE
                }
        }
        if (is.null(names(args))) {
                #Display options
                args <- unlist(args)
                value <- vector("list", length(args))
                names(value) <- args
                for (v in args) if (any(v == names(.Coda.Options))) 
                        value[v] <- .Coda.Options[v]
                if (single) 
                        return(value[[1]])
                else return(value)
        }
        else {
                #Set options
                # MTP if there is no copy of .Coda.Options in the 
                # global environment we need to make one, otherwise
                # assignment to list members fails
                if (!exists(".Coda.Options", frame = 1)) 
                        .Coda.Options <<- .Coda.Options
                oldvalue <- vector("list", length(args))
                names(oldvalue) <- names(args)
                if (any(names(args) == "default") && args$default == 
                        T) 
                        .Coda.Options <<- .Coda.Options.Default
                for (v in names(args)) if (any(v == names(.Coda.Options))) {
                        oldvalue[v] <- .Coda.Options[v]
                        if (is.null(args[[v]])) 
                                .Coda.Options[v] <<- list(NULL)
                        else if (mode(.Coda.Options[[v]]) == 
                                mode(args[[v]])) 
                                .Coda.Options[v] <<- args[v]
                }
                invisible(oldvalue)
        }
}
