"codamenu.options.gelman" <-
function (next.menu) 
{
        cat("\nOptions for defining bin size to plot Gelman-Rubin-Brooks diagnostic:\n")
        choices <- c("Default: bin width = 10; maximum number of bins = 50", 
                "User-specified bin width", "User-specified total number of bins")
        pick <- menu(choices)
        if (pick == 0) 
                return("quit")
        switch(pick, {
                coda.options(gr.max = 50)
                coda.options(gr.bin = 10)
        }, {
                coda.options(gr.max = 0)
                default <- if (coda.options("gr.bin") == 0) 
                        10
                else coda.options("gr.bin")
                msg <- "Enter required bin width:"
                coda.options(gr.bin = read.and.check(msg, lower = 1, 
                        upper = niter(work.dat) - 50, default = default))
        }, {
                coda.options(gr.bin = 0)
                default <- if (coda.options("gr.max") == 0) 
                        50
                else coda.options("gr.max")
                msg <- "Enter total number of bins required:"
                coda.options(gr.max = read.and.check(msg, lower = 1, 
                        upper = niter(work.dat) - 50, default = default))
        })
        return(next.menu)
}
