"set.scale.motif" <-
function (mrows, mcols) 
{
        plot.dim <- mrows + mcols - 1
        if (plot.dim > 7) 
                plot.dim <- 7
        if (mrows >= 6 & mcols < 6) 
                plot.dim <- 8
        if (mrows < 6 & mcols >= 6) 
                plot.dim <- 9
        if (mrows >= 6 & mcols >= 6) 
                plot.dim <- 10
        par(mfrow = c(mrows, mcols), oma = c(1.1, 0, 3.8, 0), 
                mgp = c(3.9, 0.9, 0))
        par(mar = c(6.1, 6.5, 5.1, 3.1))
        args.list$scale <- switch(plot.dim, 1.1, 1, 0.8, 0.75, 
                0.65, 0.6, 0.6, 0.35, 0.55, 0.35)
        args.list$title.scale <- switch(plot.dim, 0.825, 0.775, 
                0.7, 0.55, 0.5, 0.5, 0.5, 0.45, 0.3, 0.3)
        if (plot.dim < 3 & coda.options("ps.plot") < 3) {
                par(lab = c(4, 4, 5))
        }
        else {
                if (plot.dim < 6) {
                        par(lab = c(4, 2, 4))
                }
                else {
                        par(lab = c(3, 2, 3))
                }
        }
        return(args.list)
}
