#include "fonts.h"

char *family2name(int fmt)
{
	switch (fmt & FONT_MASK) {
	case COURIER: return "Courier";
	case HELVETICA: return "Helvetica";
	case NEW_CENTURY: return "New Century Schoolbook";
	case TIMES: return "Times";
	default: return "ERROR";
	}
}

char *size2name(int fmt)
{
	switch (fmt & SIZE_MASK) {
	case SIZE_8:	return "8";
	case SIZE_10:	return "10";
	case SIZE_12:	return "12";
	case SIZE_14:	return "14";
	case SIZE_18:	return "18";
	case SIZE_24:	return "24";
	case SIZE_20:	return "20";
	case SIZE_30:	return "30";
	default:	return "XX";
	}
}

char *format2name(int fmt)
{
	switch (fmt & FMT_MASK) {
	case FMT_DEFAULT: return "Default";
	case FMT_INVISIBLE: return "Invisible";
	case FMT_INTEGER: return "Integer";
	case FMT_SCIENTIFIC:	return "Scientific";
	case FMT_FIXED:		return "Fixed";
	case FMT_DATE:		return "Date";
	case FMT_TIME:		return "Time";
	case FMT_TIMEDIFF:	return "Time Difference";
	case FMT_PERCENT:	return "Percent";
	case FMT_HEX:		return "Hex";
	case FMT_CURRENCY:	return "Currency";
	case FMT_USER1:		return "User 1";
	case FMT_USER2:		return "User 2";
	case FMT_USER3:		return "User 3";
	case FMT_USER4:		return "User 4";
	case FMT_USER5:		return "User 5";
	default:		return "ERROR";
	}
}

char *color2name(int fmt)
{
	switch (fmt & COLOR_MASK) {
	case COLOR_0:		return "Black";
	case COLOR_1:		return "Red";
	case COLOR_2:		return "Green";
	case COLOR_3:		return "Blue";
	case COLOR_4:		return "Yellow";
	case COLOR_5:		return "Magenta";
	case COLOR_6:		return "Cyan";
	case COLOR_7:		return "White";
	default:		return "ERROR";
	}
}

