/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * fileio_gif.c
 *
 * This format requires the netpbm package, particularly the "xpmtoppm"
 * and "ppmtogif" programs.
 * It also requires the "gifmerge" program, not part of netpbm.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/xpm.h>

#include "../xcommon/Animator.h"
#include "egon.h"
#include "types.h"
#include "../common/common.h"
#include "../common/fonts.h"
#include "../xcommon/embed.h"
#include "../common/cmalloc.h"

static int save(char *fn, buffer *buf)
{
	unsigned long now = 0;
	Widget shell, w;
	GC gc;
	unsigned long valuemask = 0;
	XGCValues values;
	Pixmap pm;
	char tmpxpm[256];	/* for xpm file */
	char tmpgif[256];	/* for gif file */
	char *tmpgifs = 0, *p;	/* list of all gifs */
	char cmd[256];		/* for xpmtoppm | ppmtogif */
	XpmAttributes xa;
	char *docdir;

	xa.closeness = 40000;
	xa.exactColors = FALSE;
	xa.valuemask = XpmCloseness | XpmExactColors;

	shell = XtVaCreatePopupShell("shell",
		transientShellWidgetClass, topLevel, NULL);

	docdir = cstrdup(buf->path);

	p = strrchr(docdir, '/');
	if (p) {
		*p = '\0';
	}

	w = XtVaCreateManagedWidget("stage",
		animatorWidgetClass, shell,
		XtNheight, buf->height,
		XtNwidth, buf->width,
		XtNanimatorCast, buf->cast,
		XtNanimatorNow, now,
		XtNanimatorBgPixmap, buf->bg,
		NULL);

	XtPopup(shell, XtGrabNone);

	gc = XCreateGC(XtDisplay(w), XtWindow(w),
			valuemask, &values);
	/* start by saving one gif for time now=0 */
	for (now = 0; now <= buf->duration; now += buf->delta) {
		pm = ani_pixmap(XtDisplay(w), XtWindow(w), gc,
				buf->cast, buf->bg, now);
		sprintf(tmpxpm, "/tmp/egon-%ld.xpm", now);
		sprintf(tmpgif, "/tmp/egon-%ld.gif", now);
		if (tmpgifs == NULL) {
			tmpgifs = (char *)cmalloc(strlen(tmpgif)+1);
			strcpy(tmpgifs, tmpgif);
		} else {
			tmpgifs = (char *)crealloc(tmpgifs,
						strlen(tmpgifs)+strlen(tmpgif)+2);
			strcat(tmpgifs, " ");
			strcat(tmpgifs, tmpgif);
		}
		XpmWriteFileFromPixmap(display,
			tmpxpm, pm, None, &xa);
		XFreePixmap(XtDisplay(w), pm);
		sprintf(cmd, "xpmtoppm %s | ppmtogif > %s", tmpxpm, tmpgif);
		system(cmd);
		remove(tmpxpm);
	}

	p = (char *)cmalloc(strlen(tmpgifs)+100);
	sprintf(p, "gifmerge -%ld -l0 %s > %s", buf->delta/10, tmpgifs, fn);
	system(p);
	sprintf(p, "rm %s", tmpgifs);
	system(p);
	XFreeGC(XtDisplay(w), gc);
	XtPopdown(shell);
	XtDestroyWidget(shell);
	cfree(tmpgifs);
	cfree(p);
	cfree(docdir);

	return 0;
}

/* file format guessing:
   1. extension .gif
   2. Starts with "GIF8"
*/
#define GIF_MAGIC "GIF8"
static int myformat(char *fn)
{
	char *ext;
	FILE *fp = NULL;
	char b[250];
	int result;

	result = ((ext = strrchr(fn, '.')) &&
		!cstrcasecmp(ext, ".gif") &&
		(fp = fopen(fn, "r")) &&
		fread(b, 1, 4, fp) &&
		!memcmp(b, GIF_MAGIC, strlen(GIF_MAGIC)));
	if (fp) fclose(fp);
	return result;
}

void fileio_gif_init()
{
	register_format(NULL, save, myformat, "Animated GIF (*.gif)");
}

