/*
 * This file is part of tela the Tensor Language.
 * Copyright (c) 1994-1996 Pekka Janhunen
 */

/*
 * tunop.C - 'template' for a kind-preserving unary operator, included separately for -,...
 */

void OPFNAME(Tobject& c, const Tobject& a) {
	int i;
	switch (a.kind()) {
	case Kint:
		c = OP(a.IntValue());
		global::nops++;
		break;
	case Kreal:
		c = OP(a.RealValue());
		global::nops++;
		break;
	case Kcomplex:
		c = OP(a.ComplexValue());
		global::nops++;
		break;
	case KIntArray:
		{
			c.copydimsIntArray(a);
			Tint *cp=c.IntPtr(), *ap=a.IntPtr();
			for (i=0; i<a.length(); i++) cp[i] = OP(ap[i]);
			global::nops+= a.length();
		}
		break;
	case KRealArray:
		{
			c.copydimsRealArray(a);
			Treal *cp=c.RealPtr(), *ap=a.RealPtr();
			for (i=0; i<a.length(); i++) cp[i] = OP(ap[i]);
			global::nops+= a.length();
		}
		break;
	case KComplexArray:
		{
			c.copydimsComplexArray(a);
			Tcomplex *cp=c.ComplexPtr(), *ap=a.ComplexPtr();
#			ifdef VECTOR_MACHINE
			OPFNAME(cp,ap,a.length());
#			else
			for (i=0; i<a.length(); i++) cp[i] = OP(ap[i]);
#			endif
			global::nops+= a.length();
		}
		break;
	case KObjectArray:
	case Kfunction:
	case KCfunction:
	case KIntrinsicFunction:
	case Kvoid:
	case Kundef:
		UnaryError(OPCHAR,a);
		break;
	}
}
