#define _GNU_SOURCE

#include <lockfile.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>

static const char *action = NULL;
static char *target_file = NULL;

static void
usage(const char *command_name, FILE *file) {
  char *usage_str = NULL;

  if(strcmp(command_name, "mail-lock") == 0) {
    usage_str = "usage: mail-lock [ user ]\n";
  } else if(strcmp(command_name, "mail-unlock") == 0) {
    usage_str = "usage: mail-unlock [ user ]\n";
  } else if(strcmp(command_name, "mail-touchlock") == 0) {
    usage_str = "usage: mail-touchlock [ user ]\n";
  } else if(strcmp(command_name, "lockfile-create") == 0) {
    usage_str = "usage: lockfile-create file\n";
  } else if(strcmp(command_name, "lockfile-remove") == 0) {
    usage_str = "usage: lockfile-remove file\n";
  } else if(strcmp(command_name, "lockfile-touch") == 0) {
    usage_str = "usage: lockfile-touch file\n";
  } else {
    fprintf(stderr, "lockfile: big problem unknown command name: %s\n",
            command_name);
    exit(1);
  }
  fprintf(file, usage_str);
}

static void
parse_arguments(const int argc, char *argv[]) {
  
  char *cmd_name = rindex(argv[0], '/');
  int mail_cmd_p = 0;
  
  if(cmd_name != NULL) {
    /* Skip the '/' */
    cmd_name++;
  } else {
    cmd_name = argv[0];
  }
  
  if(strcmp(cmd_name, "mail-lock") == 0) {
    action = "lock";
    mail_cmd_p = 1;
  } 
  else if(strcmp(cmd_name, "mail-unlock") == 0) {
    action = "unlock";
    mail_cmd_p = 1;
  }
  else if(strcmp(cmd_name, "mail-touchlock") == 0) {
    action = "touch";
    mail_cmd_p = 1;
  }
  else if(strcmp(cmd_name, "lockfile-create") == 0) {
    action = "lock";
  } 
  else if(strcmp(cmd_name, "lockfile-remove") == 0) {
    action = "unlock";
  }
  else if(strcmp(cmd_name, "lockfile-touchlock") == 0) {
    action = "touch";
  } else {
    usage(cmd_name, stderr);
    exit(1);
  }

  if(mail_cmd_p) {
    if(argc == 2) {
      if(asprintf(&target_file, "/var/spool/mail/%s", argv[1]) == -1) {
        fprintf(stderr, "asprintf failed: line %d\n", __LINE__);
        exit(1);
      }
    } else if(argc == 1) {
      if(asprintf(&target_file, "/var/spool/mail/%s", getlogin()) == -1) {
        fprintf(stderr, "asprintf failed: line %d\n", __LINE__);
        exit(1);
      }
    } else {
      usage(cmd_name, stderr);
      exit(1);
    }
  } else {
    if(argc != 2) {
      usage(cmd_name, stderr);
      exit(1);
    }
    target_file = argv[1];
  }
}

static void
handle_touchdeath(int sig) {
  exit(0);
}

int
main(int argc, char *argv[]) {
  int result = 0;
  char * lockfilename = NULL;

  parse_arguments(argc, argv);

  if(asprintf(&lockfilename, "%s.lock", target_file) == -1) {
    fprintf(stderr, "asprintf failed: line %d\n", __LINE__);
    exit(1);
  }
  
  if(strcmp(action, "unlock") == 0) {
    lockfile_remove(lockfilename);
  }
  else if(strcmp(action, "lock") == 0) {
    if(lockfile_create(lockfilename, 10) == L_SUCCESS) {
      result = 0;
    } else {
      fprintf(stderr, "lockfile creation failed\n");
      result = 1;
    }
  }
  else if(strcmp(action, "touch") == 0) {
    signal(SIGTERM, handle_touchdeath);
    while(1) {
      lockfile_touch(lockfilename);
      sleep(60);
    }
  }

  if(lockfilename) free(lockfilename);
  return(0);
}
