/*
 * hold.c: handles buffering of display output.
 *
 * Written By Michael Sandrof 
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#if 0
static	char	rcsid[] = "@(#)$Id: hold.c,v 1.7 1994/07/02 02:32:13 mrg Exp $";
#endif

#include "irc.h"

#include "ircaux.h"
#include "window.h"
#include "screen.h"
#include "vars.h"
#include "input.h"

/* reset_hold: Make hold_mode behave like VM CHAT, hold only
 * when there is no user interaction, this should be called
 * whenever the user does something in a window.  -lynx
 */
#ifdef __STDC__
void	reset_hold (Window *win)
#else
void	reset_hold(win)
Window	*win;
#endif
{
	if (!win)
		win = curr_scr_win;
	if (!win->scrolled_lines)
		win->line_cnt = 0;
}

/* add_to_hold_list: adds str to the hold list queue */
#ifdef __STDC__
void	add_to_hold_list (Window *window, char *str, int logged)
#else 
void	add_to_hold_list(window, str, logged)
Window	*window;
char	*str;
int	logged;
#endif
{
	Hold	*new;
	unsigned int	max;

	new = (Hold *) new_malloc(sizeof(Hold));
	new->str = (char *) 0;
	malloc_strcpy(&(new->str), str);
	new->logged = logged;
	window->held_lines++;
	if ((max = get_int_var(HOLD_MODE_MAX_VAR)) != 0)
	{
		if (window->held_lines > max)
			hold_mode(window, OFF, 1);
	}
	new->next = window->hold_head;
	new->prev = (Hold *) 0;
	if (window->hold_tail == (Hold *) 0)
		window->hold_tail = new;
	if (window->hold_head)
		window->hold_head->prev = new;
	window->hold_head = new;
	update_all_status();
}

/* remove_from_hold_list: pops the next element off the hold list queue. */
#ifdef __STDC__
void	remove_from_hold_list (Window *window)
#else
void	remove_from_hold_list(window)
Window	*window;
#endif
{
	Hold	*crap;

	if (window->hold_tail)
	{
		window->held_lines--;
		new_free(&window->hold_tail->str);
		crap = window->hold_tail;
		window->hold_tail = window->hold_tail->prev;
		if (window->hold_tail == (Hold *) 0)
			window->hold_head = window->hold_tail;
		else
			window->hold_tail->next = (Hold *) 0;
		new_free((char **)&crap);
		update_all_status();
	}
}

/*
 * hold_mode: sets the "hold mode".  Really.  If the update flag is true,
 * this will also update the status line, if needed, to display the hold mode
 * state.  If update is false, only the internal flag is set.  
 */
#ifdef __STDC__
void	hold_mode (Window *window, int flag, int update)
#else
void	hold_mode(window, flag, update)
Window	*window;
int	flag,
	update;
#endif
{
	if (window == (Window *) 0)
		window = curr_scr_win;
	if (flag != ON && window->scrolled_lines)
		return;
	if (flag == TOGGLE)
	{
		if (window->held == OFF)
			window->held = ON;
		else
			window->held = OFF;
	}
	else
		window->held = flag;

	if (update)
	{
		if (window->held != window->last_held)
		{
			window->last_held = window->held;
					/* This shouldn't be done
					 * this way */
			update_window_status(window, 0);
			if (window->update | UPDATE_STATUS)
				window->update -= UPDATE_STATUS;
			cursor_in_display();
			update_input(NO_UPDATE);
		}
	}
	else
		window->last_held = -1;
}

/*
 * hold_output: returns the state of the window->held, which is set in the
 * hold_mode() routine. 
 */
#ifdef __STDC__
int	hold_output (Window *window)
#else
int	hold_output(window)
Window	*window;
#endif
{
	if (!window)
		window = curr_scr_win;
	return (window->held == ON) || (window->scrolled_lines != 0);
}

/*
 * hold_queue: returns the string value of the next element on the hold
 * quere.  This does not change the hold queue 
 */
#ifdef __STDC__
char	*hold_queue (Window *window)
#else
char	*hold_queue(window)
Window	*window;
#endif
{
	if (window->hold_tail)
		return (window->hold_tail->str);
	else
		return ((char *) 0);
}

#ifdef __STDC__
int	hold_queue_logged (Window *window)
#else
int	hold_queue_logged(window)
Window	*window;
#endif
{
	if (window->hold_tail)
		return window->hold_tail->logged;
	else
		return 0;
}

/* toggle_stop_screen: the BIND function TOGGLE_STOP_SCREEN */
#ifdef __STDC__
extern void toggle_stop_screen (char unused, char *not_used)
#else
extern void toggle_stop_screen (unused, not_used)
char unused, *not_used;
#endif
{
	hold_mode((Window *) 0, TOGGLE, 1);
	update_all_windows();
}
