
# Description:  This file includes procedures for automatical loading
#               and saving of baninfos (for JOIN, LEAVE and SIGNOFF).
#               Procedure `load_baninfos' will be executed 30 seconds
#               after you have joined the channel, because tkirc tries
#               to get the current banlist for that channel first. If
#               you always have a fast connection, you can take a 
#               smaller value than 30000 (milliseconds).
#
# Date:         03.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/baninfos-support.tcl'
#               2. edit `baninfos_list' (see the examples below)
#               3. reload your tkircrc or restart tkirc


# baninfos_list: Each entry includes two values. The first is the channel
#                you want to load/save baninfos for, and the second is for
#                the filepath you want to save the data in.
global baninfos_list
set baninfos_list {
    {"#tkirc" "~/.tkirc/baninfos-tkirc"}
}

# on_join_bis: Saved baninfos will automatically be loaded, when you 
#              join the right channel.
proc on_join_bis { } {
  global on_args baninfos_list crapwindow nickname

  if {[strcmp "$on_args(nick)" "$nickname"] == 0} {
    foreach x "$baninfos_list" {
      if {[strcmp "$on_args(channel)" "[lindex "$x" 0]"] == 0} {
	  after 20000 [list parsein $crapwindow "/loadbaninfos [lindex "$x" 0] [lindex "$x" 1]"]
      }
    }
  }
}

# on_leave_bis: The current baninfos of the left channel will be
#               saved.
proc on_leave_bis { } {
  global on_args baninfos_list crapwindow nickname

  if {[strcmp "$on_args(nick)" "$nickname"] == 0} {
    foreach x "$baninfos_list" {
      if {[strcmp "$on_args(channel)" "[lindex "$x" 0]"] == 0} {
	parsein $crapwindow "/savebaninfos [lindex "$x" 0] [lindex "$x" 1]"
      }
    }
  }
}

# on_signoff_bis: The current baninfos of all joined channels will be
#                 saved before signoff.
proc on_signoff_bis { } {
  global on_args baninfos_list crapwindow chan nickname

  if {[strcmp "$on_args(nick)" "$nickname"] == 0} {
    foreach x "$baninfos_list" {
      foreach y "$chan(list)" {
        if {[strcmp "$chan($y)" "[lindex "$x" 0]"] == 0} {
	  parsein $crapwindow "/savebaninfos [lindex "$x" 0] [lindex "$x" 1]"
	}
      }
    }
  }
}
