#include "main.h"

/******************************************************
  WRITE_ALL_CONFIG
  *******************************************************/
/* dumps all configured variables to file called 
   dqs_config                                        */
void write_all_config()
{
       FILE *outfd;
       
       
       if(!(outfd = fopen("dqs_config","w"))) {
	      err_crit("Can't open config file for writing\n");
	      return;
       }
       fprintf(outfd,"STATIC_CONFIGURATION      %s\n",static_configuration);  
       fprintf(outfd,"QMASTER_SPOOL_DIR         %s\n",qmaster_spool_dir);
       fprintf(outfd,"EXECD_SPOOL_DIR           %s\n",execd_spool_dir);
       fprintf(outfd,"DEFAULT_CELL              %s\n",default_cell);
       fprintf(outfd,"RESERVED_PORT             %s\n",reserved_port);
       fprintf(outfd,"DQS_EXECD_SERVICE         %s\n",dqs_execd_service);
       fprintf(outfd,"QMASTER_SERVICE           %s\n",qmaster_service);
       fprintf(outfd,"INTERCELL_SERVICE         %s\n",intercell_service);
       
       fprintf(outfd,"KLOG                      %s\n",klog);
       fprintf(outfd,"REAUTH_TIME               %s\n",reauth_time);
       fprintf(outfd,"MAILER                    %s\n",mailer);
       fprintf(outfd,"DQS_BIN                   %s\n",dqs_bin);
       fprintf(outfd,"ADMINISTRATOR             %s\n",administrator);
       fprintf(outfd,"DEFAULT_ACCOUNT           %s\n",default_account);
       fprintf(outfd,"DEFAULT_HOST              %s\n",default_host);
       
       fprintf(outfd,"LOGMAIL                   %s\n",log_mail); 
       fprintf(outfd,"DEFAULT_RERUN             %s\n",default_rerun);
       fprintf(outfd,"DEFAULT_SORT_SEQ_NO       %s\n",default_sort_seq_no);
       fprintf(outfd,"SYNC_IO                   %s\n",sync_io);
       
       
       fprintf(outfd,"USER_ACCESS               %s\n",user_access);
       fprintf(outfd,"LOGFACILITY               %s\n",logfacility);
       fprintf(outfd,"LOGLEVEL                  %s\n",loglevel);
       fprintf(outfd,"MIN_UID                   %s\n",min_uid);
       fprintf(outfd,"MIN_GID                   %s\n",min_gid);
       fprintf(outfd,"MAXUJOBS                  %s\n",maxujobs);
       
       fprintf(outfd,"LOAD_LOG_TIME             %s\n",load_log_time);
       fprintf(outfd,"STAT_LOG_TIME             %s\n",stat_log_time);
       fprintf(outfd,"SCHEDULE_TIME             %s\n",schedule_time);
       fprintf(outfd,"MAX_UNHEARD               %s\n",max_unheard);
       fprintf(outfd,"ALARMS                    %s\n",alarms);
       fprintf(outfd,"ALARMM                    %s\n",alarmm);
       fprintf(outfd,"ALARML                    %s\n",alarml);
       
       
       fprintf(outfd,"CONF_FILE                 %s\n",conf_file);
       fprintf(outfd,"RESOLVE_FILE              %s\n",resolve_file);
       fprintf(outfd,"KEY_FILE                  %s\n",key_file);
       fprintf(outfd,"AFS                       %s\n",afs);
       fprintf(outfd,"ERR_FILE                  %s\n",err_file);
       fprintf(outfd,"LOG_FILE                  %s\n",log_file);
       fprintf(outfd,"MAIL_HAS_SUBJ_LINE        %s\n",mail_has_subj_line);
       fprintf(outfd,"DEFAULT_MANAGER           %s\n",default_manager);
       
       /* makefile stuff */
       fprintf(outfd,"INSTALL_DIR               %s\n",install_dir);
       fprintf(outfd,"BIN_DIR                   %s\n",bin_dir);
       fprintf(outfd,"CONF_DIR                  %s\n",conf_dir);
       fprintf(outfd,"DOC_DIR                   %s\n",doc_dir);
       fprintf(outfd,"LIB_DIR                   %s\n",lib_dir);
       fprintf(outfd,"MAN1_DIR                  %s\n",man1_dir);
       fprintf(outfd,"MAN3_DIR                  %s\n",man3_dir);
       fprintf(outfd,"ROOT                      %s\n",root);
       fprintf(outfd,"DQS_ROOT                  %s\n",dqs_root);
       fprintf(outfd,"SYSGRP                    %s\n",sysgrp);
       fprintf(outfd,"DQS_SYSGRP                %s\n",dqs_sysgrp);
       fprintf(outfd,"CC                        %s\n",cc);
       
       if(has_manager2){
              fprintf(outfd,"DEFAULT_MANAGER2           %s\n",default_manager2);
       }
       if(has_automount){
              fprintf(outfd,"AUTO_MOUNT                 %s\n",automount);
       }
       fclose(outfd);  
}


/**********************************************************************
  READ_ALL_CONFIG
  ***********************************************************************/
void read_all_config(config_file)
char *config_file;
{
       FILE *outfd;
       char *tmp;  
       char buf[MAXSTR];
       char ln1[MAXSTR];
       char ln2[MAXSTR];
       char *tok1 , *tok2;
       char c;       
       if(!(outfd = fopen(config_file,"r"))) {
	      err_cont("can't open config file for writing\n");
	      return;
       }
       static_configuration = jread(outfd,"STATIC_CONFIGURATION");
       qmaster_spool_dir    = jread(outfd,"QMASTER_SPOOL_DIR");
       execd_spool_dir      = jread(outfd,"EXECD_SPOOL_DIR");
       default_cell         = jread(outfd,"DEFAULT_CELL");
       reserved_port        = jread(outfd,"RESERVED_PORT");
       dqs_execd_service    = jread(outfd,"DQS_EXECD_SERVICE");
       qmaster_service      = jread(outfd,"QMASTER_SERVICE");
       intercell_service    = jread(outfd,"INTERCELL_SERVICE");       
       klog                 = jread(outfd,"KLOG");
       reauth_time          = jread(outfd,"REAUTH_TIME");
       mailer               = jread(outfd,"MAILER");
       dqs_bin              = jread(outfd,"DQS_BIN");
       administrator        = jread(outfd,"ADMINISTRATOR");
       default_account      = jread(outfd,"DEFAULT_ACCOUNT");
       default_host         = jread(outfd,"DEFAULT_HOST");
       log_mail             = jread(outfd,"LOGMAIL");
       default_rerun        = jread(outfd,"DEFAULT_RERUN");
       default_sort_seq_no  = jread(outfd,"DEFAULT_SORT_SEQ_NO");
       sync_io              = jread(outfd,"SYNC_IO");
       
       user_access          = jread(outfd,"USER_ACCESS");
       logfacility          = jread(outfd,"LOGFACILITY");
       loglevel             = jread(outfd,"LOGLEVEL");
       min_uid              = jread(outfd,"MIN_UID");
       min_gid              = jread(outfd,"MIN_GID");
       maxujobs             = jread(outfd,"MAXUJOBS");
       output_handling      = jread(outfd,"OUTPUT_HANDLING");       
       addon_script         = jread(outfd,"ADDON_SCRIPT");       
       addon_info           = jread(outfd,"ADDON_INFO");
       load_log_time        = jread(outfd,"LOAD_LOG_TIME");
       stat_log_time        = jread(outfd,"STAT_LOG_TIME");
       schedule_time        = jread(outfd,"SCHEDULE_TIME");
       max_unheard          = jread(outfd,"MAX_UNHEARD");
       alarms               = jread(outfd,"ALARMS");
       alarmm               = jread(outfd,"ALARMM");
       alarml               = jread(outfd,"ALARML");
       
       
       
       conf_file            = jread(outfd,"CONF_FILE");
       resolve_file         = jread(outfd,"RESOLVE_FILE");
       key_file             = jread(outfd,"KEY_FILE");
       afs                  = jread(outfd,"AFS");
       err_file             = jread(outfd,"ERR_FILE");
       log_file             = jread(outfd,"LOG_FILE");
       mail_has_subj_line   = jread(outfd,"MAIL_HAS_SUBJ_LINE");
       default_manager      = jread(outfd,"DEFAULT_MANAGER");
       
       
       /* makefile stuff */
       install_dir          = jread(outfd,"INSTALL_DIR");
       bin_dir              = jread(outfd,"BIN_DIR");
       conf_dir             = jread(outfd,"CONF_DIR");
       doc_dir              = jread(outfd,"DOC_DIR");
       lib_dir              = jread(outfd,"LIB_DIR");
       man1_dir             = jread(outfd,"MAN1_DIR");
       man3_dir             = jread(outfd,"MAN3_DIR");
       root                 = jread(outfd,"ROOT");
       dqs_root             = jread(outfd,"DQS_ROOT");
       sysgrp               = jread(outfd,"SYSGRP");
       dqs_sysgrp           = jread(outfd,"DQS_SYSGRP");
       cc                   = jread(outfd,"CC");
       
       /* possible to have the next two lines
	  DEFAULT_MANAGER2  chump
	  AUTO_MOUNT        /tmp-mnt
	  or not check to see if they are there */

       
       
       DTRACE;       
       
       has_manager2=0;
       has_automount=0;
       
       bzero(buf,MAXSTR);
       bzero(ln1,MAXSTR);
       
       if(!fgets(buf,MAXSTR,outfd)) return;
       
       squeeze_space(buf);
       delete_ltr_spaces(buf);
       if(!buf) return;
       
       strcpy(ln1,buf);
       if(!(tok1 = strtok(buf," \t"))) return;
       
       DPRINTF(("tok1 ==:%s:\n",tok1));
       if(!(  strcmp( tok1,"DEFAULT_MANAGER2"))){
	        /* 1st line has def manager2*/
	      MALLOC_STR(default_manager2);
	      tok1 = strtok((char*)NULL," \n\0");
	      strcpy(default_manager2,tok1);
	      DPRINTF(("default_manager2 ==:%s:\n",default_manager2));
	      has_manager2=1;
       }
       
       if(!has_manager2)      strcpy(buf,ln1); /* restore buf*/
       else{
	      if(!fgets(buf,MAXSTR,outfd)) return;
	      squeeze_space(buf);
	      delete_ltr_spaces(buf);
	      if(!buf) return;
       }

       if(!(tok1 = strtok(buf," \t"))) return;
       
       if(!(  strcmp( tok1,"AUTO_MOUNT"))){
              MALLOC_STR(automount);
              tok1 = strtok((char*)NULL," \n\0");
              strcpy(automount,tok1);
              DPRINTF(("automount ==:%s:\n",automount));
              has_automount=1;
       }
       
}

/******************************************************************
 *                          JREAD
 *******************************************************************/
/* reads in from file pointer fd. checks to make sure that
   str matches the first thing on the line and then reads
   rest of line into target str. Mallocs space for target str      */

char* jread(fd,str)
FILE *fd;
char *str;
{
       char * target;
       char buf[MAXSTR];
       char *tok1 , *tok2;
       
       MALLOC_STR(target);
       jbzero(buf,MAXSTR);
       if (!fgets(buf,MAXSTR,fd)) {
	      DPRINTF(("fgets returning null\n"));
	      return ((char*)NULL);
       }
       PUT_NULLN(buf);
       /*       squeeze_space(buf);
		delete_ltr_spaces(buf);
		*/
       
       tok1 = strtok(buf," ");
       DPRINTF(("1st token read in == :%s:\n",tok1));
       if(strcmp(str,tok1)!=0){
	      printf("got :%s: was expecting :%s:\n",tok1,str);
	      err_crit("Non-match\n");
       }
       tok2 = strtok((char*)NULL," \0");
       
       
       if(tok2) DPRINTF(("2nd token read in == :%s:\n",tok2));
       else 
       DPRINTF(("tok2 is null\n"));
       
       strcpy(target,tok2);
       PUT_NULL(target);
       DPRINTF(("returning target ==:%s:\n",target));
       return(target);
       
       
}

