/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <Xm/Label.h>
#include <Xm/Form.h>
#include <Xm/TextF.h>
#include "xdir.h"

static struct {
	Widget w_dialog;
	Widget w_pathLabel;
	Widget w_path;
} mp_monitor;

extern Widget w_toplev;
extern Display *display;

void cb_mp_monitor_close();
void cb_map_dialog();


/*
 * show_mp_monitor - Pop up multipurpose monitor over directory window
 *                   "dirwin".
 */
show_mp_monitor(dirwin, path_label)
struct dirwin_st *dirwin;
char *path_label;
{
	XmString string;

	create_mp_monitor_dialog(dirwin);

	/* Update the path label */
	string = XmStringCreateSimple(path_label);
	XtVaSetValues(mp_monitor.w_pathLabel, XmNlabelString, string, NULL);
	XmStringFree(string);

	/* Pop up dialog */
	XtManageChild(mp_monitor.w_dialog);
	add_dialog_to_list(mp_monitor.w_dialog);
	force_update(mp_monitor.w_dialog);
}


/*
 * create_mp_monitor_dialog - Create dialog window that displays the
 *                            directory entry currently being operated on.
 *                            Position over directory window "dirwin".
 */
create_mp_monitor_dialog(dirwin)
struct dirwin_st *dirwin;
{
	Arg args[1];
	XmString label;
	int i;

    /* Create form dialog to display current entry being operated on */
    i = 0;
	XtSetArg(args[i], XmNresizePolicy, XmRESIZE_NONE); i++;
    mp_monitor.w_dialog = XmCreateFormDialog(dirwin->w_shell, "mpMonitor",
		args, i);
	XtAddCallback(mp_monitor.w_dialog, XmNmapCallback, cb_map_dialog,
		(XtPointer)XtWindow(dirwin->w_shell));

	/* Add callback for the WM_DELETE_WINDOW protocol */
	add_wm_delete_window_cb(mp_monitor.w_dialog, cb_mp_monitor_close, NULL,
		False);

	/* Create path label */
	label = XmStringCreateSimple("");
    mp_monitor.w_pathLabel = XtVaCreateManagedWidget(
        "pathLabel",
        xmLabelWidgetClass,
        mp_monitor.w_dialog,
        XmNlabelString,     	label,
		XmNtopAttachment,		XmATTACH_FORM,
		XmNtopOffset,			25,
		XmNleftAttachment,		XmATTACH_FORM,
		XmNleftOffset,			15,
		XmNbottomAttachment,	XmATTACH_FORM,
		XmNbottomOffset,		25,
        NULL
    );
    XmStringFree(label);

    /* Create path name */
    mp_monitor.w_path = XtVaCreateManagedWidget(
        "path",
        xmTextFieldWidgetClass,
        mp_monitor.w_dialog,
		XmNshadowThickness,			0,
		XmNmarginHeight,			0,
		XmNmarginWidth,				0,
		XmNtraversalOn,				False,
		XmNeditable,				False,
		XmNcursorPositionVisible,	False,
        XmNtopAttachment,   		XmATTACH_OPPOSITE_WIDGET,
        XmNtopWidget,       		mp_monitor.w_pathLabel,
		XmNtopOffset,				-1,
        XmNleftAttachment,  		XmATTACH_WIDGET,
		XmNleftWidget,				mp_monitor.w_pathLabel,
        XmNleftOffset,      		5,
		XmNrightAttachment,			XmATTACH_FORM,
        NULL
    );
}


/*
 * update_mp_monitor - Update the multipurpose monitor to display the
 *                     directory entry currently being operated on.
 */
update_mp_monitor(path)
char *path;
{
	XmTextFieldSetString(mp_monitor.w_path, path);
	XSync(display, 0);
	XmUpdateDisplay(w_toplev);
}


/*
 * hide_mp_monitor - Pop down the multipurpose monitor.
 */
hide_mp_monitor()
{
	/* Remove dialog from cursor linked list */
	remove_dialog_from_list(mp_monitor.w_dialog);

	/* Get rid of multipurpose monitor */
	XtDestroyWidget(XtParent(mp_monitor.w_dialog));
}


/*
 * cb_mp_monitor_close - Callback to handle closes from window manager.
 *                       A close is not allowed.
 */
void
cb_mp_monitor_close(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	beep();
}

