/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995-1998.  The Regents of the University of California.  All     */
/*   rights reserved.                                                      */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <Xm/Xm.h>
#include "xdir.h"

#define PREFSFILE  ".xdirrc"

int need_to_save_prefs = False;

static char *prefs_file;


/*
 * construct_prefs_filename - Form preferences file name by concatenating
 *                            .xdirrc to $HOME.
 */
construct_prefs_filename()
{
	char *homedir = getenv("HOME");

	prefs_file = XtMalloc(strlen(homedir)+strlen(PREFSFILE)+2);
	strcpy(prefs_file, homedir);
	strcat(prefs_file, "/");
	strcat(prefs_file, PREFSFILE);
}


/*
 * read_prefs_from_file - Initialize preferences with values from a disk file.
 */
read_prefs_from_file()
{
	static FILE *fp;
	int new_prefs;

	/* Try to open preferences file */
	fp = fopen(prefs_file, "r");     /* Note: fp might be null */

	/* Read general preferences */
	new_prefs = read_gprefs_from_file(fp);

	/* Read viewer preferences */
	if (fp)
		rewind(fp);
	read_vprefs_from_file(fp);

	/* Read launcher preferences */
	if (fp)
		rewind(fp);
	read_lprefs_from_file(fp);

	/* Read firewall preferences */
	if (fp)
		rewind(fp);
	read_fprefs_from_file(fp);

	/* Close file */
	if (fp)
		fclose(fp);

	/* If new user prefs added by programmer, save prefs */
	if (new_prefs && save_prefs())
		fatal_error("Unable to save user preferences.");
}


/*
 * save_prefs - Write user, viewer and launcher preferences to .xdirrc.
 *              Returns 0 if successful, else -1.
 */
save_prefs()
{
	FILE *fp;

	/* Try to create preferences file */
	if ((fp = fopen(prefs_file, "w")) == NULL)
		return -1;

	/* Now save the preferences */
	save_gprefs(fp);
	save_vprefs(fp);
	save_lprefs(fp);
	save_fprefs(fp);

	/* Clean up */
	fclose(fp);
	need_to_save_prefs = False;
	return 0;
}


/*
 * cb_save_prefs - Callback that saves current preferences to a disk file.
 */
void
cb_save_prefs(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	/* Clear error flag */
	raise_okflag();

	if (save_prefs())
		warn("Unable to save preferences.", dirwin->w_shell);
}

