/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.fortran;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.fortran.Fortran;
import gov.llnl.babel.backend.fortran.StubSource;
import gov.llnl.babel.backend.mangler.FortranMangler;
import gov.llnl.babel.backend.mangler.NameMangler;
import gov.llnl.babel.backend.mangler.NonMangler;
import gov.llnl.babel.backend.writers.LanguageWriter;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SkelSource {
    private static final String[] s_ensureOrderConstant = new String[]{"sidl_general_order", "sidl_column_major_order", "sidl_row_major_order"};
    private static final String s_proxy = "_proxy_";
    private static final String s_proxyTwo = "_alt_";
    private static final String s_buffer = "_buf_";
    private static final String s_epv = "_epv";
    private static final String s_exceptionFundamentalType = BabelConfiguration.getBaseExceptionType();
    private LanguageWriterForC d_writer;
    private NameMangler d_mang;
    private final boolean d_isF90 = Fortran.isFortran90();

    public SkelSource(LanguageWriterForC writer) throws NoSuchAlgorithmException {
        this.d_writer = writer;
        this.d_mang = Fortran.needsAbbrev() ? new FortranMangler(31, 21) : new NonMangler();
    }

    private void generateExtern(String name, List args) throws CodeGenerationException {
        StubSource.generateSignature(this.d_writer, name, args);
        this.d_writer.println(";");
    }

    private void writeArgValue(String argName, int mode) {
        if (mode != 0 && !"retval".equals(argName)) {
            this.d_writer.print("*");
        }
        this.d_writer.print(argName);
    }

    private void writeSkelArgs(List args) throws CodeGenerationException {
        int argsWritten = 0;
        Iterator i = args.iterator();
        boolean comma = false;
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            if ("retval".equals(a.getFormalName())) continue;
            if (comma) {
                this.d_writer.println(",");
            }
            this.d_writer.print(IOR.getArgumentWithFormal(a, true, false, false));
            ++argsWritten;
            comma = true;
        }
        if (argsWritten == 0) {
            this.d_writer.print("void");
        }
    }

    private void declareProxy(String argName, Type argType, int argMode) throws CodeGenerationException {
        String pre = "fortran.SkelSource.declareProxy: ";
        switch (argType.getDetailedType()) {
            case 11: {
                this.d_writer.println("int _proxy_" + argName + " = 0;");
                break;
            }
            case 1: {
                this.d_writer.println(Fortran.getFortranPrefix() + "_Bool " + s_proxy + argName + ";");
                break;
            }
            case 16: {
                if (this.d_isF90) {
                    if (argType.isRarray()) {
                        this.d_writer.println(SkelSource.getReturnString(argType) + " " + s_proxy + argName + " = 0;");
                        break;
                    }
                    this.d_writer.println(Fortran.getFortranTypeInC(argType) + " " + s_proxy + argName + " = { 0 };");
                    if (!Fortran.hasDirectAccess(argType) || 2 == argMode) break;
                    this.d_writer.println(SkelSource.getReturnString(argType) + " " + s_proxyTwo + argName + " = 0;");
                    break;
                }
                this.d_writer.println((argType.isRarray() ? SkelSource.getReturnString(argType) : Fortran.getFortranTypeInC(argType)) + " " + s_proxy + argName + " = 0;");
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                this.d_writer.println("int64_t _proxy_" + argName + " = 0;");
                break;
            }
            case 10: {
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL(" + s_proxy + argName + ");");
                break;
            }
            case 2: {
                this.d_writer.printlnUnformatted(StubSource.s_charCheck);
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL(" + s_proxy + argName + ");");
                this.d_writer.println("char _buf_" + argName + "[2];");
                this.d_writer.printlnUnformatted("#endif");
                break;
            }
            case 15: {
                throw new CodeGenerationException("fortran.SkelSource.declareProxy: Unable to process " + argType.getTypeString() + ' ' + argName);
            }
            default: {
                if (!"retval".equals(argName)) break;
                this.d_writer.println(SkelSource.getReturnString(argType) + ' ' + s_proxy + argName + ";");
            }
        }
    }

    private void declareProxies(List args) throws CodeGenerationException {
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            String name = a.getFormalName();
            int mode = a.getMode();
            this.declareProxy(name, t, mode);
        }
    }

    private void declareIndexAndInit(Argument rawArray, Argument index, int dimen) throws CodeGenerationException {
        this.d_writer.print(Fortran.getFortranTypeInC(index.getType()) + ' ' + index.getFormalName() + " = sidlLength(");
        this.writeArgValue(rawArray.getFormalName(), rawArray.getMode());
        this.d_writer.println(", " + Integer.toString(dimen) + ");");
    }

    private void declareIndices(Map indexArgs) throws CodeGenerationException {
        if (indexArgs != null) {
            Iterator i = indexArgs.keySet().iterator();
            while (i.hasNext()) {
                Collection choice = (Collection)indexArgs.get(i.next());
                if (choice.size() <= 0) continue;
                Method.RarrayInfo info = (Method.RarrayInfo)choice.iterator().next();
                this.declareIndexAndInit(info.rarray, info.index, info.dim);
            }
        }
    }

    private void ensureArray(Type array, String argName, int mode) {
        if (array.hasArrayOrderSpec()) {
            Type elemType = array.getArrayType();
            this.d_writer.println();
            this.d_writer.tab();
            this.d_writer.println(Fortran.getEnsureArray(elemType));
            this.d_writer.tab();
            this.writeArgValue(argName, mode);
            this.d_writer.println(",");
            this.d_writer.println(array.getArrayDimension() + ",");
            this.d_writer.println(s_ensureOrderConstant[array.getArrayOrder()] + ")");
            this.d_writer.backTab();
            this.d_writer.backTab();
        } else {
            this.writeArgValue(argName, mode);
        }
    }

    private void initializeProxy(String argName, Type argType, int mode) throws CodeGenerationException {
        String pre = "fortran.SkelSource.initializeProxy: ";
        switch (argType.getDetailedType()) {
            case 16: {
                if (mode == 2) break;
                Type dataType = argType.getArrayType();
                if (this.d_isF90 && Fortran.hasDirectAccess(argType)) {
                    if (argType.isRarray()) {
                        this.d_writer.print(s_proxy + argName + " = ");
                        this.ensureArray(argType, argName, mode);
                        this.d_writer.println(";");
                        break;
                    }
                    this.d_writer.print(s_proxyTwo + argName + " = ");
                    this.ensureArray(argType, argName, mode);
                    this.d_writer.println(";");
                    this.d_writer.println("if (sidl_" + dataType.getTypeString() + "__array_convert2f90(" + s_proxyTwo + argName + ", " + argType.getArrayDimension() + ", &" + s_proxy + argName + ")) {");
                    this.d_writer.tab();
                    if (!argType.hasArrayOrderSpec()) {
                        this.d_writer.println(s_proxyTwo + argName + " = " + Fortran.getEnsureArray(dataType) + s_proxyTwo + argName + ", " + argType.getArrayDimension() + ", sidl_column_major_order);");
                        this.d_writer.println("if (sidl_" + dataType.getTypeString() + "__array_convert2f90(" + s_proxyTwo + argName + ", " + argType.getArrayDimension() + ", &" + s_proxy + argName + ")) {");
                        this.d_writer.tab();
                    }
                    this.d_writer.writeCommentLine("We're S.O.L");
                    this.d_writer.println("fprintf(stderr, \"convert2f90 failed: %p %d\\n\", (void*)" + argName + ", " + argType.getArrayDimension() + ");");
                    this.d_writer.println("exit(1); /*NOTREACHED*/");
                    if (!argType.hasArrayOrderSpec()) {
                        this.d_writer.backTab();
                        this.d_writer.println("}");
                    }
                    this.d_writer.backTab();
                    this.d_writer.println("}");
                    break;
                }
                this.d_writer.print(s_proxy + argName + Fortran.arrayIOR() + " = (");
                if (!argType.isRarray()) {
                    this.d_writer.print("(ptrdiff_t)");
                }
                this.ensureArray(argType, argName, mode);
                this.d_writer.println(");");
                break;
            }
            case 9: 
            case 12: 
            case 13: {
                if (mode == 2) break;
                this.d_writer.print(s_proxy + argName + " = ((ptrdiff_t)");
                this.writeArgValue(argName, mode);
                this.d_writer.println(");");
                break;
            }
            case 11: {
                if (mode == 2) break;
                this.d_writer.print(s_proxy + argName + " = (int)(");
                this.writeArgValue(argName, mode);
                this.d_writer.println(");");
                break;
            }
            case 1: {
                this.d_writer.print(s_proxy + argName + " = ");
                if (mode != 2) {
                    this.d_writer.print("(((");
                    this.writeArgValue(argName, mode);
                    this.d_writer.println(")== TRUE) ? " + Fortran.getFortranPrefix() + "_TRUE " + ": " + Fortran.getFortranPrefix() + "_FALSE);");
                    break;
                }
                this.d_writer.println(Fortran.getFortranPrefix() + "_TRUE;");
                break;
            }
            case 10: {
                if (mode == 0 || mode == 1) {
                    this.d_writer.print(Fortran.getFortranPrefix() + "_STR_COPY(" + s_proxy + argName + ", ");
                    this.writeArgValue(argName, mode);
                    if (mode == 0) {
                        this.d_writer.println(", 0);");
                        break;
                    }
                    this.d_writer.println(", " + Fortran.getFortranPrefix() + "_STR_MINSIZE);");
                    this.d_writer.print("free((void *)");
                    this.writeArgValue(argName, mode);
                    this.d_writer.println(");");
                    this.writeArgValue(argName, mode);
                    this.d_writer.println(" = NULL;");
                    break;
                }
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_COPY(" + s_proxy + argName + ", NULL, " + Fortran.getFortranPrefix() + "_STR_MINSIZE)" + ";");
                break;
            }
            case 2: {
                this.d_writer.printlnUnformatted(StubSource.s_charCheck);
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_LEN(" + s_proxy + argName + ") = 1;");
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_STR(" + s_proxy + argName + ") = " + s_buffer + argName + ";");
                this.d_writer.print(s_buffer + argName + "[0] = ");
                if (2 != mode) {
                    this.writeArgValue(argName, mode);
                } else {
                    this.d_writer.println("' '");
                }
                this.d_writer.println(";");
                this.d_writer.println(s_buffer + argName + "[1] = '\\0';");
                this.d_writer.printlnUnformatted("#endif");
                break;
            }
            case 15: {
                throw new CodeGenerationException("fortran.SkelSource.initializeProxy: Unable to process " + argType.getTypeString() + ' ' + argName);
            }
        }
    }

    private void initializeProxies(List args) throws CodeGenerationException {
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            String name = a.getFormalName();
            this.initializeProxy(name, t, a.getMode());
        }
    }

    private void listNormalArguments(List args) {
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            String name = a.getFormalName();
            if (StubSource.hasProxy(t) || "retval".equals(name)) {
                switch (t.getDetailedType()) {
                    case 10: {
                        this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_ARG(" + s_proxy + name + ")");
                        this.d_writer.println(Fortran.getFortranPrefix() + "_STR_NEAR_LEN(" + s_proxy + name + ")");
                        break;
                    }
                    case 2: {
                        this.d_writer.printlnUnformatted(StubSource.s_charCheck);
                        this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_ARG(" + s_proxy + name + ")");
                        this.d_writer.println(Fortran.getFortranPrefix() + "_STR_NEAR_LEN(" + s_proxy + name + ")");
                        this.d_writer.printlnUnformatted("#else");
                        this.d_writer.println("&_proxy_" + name);
                        this.d_writer.printlnUnformatted("#endif");
                        break;
                    }
                    case 16: {
                        if (t.isRarray()) {
                            this.d_writer.print(s_proxy + name + "->d_firstElement");
                            break;
                        }
                    }
                    default: {
                        this.d_writer.print("&_proxy_" + name);
                        break;
                    }
                }
            } else {
                if (a.getMode() == 0) {
                    this.d_writer.print("&");
                }
                this.d_writer.print(name);
            }
            if (!i.hasNext()) continue;
            this.d_writer.println(",");
        }
    }

    private void listStringLengthArguments(List args) {
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            String name = a.getFormalName();
            switch (t.getDetailedType()) {
                case 10: {
                    this.d_writer.println();
                    this.d_writer.print(Fortran.getFortranPrefix() + "_STR_FAR_LEN(" + s_proxy + name + ")");
                    break;
                }
                case 2: {
                    this.d_writer.println();
                    this.d_writer.printlnUnformatted(StubSource.s_charCheck);
                    this.d_writer.println(Fortran.getFortranPrefix() + "_STR_FAR_LEN(" + s_proxy + name + ")");
                    this.d_writer.printlnUnformatted("#endif");
                }
            }
        }
    }

    private void callMethod(String methodName, List args) throws CodeGenerationException {
        this.d_writer.println(Fortran.getFortranSymbol() + "(" + methodName.toLowerCase() + "," + methodName.toUpperCase() + "," + methodName + ")(");
        this.d_writer.tab();
        this.listNormalArguments(args);
        this.listStringLengthArguments(args);
        this.d_writer.println(");");
        this.d_writer.backTab();
    }

    private void checkExceptionBlock(Method m) throws CodeGenerationException {
        if (!m.getThrows().isEmpty()) {
            Symbol symbol = Utilities.lookupSymbol(s_exceptionFundamentalType);
            this.d_writer.println("if (_proxy_exception) {");
            this.d_writer.tab();
            switch (m.getReturnType().getDetailedType()) {
                case 0: {
                    break;
                }
                case 3: 
                case 5: {
                    this.d_writer.println("retval = {0,0};");
                    break;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 16: {
                    this.d_writer.println("retval = NULL;");
                    break;
                }
                default: {
                    this.d_writer.println("retval = 0;");
                }
            }
            this.d_writer.println("*exception = (" + IOR.getSymbolType(symbol) + ")");
            this.d_writer.tab();
            this.d_writer.println("(ptrdiff_t)(_proxy_exception);");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
        }
    }

    private void endExceptionBlock(Method m) {
        if (!m.getThrows().isEmpty()) {
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
    }

    public void doOutArg(Type argType, String argName, int mode) throws CodeGenerationException {
        String pre = "fortran.SkelSource.doOutArg: ";
        switch (argType.getDetailedType()) {
            case 16: {
                if (1 == mode && argType.hasArrayOrderSpec()) {
                    this.d_writer.print(Fortran.getDelRefArray(argType.getArrayType()));
                    this.writeArgValue(argName, mode);
                    this.d_writer.println(");");
                }
                if (0 != mode) {
                    String modName = "(" + SkelSource.getReturnString(argType) + ")" + (argType.isRarray() ? s_proxy + argName : "(ptrdiff_t)(_proxy_" + argName + Fortran.arrayIOR() + ")");
                    this.writeArgValue(argName, mode);
                    this.d_writer.print(" = (" + SkelSource.getReturnString(argType) + ")");
                    this.ensureArray(argType, modName, 0);
                    this.d_writer.println(";");
                }
                if (!argType.hasArrayOrderSpec()) break;
                this.d_writer.print(Fortran.getDelRefArray(argType.getArrayType()) + (argType.isRarray() ? "(" : "(ptrdiff_t)("));
                this.d_writer.println(s_proxy + argName + (argType.isRarray() ? "" : Fortran.arrayIOR()) + "));");
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                this.writeArgValue(argName, mode);
                this.d_writer.print(" = (" + SkelSource.getReturnString(argType) + ")(ptrdiff_t)");
                this.d_writer.println(s_proxy + argName + ";");
                break;
            }
            case 1: {
                this.writeArgValue(argName, mode);
                this.d_writer.println(" = ((" + Fortran.getFortranPrefix() + "_TRUE == " + s_proxy + argName + ") ? TRUE : FALSE);");
                break;
            }
            case 10: {
                this.writeArgValue(argName, mode);
                this.d_writer.println(" = sidl_trim_trailing_space(");
                this.d_writer.tab();
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_STR(" + s_proxy + argName + "),");
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_LEN(" + s_proxy + argName + "));");
                this.d_writer.backTab();
                this.d_writer.println(Fortran.getFortranPrefix() + "_STR_LOCAL_STR(" + s_proxy + argName + ") = NULL;");
                break;
            }
            case 2: {
                this.d_writer.printlnUnformatted(StubSource.s_charCheck);
                this.writeArgValue(argName, mode);
                this.d_writer.println(" = *(" + Fortran.getFortranPrefix() + "_STR_LOCAL_STR(" + s_proxy + argName + "));");
                this.d_writer.printlnUnformatted("#endif");
                break;
            }
            case 15: {
                throw new CodeGenerationException("fortran.SkelSource.doOutArg: Unable to process " + argType.getTypeString() + ' ' + argName);
            }
            default: {
                if (!argName.equals("retval")) break;
                this.writeArgValue(argName, mode);
                this.d_writer.println(" = _proxy_" + argName + ";");
            }
        }
    }

    private void processOutgoing(List args) throws CodeGenerationException {
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            Type t = a.getType();
            int mode = a.getMode();
            if (0 == mode && !t.hasArrayOrderSpec()) continue;
            this.doOutArg(a.getType(), a.getFormalName(), mode);
        }
    }

    private void freeResources(Method m, List args) {
        Iterator i = args.iterator();
        while (i.hasNext()) {
            Argument a = (Argument)i.next();
            String name = a.getFormalName();
            Type t = a.getType();
            if (t.getDetailedType() != 10) continue;
            this.d_writer.println("free((void *)" + Fortran.getFortranPrefix() + "_STR_LOCAL_STR(" + s_proxy + name + "));");
        }
        if (this.d_isF90 && m.getLongMethodName().equals(IOR.getBuiltinName(4))) {
            this.d_writer.println("if (self->d_data) free(self->d_data);");
        }
    }

    private void declareReturn(Type t) throws CodeGenerationException {
        if (0 != t.getDetailedType()) {
            this.d_writer.print(SkelSource.getReturnString(t) + " " + "retval");
            if (Utilities.isPointer(t)) {
                this.d_writer.print(" = NULL");
            }
            this.d_writer.println(";");
        }
    }

    private void generateMethod(List args, List argsWithIndices, Method m, SymbolID id) throws CodeGenerationException {
        this.d_writer.println("static " + SkelSource.getReturnString(m.getReturnType()));
        this.d_writer.println(Fortran.getMethodSkelName(id, m) + "(");
        this.d_writer.tab();
        this.writeSkelArgs(args);
        this.d_writer.println(")");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.declareReturn(m.getReturnType());
        this.declareProxies(args);
        this.declareIndices(m.getRarrayInfo());
        this.initializeProxies(args);
        this.callMethod(Fortran.getMethodImplName(id, m, this.d_mang), argsWithIndices);
        this.checkExceptionBlock(m);
        this.processOutgoing(args);
        this.endExceptionBlock(m);
        this.freeResources(m, args);
        if (0 != m.getReturnType().getDetailedType()) {
            this.d_writer.println("return retval;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, true, false);
    }

    private void extendAndGenerate(Method m, SymbolID id) throws CodeGenerationException {
        List extendedArgs = StubSource.extendArgs(id, m, false);
        List extendedArgsWithIndices = StubSource.extendArgs(id, m, true);
        this.generateExtern(Fortran.getMethodImplName(id, m, this.d_mang), extendedArgsWithIndices);
        this.d_writer.println();
        this.generateMethod(extendedArgs, extendedArgsWithIndices, m, id);
    }

    private Collection extendMethods(Class cls) throws CodeGenerationException {
        Collection localMethods = cls.getMethods(false);
        SymbolID id = cls.getSymbolID();
        ArrayList<Method> extendedMethods = new ArrayList<Method>(localMethods.size() + 2);
        extendedMethods.add(IOR.getBuiltinMethod(3, id));
        extendedMethods.add(IOR.getBuiltinMethod(4, id));
        extendedMethods.addAll(localMethods);
        return extendedMethods;
    }

    private static void writeInitializeSEPV(SymbolID id, Collection methods, LanguageWriterForC writer) {
        writer.openCxxExtern();
        writer.println("void");
        writer.print(IOR.getSetSEPVName(id));
        writer.print("(");
        writer.print(IOR.getSEPVName(id));
        writer.println(" *sepv) {");
        writer.tab();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (!m.isStatic()) continue;
            writer.print("sepv->");
            writer.print(IOR.getVectorEntry(m.getLongMethodName()));
            writer.print(" = ");
            writer.print(Fortran.getMethodSkelName(id, m));
            writer.println(";");
        }
        writer.backTab();
        writer.println("}");
        writer.closeCxxExtern();
        writer.println();
    }

    private void writeDataAccess(SymbolID id) throws UnsupportedEncodingException {
        String getData = this.d_mang.shortName(id.getFullName(), "_get_data", Fortran.getMethodSuffix());
        String setData = this.d_mang.shortName(id.getFullName(), "_set_data", Fortran.getMethodSuffix());
        String humanGetName = id.getFullName().replace('.', '_') + "__get_data" + Fortran.getMethodSuffix();
        String humanSetName = id.getFullName().replace('.', '_') + "__set_data" + Fortran.getMethodSuffix();
        this.d_writer.beginBlockComment(false);
        this.d_writer.println("The FORTRAN impl calls this to get the data pointer.");
        this.d_writer.println("This function name may be a mangled form of");
        this.d_writer.println(humanGetName);
        this.d_writer.endBlockComment(false);
        this.d_writer.println("void");
        this.d_writer.println(Fortran.getFortranSymbol() + "(" + getData.toLowerCase() + ',');
        this.d_writer.tab();
        this.d_writer.println(getData.toUpperCase() + ',');
        this.d_writer.println(getData + ')');
        this.d_writer.print("(int64_t *object, ");
        this.d_writer.println(this.d_isF90 ? "void *data)" : "int64_t *data)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + " *local = ");
        this.d_writer.tab();
        this.d_writer.println("((" + IOR.getObjectName(id) + " *)(ptrdiff_t)*object);");
        this.d_writer.backTab();
        if (this.d_isF90) {
            this.d_writer.println("if (local && local->d_data) {");
            this.d_writer.tab();
            this.d_writer.println("memcpy(data, local->d_data, SIDL_F90_POINTER_SIZE);");
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
            this.d_writer.println("/* _get_data called before _set_data */");
            this.d_writer.printlnUnformatted("fputs(\"Babel:" + humanGetName + " called before " + humanSetName + "! FATAL ERROR (unitialized " + "pointer)!\", stderr);");
            this.d_writer.println("abort();/*NOTREACHED*/");
            this.d_writer.backTab();
            this.d_writer.println("}");
        } else {
            this.d_writer.println("*data = local ? (ptrdiff_t)(local->d_data) : (ptrdiff_t)0;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.beginBlockComment(false);
        this.d_writer.println("The FORTRAN impl calls this to set the data pointer.");
        this.d_writer.println("This function name may be a mangled form of");
        this.d_writer.println(humanSetName);
        this.d_writer.endBlockComment(false);
        this.d_writer.println("void");
        this.d_writer.println(Fortran.getFortranSymbol() + "(" + setData.toLowerCase() + ',');
        this.d_writer.tab();
        this.d_writer.println(setData.toUpperCase() + ',');
        this.d_writer.println(setData + ')');
        this.d_writer.print("(int64_t *object, ");
        this.d_writer.println(this.d_isF90 ? "void *data)" : "int64_t *data)");
        this.d_writer.backTab();
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println(IOR.getObjectName(id) + " *local = ");
        this.d_writer.tab();
        this.d_writer.println("((" + IOR.getObjectName(id) + " *)(ptrdiff_t)*object);");
        this.d_writer.backTab();
        this.d_writer.println("if (local) {");
        this.d_writer.tab();
        if (this.d_isF90) {
            this.d_writer.println("if (!(local->d_data)) {");
            this.d_writer.tab();
            this.d_writer.println("local->d_data = malloc(SIDL_F90_POINTER_SIZE);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (local->d_data) {");
            this.d_writer.tab();
            this.d_writer.println("memcpy(local->d_data, data, SIDL_F90_POINTER_SIZE);");
            this.d_writer.backTab();
            this.d_writer.println("} else {");
            this.d_writer.tab();
            this.d_writer.printlnUnformatted("fputs(\"" + humanSetName + " failed in a " + "malloc call!\", stderr);");
            this.d_writer.backTab();
            this.d_writer.println("}");
        } else {
            this.d_writer.println("local->d_data = (void *)(ptrdiff_t)*data;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private static void initializeMethodPointer(LanguageWriter writer, Method m, SymbolID id) {
        String methodName = m.getLongMethodName();
        switch (m.getDefinitionModifier()) {
            case 0: 
            case 2: {
                writer.print("epv->");
                writer.print(IOR.getVectorEntry(methodName));
                writer.print(" = ");
                writer.print(Fortran.getMethodSkelName(id, m));
                writer.println(";");
                break;
            }
            case 1: {
                writer.print("epv->");
                writer.print(IOR.getVectorEntry(methodName));
                writer.println(" = NULL;");
                break;
            }
        }
    }

    private static void writeInitializeEPV(SymbolID id, Collection methods, LanguageWriterForC writer, boolean isSuper) {
        writer.openCxxExtern();
        writer.println("void");
        writer.print(IOR.getSetEPVName(id));
        writer.print("(");
        writer.print(IOR.getEPVName(id));
        writer.println(" *epv) {");
        writer.tab();
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            SkelSource.initializeMethodPointer(writer, m, id);
        }
        if (isSuper) {
            writer.println("superEPV = _getIOR()->getSuperEPV();");
        }
        writer.backTab();
        writer.println("}");
        writer.closeCxxExtern();
        writer.println();
    }

    public void generateCode(Class cls) throws CodeGenerationException {
        String pre = "fortran.SkelSource.generateCode: ";
        Collection methods = this.extendMethods(cls);
        SymbolID id = cls.getSymbolID();
        this.d_writer.writeBanner(cls, Fortran.getSkelFile(id), false, "Server-side glue code for " + id.getFullName());
        this.d_writer.println();
        StubSource.generateIncludes(this.d_writer, cls);
        this.d_writer.printlnUnformatted("#include <string.h>");
        this.d_writer.printlnUnformatted("#include <stdio.h>");
        this.d_writer.println();
        if (cls.hasOverwrittenMethods()) {
            StubSource.generateSupers(cls, this.d_writer);
        }
        Iterator i = methods.iterator();
        while (i.hasNext()) {
            Method m = (Method)i.next();
            if (m.isAbstract()) continue;
            this.d_writer.println();
            this.d_writer.println();
            this.extendAndGenerate(m, id);
        }
        Method load_meth = IOR.getBuiltinMethod(5, id);
        List load_args = StubSource.extendArgs(id, load_meth, false);
        this.generateExtern(Fortran.getMethodImplName(id, load_meth, this.d_mang), load_args);
        this.d_writer.println();
        this.d_writer.println("void " + IOR.getSymbolName(id) + "__call_load(void) { ");
        this.d_writer.tab();
        this.callMethod(Fortran.getMethodImplName(id, load_meth, this.d_mang), load_args);
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.println();
        SkelSource.writeInitializeEPV(id, methods, this.d_writer, cls.hasOverwrittenMethods());
        if (cls.hasStaticMethod(false)) {
            this.d_writer.println();
            SkelSource.writeInitializeSEPV(id, methods, this.d_writer);
        }
        try {
            this.writeDataAccess(id);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CodeGenerationException("fortran.SkelSource.generateCode: " + uee.getMessage());
        }
    }

    public static void generateCode(Class cls, LanguageWriterForC writer) throws CodeGenerationException, NoSuchAlgorithmException {
        SkelSource source = new SkelSource(writer);
        source.generateCode(cls);
    }
}

