/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.writers;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LineCountingFilterWriter
extends FilterWriter {
    protected int d_line_count = 1;

    public LineCountingFilterWriter(Writer out) {
        super(out);
    }

    public int getLineCount() {
        return this.d_line_count;
    }

    public void setLineCount(int i) {
        this.d_line_count = i;
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        if ((char)c == '\n') {
            ++this.d_line_count;
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
        this.d_line_count += this.countLines(cbuf, off, len);
    }

    public void write(String str, int off, int len) throws IOException {
        this.out.write(str, off, len);
        this.d_line_count += this.countLines(str.toCharArray(), off, len);
    }

    protected int countLines(char[] x, int off, int len) {
        int count = 0;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            if (x[i] != '\n') continue;
            ++count;
        }
        return count;
    }
}

