/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.parsers.sidl.ParserConstants;

public class Grammar {
    public static final int SPECIFICATION = 1;
    public static final int REQUIRE = 2;
    public static final int IMPORT = 3;
    public static final int PACKAGE = 4;
    public static final int DEFINITION = 5;
    public static final int CLASS = 6;
    public static final int ENUM = 7;
    public static final int ENUMERATOR = 8;
    public static final int INTERFACE = 9;
    public static final int INVARIANTS = 10;
    public static final int CLASS_METHOD = 11;
    public static final int METHOD = 12;
    public static final int ARGUMENT = 13;
    public static final int TYPE = 14;
    public static final int ARRAY = 15;
    public static final int ARRAY_ORDER = 16;
    public static final int RARRAY = 17;
    public static final int REQUIRES = 18;
    public static final int ENSURES = 19;
    public static final int ASSERTIONS = 20;
    public static final int ASSERTION_EXPR = 21;
    public static final int CONDITIONAL_EXPR = 22;
    public static final int INCLUSIVE_OR_EXPR = 23;
    public static final int EXCLUSIVE_OR_EXPR = 24;
    public static final int AND_EXPR = 25;
    public static final int EQUALITY_EXPR = 26;
    public static final int RELATIONAL_EXPR = 27;
    public static final int SHIFT_EXPR = 28;
    public static final int ADDITIVE_EXPR = 29;
    public static final int MULTIPLICATIVE_EXPR = 30;
    public static final int POWER_EXPR = 31;
    public static final int UNARY_EXPR = 32;
    public static final int POSTFIX_EXPR = 33;
    public static final int PRIMARY_EXPR = 34;
    public static final int RESERVED_EXPR = 35;
    public static final int LITERAL_EXPR = 36;
    public static final int ARGUMENT_EXPR_LIST = 37;
    public static final int SCOPED_IDENTIFIER = 38;
    public static final int MIN_PRODUCTION = 1;
    public static final int MAX_PRODUCTION = 38;

    public static String getProduction(int production) {
        String s = null;
        switch (production) {
            case 1: {
                s = "Specification ::= (Require)* (Import)* (Package)* EOF";
                break;
            }
            case 2: {
                s = "Require ::= \"require\" ScopedIdentifier \"version\" V1.V2...Vn\";\"";
                break;
            }
            case 3: {
                s = "Import ::= \"import\" ScopedIdentifier [ \"version\" V1.V2...Vn ] \";\"";
                break;
            }
            case 4: {
                s = "Package ::= [ \"final\" ] \"package\" ScopedIdentifier [ \"version\" V1.V2...Vn ] \"{\" (Definition)* \"}\" [ \";\" ]";
                break;
            }
            case 5: {
                s = "Definition ::= Class | Enum | Interface | Package";
                break;
            }
            case 6: {
                s = "Class ::= [ \"abstract\" ] \"class\" Identifier [ \"extends\" ScopedIdentifier ] [ \"implements-all\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] [ \"implements\" ScopedIdentifier ( \",\" ScopedIdentifier )*]  \"{\" [ Invariants ] (ClassMethod)* \"}\" [ \";\" ]";
                break;
            }
            case 7: {
                s = "Enum ::= \"enum\" Identifier \"{\" Enumerator ( \",\" Enumerator )* \"}\" [ \";\" ]";
                break;
            }
            case 8: {
                s = "Enumerator ::= Identifier [ \"=\" Integer ]";
                break;
            }
            case 9: {
                s = "Interface ::= \"interface\" Identifier [ \"extends\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] \"{\" [ Invariants ] (Method)* \"}\" [ \";\" ]";
                break;
            }
            case 10: {
                s = "Invariants ::= \"invariant\" Assertions";
                break;
            }
            case 11: {
                s = "ClassMethod ::= [ (\"abstract\" | \"final\" | \"static\") ] Method";
                break;
            }
            case 12: {
                s = "Method ::= (\"void\" | [\"copy\"] Type) Identifier [ \"[\" Identifier \"]\" ] \"(\" [ Argument (\",\" Argument )* ] \")\" [ (\"local\" | \"oneway\") ] [ \"throws\" ScopedIdentifier ( \",\" ScopedIdentifier )* ] [ Requires ] [ Ensures ] \";\"";
                break;
            }
            case 13: {
                s = "Argument ::= [ \"copy\" ] ( \"in\" | \"inout\" | \"out\" ) Type Identifier";
                break;
            }
            case 14: {
                s = "Type ::= \"bool\" | \"char\" | \"dcomplex\" | \"double\" | \"fcomplex\" | \"float\" | \"int\" | \"long\" | \"opaque\" | \"string\" | Array | ScopedIdentifier";
                break;
            }
            case 15: {
                s = "Array := \"array<\" Type [ \",\" ( Integer [ \",\" ArrayOrder ] | ArrayOrder ) ] \">\"";
                break;
            }
            case 16: {
                s = "ArrayOrder := ( \"column-major\" | \"row-major\" )";
                break;
            }
            case 17: {
                s = "Rarray := \"rarray<\" Type [ \",\" Integer ]>  Identifier \"(\" Index ( \",\" Index )* \")\" ";
                break;
            }
            case 18: {
                s = "Requires ::= \"require\" Assertions";
                break;
            }
            case 19: {
                s = "Ensures ::= \"ensure\" Assertions";
                break;
            }
            case 20: {
                s = "Assertions ::= (AssertionExpr [ \":\" AssertionExpr ] \";\"] )+ ";
                break;
            }
            case 21: {
                s = "AssertionExpr ::= ConditionalExpr [ (\"implies\" | \"iff\") ConditionalExpr ]";
                break;
            }
            case 22: {
                s = "ConditionalExpr ::= InclusiveORExpr";
                break;
            }
            case 23: {
                s = "InclusiveORExpr ::= ExclusiveORExpr [ \"or\" ExclusiveORExpr ]";
                break;
            }
            case 24: {
                s = "ExclusiveORExpr ::= ANDExpr [ \"xor\" ANDExpr ]";
                break;
            }
            case 25: {
                s = "ANDExpr ::= EqualityExpr [ \"and\" EqualityExpr ]";
                break;
            }
            case 26: {
                s = "EqualityExpr ::= RelationalExpr [ (\"==\" | \"!=\" | \"<>\") RelationalExpr ]";
                break;
            }
            case 27: {
                s = "RelationalExpr ::= ShiftExpr [ (\"<\" | \">\" | \"<=\" | \">=\") ShiftExpr ]";
                break;
            }
            case 28: {
                s = "ShiftExpr ::= AdditiveExpr ((\">>\" | \"<<\") AdditiveExpr)*";
                break;
            }
            case 29: {
                s = "AdditiveExpr ::= MultiplicativeExpr ((\"+\" | \"-\") MultiplicativeExpr)*";
                break;
            }
            case 30: {
                s = "MultiplicativeExpr ::= PowerExpr ((\"*\" | \"/\" | \"mod\" | \"rem\") PowerExpr)*";
                break;
            }
            case 31: {
                s = "PowerExpr ::= UnaryExpr ((\"^\" | \"**\") UnaryExpr)*";
                break;
            }
            case 32: {
                s = "UnaryExpr ::= [ (\"~\" | \"not\" | \"is\") ] PostfixExpr";
                break;
            }
            case 33: {
                s = "PostfixExpr ::= PrimaryExpr | Identifier \"(\" [ArgumentExpressionList] \")\" )";
                break;
            }
            case 34: {
                s = "PrimaryExpr ::= Reserved | Identifier | Literal | \"(\" ConditionalExpr \")\" | \"{\" FloatLiteral \",\" FloatLiteral \"}\"";
                break;
            }
            case 35: {
                s = "Reserved ::= \"null\" | \"pure\" | \"result\" | BooleanLiteral ";
                break;
            }
            case 36: {
                s = "Literal ::= FloatLiteral | IntegerLiteral ";
                break;
            }
            case 37: {
                s = "ArgumentExprList ::= ConditionalExpr (\",\" ConditionalExpr)*";
                break;
            }
            case 38: {
                s = "ScopedIdentifier ::= Identifier (\".\" Identifier)*";
                break;
            }
            default: {
                s = "Internal error (unknown production)";
            }
        }
        return s;
    }

    public static String getTokenString(int token) {
        switch (token) {
            case 0: {
                return "\"END-OF-FILE\"";
            }
            case 101: {
                return "\"identifier\"";
            }
            case 102: {
                return "\"V1.V2...Vn\"";
            }
            case 104: {
                return "\"integer\"";
            }
            case 106: {
                return "\"[0-9]\"";
            }
            case 107: {
                return "\"[a-z,A-Z]\"";
            }
        }
        return ParserConstants.tokenImage[token];
    }

    public static void main(String[] args) {
        int p;
        System.out.println("*** Grammar productions are:");
        System.out.println();
        for (p = 1; p <= 38; ++p) {
            System.out.println(Grammar.getProduction(p));
            System.out.println();
        }
        System.out.println();
        System.out.println();
        System.out.print("*** Conversions are made below only for the ");
        System.out.println("following:");
        System.out.println("DIGIT          = 106");
        System.out.println("IDENTIFIER     = 101");
        System.out.println("INTEGER        = 104");
        System.out.println("LETTER         = 107");
        System.out.println("VERSION_STRING = 102");
        System.out.println();
        for (p = 0; p <= 112; ++p) {
            System.out.println("token " + p + " = " + Grammar.getTokenString(p));
        }
    }
}

