/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.parsers.sidl;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.Configuration;
import gov.llnl.babel.parsers.sidl.GrammarException;
import gov.llnl.babel.parsers.sidl.ParseException;
import gov.llnl.babel.parsers.sidl.ParserConstants;
import gov.llnl.babel.parsers.sidl.ParserTokenManager;
import gov.llnl.babel.parsers.sidl.SIDLException;
import gov.llnl.babel.parsers.sidl.SimpleCharStream;
import gov.llnl.babel.parsers.sidl.SymbolException;
import gov.llnl.babel.parsers.sidl.Token;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Assertion;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.BinaryExpression;
import gov.llnl.babel.symbols.BooleanLiteral;
import gov.llnl.babel.symbols.CharacterLiteral;
import gov.llnl.babel.symbols.Class;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.DComplexLiteral;
import gov.llnl.babel.symbols.DoubleLiteral;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.FComplexLiteral;
import gov.llnl.babel.symbols.IdentifierLiteral;
import gov.llnl.babel.symbols.Interface;
import gov.llnl.babel.symbols.LongLiteral;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.MethodCall;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.StringLiteral;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolNotFoundException;
import gov.llnl.babel.symbols.SymbolRedefinitionException;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.SymbolUtilities;
import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.UnaryExpression;
import gov.llnl.babel.symbols.Version;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class Parser
implements ParserConstants {
    private Stack d_arg_stack;
    private HashSet d_forward_refs;
    private Stack d_grammar;
    private ArrayList d_imports;
    private HashMap d_metadata;
    private HashMap d_reserved_words;
    private ArrayList d_scope;
    private String d_source_url;
    private HashSet d_unused_imports;
    private HashSet d_unused_versions;
    private HashMap d_versions;
    private ArrayList d_warnings;
    private LinkedList d_parent_stack;
    private static final String SCOPE = ".";
    private static final String EOL = "\n";
    private static final int MAX_ARRAY_DIM = 7;
    private static final String SIDL_CLASS = BabelConfiguration.getBaseClass();
    private static final String SIDL_INTERFACE = BabelConfiguration.getBaseInterface();
    private static final String SIDL_THROWS_CLASS = BabelConfiguration.getBaseExceptionClass();
    private static final String SIDL_THROWS_INTERFACE = BabelConfiguration.getBaseExceptionInterface();
    public ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[83];
    private final int[] jj_la1_0 = new int[]{0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0x8C00000, 0, 0x8C00000, 0x400000, 0x10000000, 0, 0, 0, 0, 0x1400000, 0, 0, 0, 0, 0, 0x10000000, 0x1000000, 0, 0, 0x400000, 0x400000, 0x1000000, 0x1000000, 0, 0, -1056964608, 0, 0, 0, 0, 0, 0x2000000, 0x4000000, 0, 0x1000000, -1073741824, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_1 = new int[]{1024, 0, 513, 0, 0, 16384, 1, 0, 16384, 521, 0, 521, 0, 0, 0, 4, 0, 2, 268273665, 0, 0, 0, 0, 0, 0, 268271616, 0, 16, 2049, 2049, 0, 268271616, 0, 0, 256, 96, 96, 0, 8192, 1024, 0, 0, 4096, 0, 256, 0xFFF0000, 0xFFD0000, 0, 0, 0, 0, 0, 0xFFD0000, 0x50000000, 0, 0, 0, 0, 0, 0, 0, 0, -1073741824, -1073741824, 0x30000000, 0x30000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int[] jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 256, 0, 256, 0, 0, 0x4000000, 256, 0x4000000, 1, 256, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 262144, 256, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 256, 0, 0, 256, 256, 128, 6144, 6144, 0x200000, Integer.MIN_VALUE, 2, 131072, 131072, 16896, 16896, 0x18000000, 0x18000000, 0x800400, 553680900, 553680900, 0x400008, 0x400008, 1073815552, 1073815552, 1075388416, 0x180000, 0x180000, 524288, 0, 0, 256, 0x2000000};
    private final int[] jj_la1_3 = new int[]{0, 0, 0, 704, 704, 0, 0, 704, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 49152, 0, 49152, 49408, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12735, 12735, 12735, 12703, 384, 384, 0, 0};
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setSourceURL(String url) {
        this.d_source_url = url;
    }

    public void addMetadata(String key, String value) {
        if (this.d_metadata == null) {
            this.d_metadata = new HashMap();
        }
        this.d_metadata.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] beginParse() throws SIDLException {
        this.d_arg_stack = new Stack();
        this.d_forward_refs = new HashSet();
        this.d_grammar = new Stack();
        this.d_imports = new ArrayList();
        this.d_reserved_words = new HashMap();
        this.d_scope = new ArrayList();
        this.d_unused_imports = new HashSet();
        this.d_unused_versions = new HashSet();
        this.d_versions = new HashMap();
        this.d_warnings = new ArrayList();
        this.d_parent_stack = new LinkedList();
        this.generateReservedWords();
        if (this.d_metadata == null) {
            this.d_metadata = new HashMap();
        }
        if (this.d_source_url == null) {
            this.d_source_url = "file:unknown.sidl";
        }
        String[] warnings = null;
        try {
            try {
                this.Specification();
                warnings = this.generateWarnings();
            }
            catch (ParseException ex) {
                this.generateGrammarException(ex);
                Object var4_3 = null;
                this.d_arg_stack = null;
                this.d_forward_refs = null;
                this.d_grammar = null;
                this.d_imports = null;
                this.d_metadata = null;
                this.d_reserved_words = null;
                this.d_scope = null;
                this.d_unused_imports = null;
                this.d_unused_versions = null;
                this.d_versions = null;
                this.d_warnings = null;
                this.d_parent_stack = null;
            }
            Object var4_2 = null;
            this.d_arg_stack = null;
            this.d_forward_refs = null;
            this.d_grammar = null;
            this.d_imports = null;
            this.d_metadata = null;
            this.d_reserved_words = null;
            this.d_scope = null;
            this.d_unused_imports = null;
            this.d_unused_versions = null;
            this.d_versions = null;
            this.d_warnings = null;
            this.d_parent_stack = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.d_arg_stack = null;
            this.d_forward_refs = null;
            this.d_grammar = null;
            this.d_imports = null;
            this.d_metadata = null;
            this.d_reserved_words = null;
            this.d_scope = null;
            this.d_unused_imports = null;
            this.d_unused_versions = null;
            this.d_versions = null;
            this.d_warnings = null;
            this.d_parent_stack = null;
            throw throwable;
        }
        return warnings;
    }

    private void generateGrammarException(ParseException ex) throws GrammarException {
        Integer state = (Integer)this.d_grammar.peek();
        throw new GrammarException(ex, state);
    }

    private void generateSymbolException(String message) throws SymbolException {
        Integer state = (Integer)this.d_grammar.peek();
        throw new SymbolException(this.token, (int)state, message);
    }

    private void generateReservedWords() {
        this.d_reserved_words.put("abstract", "Java");
        this.d_reserved_words.put("and", "C++ and Python");
        this.d_reserved_words.put("and_eq", "C++");
        this.d_reserved_words.put("asm", "C and C++");
        this.d_reserved_words.put("assert", "Java and Python");
        this.d_reserved_words.put("auto", "C and C++");
        this.d_reserved_words.put("bitand", "C++");
        this.d_reserved_words.put("bitor", "C++");
        this.d_reserved_words.put("bool", "C++");
        this.d_reserved_words.put("boolean", "Java");
        this.d_reserved_words.put("break", "C, C++, Java, and Python");
        this.d_reserved_words.put("case", "C, C++, and Java");
        this.d_reserved_words.put("catch", "C++ and Java");
        this.d_reserved_words.put("char", "C, C++, and Java");
        this.d_reserved_words.put("class", "C++ and Java");
        this.d_reserved_words.put("compl", "C++");
        this.d_reserved_words.put("const", "C, C++, and Java");
        this.d_reserved_words.put("const_cast", "C++");
        this.d_reserved_words.put("continue", "C, C++, Java, and Python");
        this.d_reserved_words.put("def", "Python");
        this.d_reserved_words.put("default", "C, C++, and Java");
        this.d_reserved_words.put("del", "Python");
        this.d_reserved_words.put("delete", "C++");
        this.d_reserved_words.put("do", "C, C++, and Java");
        this.d_reserved_words.put("double", "C, C++, and Java");
        this.d_reserved_words.put("dynamic_cast", "C++");
        this.d_reserved_words.put("elif", "Python");
        this.d_reserved_words.put("else", "C, C++, Java, and Python");
        this.d_reserved_words.put("enum", "C, C++, and Java");
        this.d_reserved_words.put("except", "Python");
        this.d_reserved_words.put("exec", "Python");
        this.d_reserved_words.put("explicit", "C++");
        this.d_reserved_words.put("export", "C++");
        this.d_reserved_words.put("extends", "Java");
        this.d_reserved_words.put("extern", "C and C++");
        this.d_reserved_words.put("false", "C++ and Java");
        this.d_reserved_words.put("final", "Java");
        this.d_reserved_words.put("finally", "Java and Python");
        this.d_reserved_words.put("float", "C, C++, and Java");
        this.d_reserved_words.put("for", "C, C++, Java, and Python");
        this.d_reserved_words.put("friend", "C++");
        this.d_reserved_words.put("from", "Python");
        this.d_reserved_words.put("global", "Python");
        this.d_reserved_words.put("goto", "C, C++, and Java");
        this.d_reserved_words.put("if", "C, C++, Java, and Python");
        this.d_reserved_words.put("implements", "Java");
        this.d_reserved_words.put("import", "Java");
        this.d_reserved_words.put("inline", "C++");
        this.d_reserved_words.put("instanceof", "Java");
        this.d_reserved_words.put("int", "C, C++, and Java");
        this.d_reserved_words.put("interface", "Java");
        this.d_reserved_words.put("is", "Python");
        this.d_reserved_words.put("lambda", "Python");
        this.d_reserved_words.put("long", "C, C++, and Java");
        this.d_reserved_words.put("mutable", "C++");
        this.d_reserved_words.put("namespace", "C++");
        this.d_reserved_words.put("native", "Java");
        this.d_reserved_words.put("new", "C++ and Java");
        this.d_reserved_words.put("not", "C++ and Python");
        this.d_reserved_words.put("not_eq", "C++");
        this.d_reserved_words.put("null", "Java");
        this.d_reserved_words.put("operator", "C++");
        this.d_reserved_words.put("or", "C++ and Python");
        this.d_reserved_words.put("or_eq", "C++");
        this.d_reserved_words.put("package", "Java");
        this.d_reserved_words.put("pass", "Python");
        this.d_reserved_words.put("print", "Python");
        this.d_reserved_words.put("private", "C++ and Java");
        this.d_reserved_words.put("protected", "C++ and Java");
        this.d_reserved_words.put("public", "C++ and Java");
        this.d_reserved_words.put("raise", "Python");
        this.d_reserved_words.put("register", "C and C++");
        this.d_reserved_words.put("reinterpret_cast", "C++");
        this.d_reserved_words.put("return", "C, C++, Java, and Python");
        this.d_reserved_words.put("self", "SIDL backends");
        this.d_reserved_words.put("short", "C, C++, and Java");
        this.d_reserved_words.put("signed", "C and C++");
        this.d_reserved_words.put("sizeof", "C and C++");
        this.d_reserved_words.put("static", "C, C++, and Java");
        this.d_reserved_words.put("static_cast", "C++");
        this.d_reserved_words.put("strictfp", "Java");
        this.d_reserved_words.put("struct", "C and C++");
        this.d_reserved_words.put("super", "Java");
        this.d_reserved_words.put("switch", "C, C++, and Java");
        this.d_reserved_words.put("synchronized", "Java");
        this.d_reserved_words.put("template", "C++");
        this.d_reserved_words.put("this", "C++ and Java");
        this.d_reserved_words.put("throw", "C++ and Java");
        this.d_reserved_words.put("throws", "Java");
        this.d_reserved_words.put("transient", "Java");
        this.d_reserved_words.put("true", "C++ and Java");
        this.d_reserved_words.put("try", "C++, Java, and Python");
        this.d_reserved_words.put("typedef", "C and C++");
        this.d_reserved_words.put("typeid", "C++");
        this.d_reserved_words.put("typename", "C++");
        this.d_reserved_words.put("union", "C and C++");
        this.d_reserved_words.put("unsigned", "C and C++");
        this.d_reserved_words.put("using", "C++");
        this.d_reserved_words.put("virtual", "C++");
        this.d_reserved_words.put("void", "C, C++, and Java");
        this.d_reserved_words.put("volatile", "C, C++, and Java");
        this.d_reserved_words.put("wchar_t", "C++");
        this.d_reserved_words.put("while", "C, C++, Java, and Python");
        this.d_reserved_words.put("xor", "C++");
        this.d_reserved_words.put("xor_eq", "C++");
    }

    private void verifyReservedWords(String id) throws SymbolException {
        String pre = "Parser.verifyReservedWords: ";
        String lang = (String)this.d_reserved_words.get(id);
        if (lang != null) {
            this.generateSymbolException("Parser.verifyReservedWords: Illegal identifier \"" + id + "\" is a reserved word in " + lang + SCOPE);
        }
    }

    private void checkMethodNameLength(String shortname, String extension, Token tok) {
        String pre = "Parser.checkMethodNameLength: ";
        int extLen = extension != null ? extension.length() : 0;
        if (shortname.length() + (extension != null ? extension.length() : 0) > 31) {
            this.generateWarning("Parser.checkMethodNameLength: Method \"" + shortname + (extension != null ? "[" + extension + "]" : "") + "\" at line(s) " + tok.beginLine + ":" + tok.endLine + " is longer than 31 characters. This will require name mangling " + "in FORTRAN 90/95 and potentially C.");
        }
    }

    private void setMetadataValues(Symbol sym) {
        sym.addMetadata("babel-version", "0.10.2");
        sym.addMetadata("source-url", this.d_source_url);
        sym.addMetadata("source-line", String.valueOf(this.token.beginLine));
        Iterator i = this.d_metadata.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            sym.addMetadata((String)e.getKey(), (String)e.getValue());
        }
    }

    private void generateWarning(String warning) {
        this.d_warnings.add(warning);
    }

    private String[] generateWarnings() {
        String[] warnings = null;
        int n = this.d_warnings.size();
        if (n > 0) {
            warnings = new String[n];
            for (int i = 0; i < n; ++i) {
                warnings[i] = (String)this.d_warnings.get(i);
            }
        }
        return warnings;
    }

    private void pushGrammarProduction(int production) {
        this.d_grammar.push(new Integer(production));
    }

    private void popGrammarProduction() {
        this.d_grammar.pop();
    }

    private void enterScope(String scope) {
        this.d_scope.add(scope);
    }

    private static Package toPackage(Symbol sym, SymbolID newID) throws SymbolRedefinitionException {
        Package p = null;
        if (sym != null) {
            if (sym instanceof Package) {
                p = (Package)sym;
            } else {
                throw new SymbolRedefinitionException(newID, sym.getSymbolID());
            }
        }
        return p;
    }

    private void leaveScope() {
        this.d_scope.remove(this.d_scope.size() - 1);
    }

    private String getScope() {
        int s = this.d_scope.size();
        return s == 0 ? "" : (String)this.d_scope.get(s - 1);
    }

    private String getScope(String name) {
        int s = this.d_scope.size();
        return s == 0 ? name : (String)this.d_scope.get(s - 1) + SCOPE + name;
    }

    private Comment generateComment(Token t) {
        String[] comment_lines = null;
        Token special = t.specialToken;
        if (special != null) {
            int lines = 0;
            while (special.kind != 8) {
                ++lines;
                special = special.specialToken;
            }
            if (lines > 0) {
                comment_lines = new String[lines];
                special = t.specialToken;
                while (special.kind != 8) {
                    comment_lines[--lines] = special.image;
                    special = special.specialToken;
                }
            }
        }
        return new Comment(comment_lines);
    }

    private void addForwardReference(String fqn) {
        this.d_forward_refs.add(fqn);
    }

    private void removeForwardReference(String fqn) {
        this.d_forward_refs.remove(fqn);
    }

    private void verifyForwardReferences() throws SymbolException {
        String pre = "Parser.verifyForwardReferences: ";
        Iterator i = this.d_forward_refs.iterator();
        while (i.hasNext()) {
            this.generateSymbolException("Parser.verifyForwardReferences: Symbol name \"" + (String)i.next() + "\" not found or defined within package.");
        }
    }

    private void verifyNotForwardReference(String fqn) throws SymbolException {
        String pre = "Parser.verifyNotForwardReference: ";
        if (this.d_forward_refs.contains(fqn)) {
            this.generateSymbolException("Parser.verifyNotForwardReference: Forward reference \"" + fqn + "\" cannot be used as a package or enumerated type.");
        }
    }

    private Version lookupVersion(String fqn) {
        SymbolTable table = SymbolTable.getInstance();
        Version version = null;
        while (fqn != null && version == null) {
            version = (Version)this.d_versions.get(fqn);
            if (version == null) {
                Symbol sym = table.lookupSymbol(fqn);
                if (sym != null) {
                    version = sym.getSymbolID().getVersion();
                    continue;
                }
                fqn = SymbolUtilities.getParentPackage(fqn);
                continue;
            }
            this.d_unused_versions.remove(fqn);
        }
        return version;
    }

    private void verifyVersionNotDefined(String name) throws SymbolException {
        String pre = "Parser.verifyVersionNotDefined: ";
        if (this.d_versions.keySet().contains(name)) {
            this.generateSymbolException("Parser.verifyVersionNotDefined: Redefinition of version for package \"" + name + "\".");
        }
    }

    private void addPackageVersion(String name, Version version) {
        this.d_versions.put(name, version);
        this.d_unused_versions.add(name);
    }

    private void generateVersionWarnings() {
        String pre = "Parser.generateVersionWarnings: ";
        Iterator i = this.d_unused_versions.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            this.generateWarning("Parser.generateVersionWarnings: Package \"" + name + "-v" + ((Version)this.d_versions.get(name)).getVersionString() + "\" was not used to resolve any symbols.");
        }
    }

    private void verifyImportNotDefined(String fqn) throws SymbolException {
        String pre = "Parser.verifyImportNotDefined: ";
        if (this.d_imports.contains(fqn)) {
            this.generateSymbolException("Parser.verifyImportNotDefined: Redefinition of import for package \"" + fqn + "\".");
        }
    }

    private void addToImportPath(String fqn) {
        this.d_imports.add(fqn);
        this.d_unused_imports.add(fqn);
    }

    private void usedImportToResolveSymbol(String fqn) {
        this.d_unused_imports.remove(fqn);
    }

    private void generateImportWarnings() {
        String pre = "Parser.generateImportWarnings: ";
        Iterator i = this.d_unused_imports.iterator();
        while (i.hasNext()) {
            this.generateWarning("Parser.generateImportWarnings: Import statement for package \"" + (String)i.next() + "\" not used to resolve any symbols.");
        }
    }

    private Symbol tryResolveFQN(String fqn) throws SymbolException {
        String pre = "Parser.tryResolveFQN: ";
        Symbol sym = null;
        Version version = this.lookupVersion(fqn);
        if (version == null) {
            sym = SymbolTable.getInstance().resolveSymbol(fqn);
        } else {
            try {
                SymbolID id = new SymbolID(fqn, version);
                sym = SymbolTable.getInstance().resolveSymbol(id);
            }
            catch (SymbolRedefinitionException ex) {
                this.generateSymbolException("Parser.tryResolveFQN: " + ex.getMessage());
            }
        }
        if (sym != null) {
            try {
                Set refs = sym.getSymbolReferences();
                SymbolTable.getInstance().generateDependencies(refs);
            }
            catch (SymbolRedefinitionException ex) {
                this.generateSymbolException("Parser.tryResolveFQN: " + ex.getMessage());
            }
            catch (SymbolNotFoundException ex) {
                // empty catch block
            }
        }
        return sym;
    }

    private Symbol resolveFQN(String fqn) throws SymbolException {
        String pre = "Parser.resolveFQN: ";
        Symbol sym = this.tryResolveFQN(fqn);
        if (sym == null) {
            Version v = this.lookupVersion(fqn);
            String s = v == null ? fqn : fqn + "-v" + v.getVersionString();
            this.generateSymbolException("Parser.resolveFQN: Symbol \"" + s + "\" not found.");
        }
        return sym;
    }

    private Symbol tryResolveSymbol(String name) throws SymbolException {
        Symbol sym = this.tryResolveFQN(name);
        for (int s = this.d_scope.size() - 1; s >= 0 && sym == null; --s) {
            sym = this.tryResolveFQN((String)this.d_scope.get(s) + SCOPE + name);
        }
        int n = this.d_imports.size();
        for (int s = 0; s < n && sym == null; ++s) {
            String prefix = (String)this.d_imports.get(s);
            sym = this.tryResolveFQN(prefix + SCOPE + name);
            if (sym == null) continue;
            this.usedImportToResolveSymbol(prefix);
        }
        return sym;
    }

    private Symbol resolveSymbol(String name) throws SymbolException {
        String pre = "Parser.resolveSymbol: ";
        Symbol sym = this.tryResolveSymbol(name);
        if (sym == null) {
            this.generateSymbolException("Parser.resolveSymbol: Symbol \"" + name + "\" not found.");
        }
        return sym;
    }

    private void verifyImportIsPackage(String fqn) throws SymbolException {
        String pre = "Parser.verifyImportIsPackage: ";
        Symbol sym = this.resolveFQN(fqn);
        if (sym.getSymbolType() != 14) {
            this.generateSymbolException("Parser.verifyImportIsPackage: Symbol \"" + sym.getSymbolID().getSymbolName() + "\" is not a package.");
        }
    }

    private void verifySymbolCanBeDefined(SymbolID id) throws SymbolException {
        String pre = "Parser.verifySymbolCanBeDefined: ";
        Version version = id.getVersion();
        if (version == null || version.isUnspecified()) {
            this.generateSymbolException("Parser.verifySymbolCanBeDefined: No version specified for the definition of symbol \"" + id.getSymbolName() + "\".\nClasses " + "and interfaces cannot be defined in an unversioned package.");
        }
        try {
            Symbol sym = SymbolTable.getInstance().resolveSymbol(id);
            if (sym != null) {
                SymbolID xid = sym.getSymbolID();
                boolean builtin = Configuration.getInstance().isBuiltinSymbol(sym.getSymbolID().getFullName());
                if (!builtin) {
                    if (xid.getSymbolName().equals(id.getSymbolName()) && sym.getMetadata().getMetadataValue("source-url").equals(this.d_source_url) && BabelConfiguration.getInstance().getTargetLanguage().equals("xml")) {
                        this.generateWarning("Parser.verifySymbolCanBeDefined: Symbol \"" + xid.getSymbolName() + "\"exists in XML repository.");
                    } else {
                        this.generateSymbolException("Parser.verifySymbolCanBeDefined: Redefinition of symbol \"" + sym.getSymbolID().getSymbolName() + "\".");
                    }
                } else {
                    this.generateSymbolException("Parser.verifySymbolCanBeDefined: Redefinition of symbol \"" + sym.getSymbolID().getSymbolName() + "\".");
                }
            }
        }
        catch (SymbolRedefinitionException sre) {
            this.generateSymbolException("Parser.verifySymbolCanBeDefined: " + sre.getMessage());
        }
    }

    private void addSymbolToParentPackage(Package parent, SymbolID id, int type) throws SymbolException {
        String pre = "Parser.addSymbolToParentPackage: ";
        if (parent != null) {
            if (parent.getSymbolType() != 14) {
                this.generateSymbolException("Parser.addSymbolToParentPackage: Symbol \"" + parent.getSymbolID().getSymbolName() + "\" is not a package.");
            }
            if (parent.getFinal()) {
                this.generateSymbolException("Parser.addSymbolToParentPackage: Cannot modify final package \"" + parent.getSymbolID().getSymbolName() + "\".");
            }
            parent.addSymbol(id, type);
            SymbolTable.getInstance().markSymbolAsModified(parent.getSymbolID());
        }
    }

    private void verifyCopyModifierValid(Type type) throws SymbolException {
        String pre = "Parser.verifyCopyModifierValid: ";
        if (type.getType() != 15) {
            this.generateSymbolException("Parser.verifyCopyModifierValid: Modifier \"copy\" is only valid for interfaces and classes.");
        } else {
            SymbolID id = type.getSymbolID();
            Symbol symbol = SymbolTable.getInstance().lookupSymbol(id);
            if (symbol != null && symbol.getSymbolType() == 11) {
                this.generateSymbolException("Parser.verifyCopyModifierValid: Modifier \"copy\" is not allowed for enumerated types.");
            }
        }
    }

    private void verifyOnewayValid(Method m) throws SymbolException {
        String pre = "Parser.verifyOnewayValid: ";
        if (m.getReturnType() != null) {
            this.generateSymbolException("Parser.verifyOnewayValid: Modifier \"oneway\" invalid for methods that return values.");
        }
        ArrayList args = m.getArgumentList();
        for (int i = 0; i < args.size(); ++i) {
            Argument arg = (Argument)args.get(i);
            if (arg.getMode() == 0) continue;
            this.generateSymbolException("Parser.verifyOnewayValid: Modifier \"oneway\" invalid for methods with inout and out arguments.");
        }
    }

    private void verifyAndAddThrows(Method m, String identifier) throws SymbolException {
        String pre = "Parser.verifyAndAddThrows: ";
        if (m.getCommunicationModifier() == 2) {
            this.generateSymbolException("Parser.verifyAndAddThrows: Modifier \"oneway\" invalid for methods with a throws clause.");
        }
        Symbol symbol = this.resolveSymbol(identifier);
        String symname = symbol.getFullName();
        if (m.getThrows().contains(symbol.getSymbolID())) {
            this.generateSymbolException("Parser.verifyAndAddThrows: Class \"" + symbol.getFullName() + "\" already listed in throws clause.");
        }
        int symtype = symbol.getSymbolType();
        Interface throwableint = (Interface)this.resolveFQN(SIDL_THROWS_INTERFACE);
        SymbolID isid = throwableint.getSymbolID();
        if (symtype == 12) {
            Class throwablecls;
            SymbolID csid;
            Class symbolcls;
            if (!(SIDL_THROWS_CLASS.equals(symname) || (symbolcls = (Class)symbol).hasParentClass(csid = (throwablecls = (Class)this.resolveFQN(SIDL_THROWS_CLASS)).getSymbolID(), true) || symbolcls.hasParentInterface(isid, true))) {
                this.generateSymbolException("Parser.verifyAndAddThrows: Class \"" + symname + "\" does not extend \"" + SIDL_THROWS_CLASS + "\"" + " or implement \"" + SIDL_THROWS_INTERFACE + "\".");
            }
        } else if (symtype == 13) {
            Interface symbolint;
            if (!SIDL_THROWS_INTERFACE.equals(symname) && !(symbolint = (Interface)symbol).hasParentInterface(isid, true)) {
                this.generateSymbolException("Parser.verifyAndAddThrows: Interface \"" + symname + "\" does not extend \"" + SIDL_THROWS_INTERFACE + "\".");
            }
        } else {
            this.generateSymbolException("Parser.verifyAndAddThrows: Symbol \"" + symname + "\" must be a class or interface to be in a throws clause.");
        }
        m.addThrows(symbol.getSymbolID());
    }

    private void verifyMethodRedefinition(Extendable ext, Method m) throws SymbolException {
        Collection methods;
        String pre = "Parser.verifyMethodRedefinition: ";
        Method method = ext.lookupMethodByLongName(m.getLongMethodName(), false);
        if (method != null) {
            if (method.sameSignature(m)) {
                this.generateSymbolException("Parser.verifyMethodRedefinition: Method \"" + m.getSignature() + "\" has already been defined locally in \"" + ext.getFullName() + "\" with same signature.");
            } else {
                this.generateSymbolException("Parser.verifyMethodRedefinition: Method \"" + m.getSignature() + "\" conflicts with existing method \"" + method.getSignature() + "\" already defined locally in \"" + ext.getFullName() + "\".");
            }
        }
        if ((methods = ext.lookupMethodByShortName(m.getShortMethodName(), false)) != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                method = (Method)i.next();
                if (!method.sameBaseSignature(m)) continue;
                this.generateSymbolException("Parser.verifyMethodRedefinition: Method \"" + m.getSignature() + "\" has already been defined locally in " + "\"" + ext.getFullName() + "\" with the same short name and " + "argument list.");
            }
        }
    }

    private void verifyMethodSignature(Extendable ext, Method m, String definer) throws SymbolException {
        Method existing;
        String pre = "Parser.verifyMethodSignature: ";
        if (ext.getSymbolID().getShortName().equals(m.getLongMethodName())) {
            this.generateSymbolException("Parser.verifyMethodSignature: Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot have same (long) name as \"" + ext.getFullName() + "\".");
        }
        if (ext.getSymbolID().getShortName().equals(m.getShortMethodName())) {
            this.generateSymbolException("Parser.verifyMethodSignature: Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot have same (short) name as \"" + ext.getFullName() + "\".");
        }
        if ((existing = ext.lookupMethodByLongName(m.getLongMethodName(), true)) != null && !m.sameSignature(existing)) {
            this.generateSymbolException("Parser.verifyMethodSignature: Signature conflict between method \"" + m.getSignature() + "\" from \"" + definer + "\" and existing " + "ancestor method \"" + existing.getSignature() + "\".");
        }
    }

    private void verifyMethodStatic(Extendable ext, Method m, String definer) throws SymbolException {
        Collection methods;
        String pre = "Parser.verifyMethodStatic: ";
        Method existing = ext.lookupMethodByLongName(m.getLongMethodName(), true);
        if (existing != null) {
            if (m.isStatic()) {
                this.generateSymbolException("Parser.verifyMethodStatic: Static method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing ancestor " + "method with same long name.");
            }
            if (existing.isStatic()) {
                this.generateSymbolException("Parser.verifyMethodStatic: Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing static " + "ancestor method with same long name.");
            }
        }
        if ((methods = ext.lookupMethodByShortName(m.getShortMethodName(), true)) != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                existing = (Method)i.next();
                if (!existing.sameBaseSignature(m)) continue;
                if (m.isStatic()) {
                    this.generateSymbolException("Parser.verifyMethodStatic: Static method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing ancestor method with same " + "short name and argument list.");
                }
                if (!existing.isStatic()) continue;
                this.generateSymbolException("Parser.verifyMethodStatic: Method \"" + m.getSignature() + "\" from \"" + definer + "\" cannot redefine existing " + "static ancestor method with the same short name and " + "argument list.");
            }
        }
    }

    private void verifyMethodOverride(Class cls, Method m) throws SymbolException {
        Collection methods;
        String pre = "Parser.verifyMethodOverride: ";
        Method existing = cls.lookupMethodByLongName(m.getLongMethodName(), true);
        if (existing != null) {
            if (existing.isFinal()) {
                this.generateSymbolException("Parser.verifyMethodOverride: Method \"" + m.getSignature() + "\" cannot redefine existing final ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\" with the same long method name.");
            }
            if (!existing.isAbstract() && m.isAbstract()) {
                this.generateSymbolException("Parser.verifyMethodOverride: Abstract method \"" + m.getSignature() + "\" cannot redefine existing non-abstract ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\".");
            }
        }
        if ((methods = cls.lookupMethodByShortName(m.getShortMethodName(), true)) != null) {
            Iterator i = methods.iterator();
            while (i.hasNext()) {
                existing = (Method)i.next();
                if (!existing.sameBaseSignature(m)) continue;
                if (existing.isFinal()) {
                    this.generateSymbolException("Parser.verifyMethodOverride: Method \"" + m.getSignature() + "\" cannot redefine existing final ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\" with the same short name and arguments.");
                }
                if (existing.isAbstract() || !m.isAbstract()) continue;
                this.generateSymbolException("Parser.verifyMethodOverride: Abstract method \"" + m.getSignature() + "\" cannot redefine existing " + "non-abstract ancestor method \"" + existing.getSignature() + "\" already defined in \"" + cls.getFullName() + "\".");
            }
        }
    }

    private void verifyClassInheritance(Class cls, Class test) throws SymbolException {
        String pre = "Parser.verifyClassInheritance: ";
        if (cls == test) {
            this.generateSymbolException("Parser.verifyClassInheritance: Class \"" + cls.getFullName() + "\" cannot extend itself.");
        }
        String test_name = test.getFullName();
        Iterator methods = test.getMethods(true).iterator();
        while (methods.hasNext()) {
            this.verifyMethodSignature(cls, (Method)methods.next(), test_name);
        }
    }

    private void verifyInterfaceInheritance(Extendable old, Interface test) throws SymbolException {
        String pre = "Parser.verifyInterfaceInheritance: ";
        if (old == test) {
            this.generateSymbolException("Parser.verifyInterfaceInheritance: Interface \"" + old.getFullName() + "\" cannot inherit from itself.");
        }
        Iterator methods = test.getMethods(true).iterator();
        while (methods.hasNext()) {
            Method method = (Method)methods.next();
            String name = test.getFullName();
            this.verifyMethodSignature(old, method, name);
            this.verifyMethodStatic(old, method, name);
        }
    }

    private void verifyAbstract(Class cls, boolean ab) throws SymbolException {
        String pre = "Parser.verifyAbstract: ";
        if (ab && !cls.isAbstract()) {
            this.generateSymbolException("Parser.verifyAbstract: Class \"" + cls.getFullName() + "\" declared abstract but contains no abstract methods.");
        }
        if (!ab && cls.isAbstract()) {
            StringBuffer msg = new StringBuffer();
            msg.append("Class \"");
            msg.append(cls.getFullName());
            msg.append("\" not declared abstract but has abstract method(s):");
            msg.append(EOL);
            Iterator m = cls.getAbstractMethods().iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                msg.append("   ");
                msg.append(method.getSignature());
                msg.append(EOL);
            }
            this.generateSymbolException("Parser.verifyAbstract: " + msg.toString());
        }
    }

    private String getSourceName(Extendable ext, Method m) {
        String name = null;
        name = m == null ? ext.getFullName() : ext.getFullName() + SCOPE + m.getLongMethodName();
        return name;
    }

    private void createBinaryExpressions(int numAsserts, boolean opOnStack, int op) throws SymbolException {
        String pre = "Parser.createBinaryExpressions: ";
        while (numAsserts > 1) {
            AssertionExpression rhs = (AssertionExpression)this.d_arg_stack.pop();
            if (opOnStack) {
                op = (Integer)this.d_arg_stack.pop();
            }
            AssertionExpression lhs = (AssertionExpression)this.d_arg_stack.pop();
            try {
                BinaryExpression be = new BinaryExpression(lhs, op, rhs);
                this.d_arg_stack.push(be);
                if (opOnStack) {
                    numAsserts -= 2;
                    continue;
                }
                --numAsserts;
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.createBinaryExpressions: " + aex.getMessage());
            }
        }
    }

    public final void Specification() throws ParseException, SymbolException {
        this.pushGrammarProduction(1);
        String pre = "Parser.Specification: ";
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block12;
                }
            }
            this.Require();
        }
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 29: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block13;
                }
            }
            this.Import();
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: 
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block14;
                }
            }
            this.Package();
        }
        this.jj_consume_token(0);
        try {
            SymbolTable.getInstance().resolveAllReferences();
        }
        catch (SymbolNotFoundException ex) {
            this.generateSymbolException("Parser.Specification: " + ex.getMessage());
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException("Parser.Specification: " + ex.getMessage());
        }
        this.verifyForwardReferences();
        this.generateVersionWarnings();
        this.generateImportWarnings();
        this.popGrammarProduction();
    }

    public final void Require() throws ParseException, SymbolException {
        this.pushGrammarProduction(2);
        String pre = "Parser.Require: ";
        this.jj_consume_token(42);
        this.ScopedIdentifier();
        String name = (String)this.d_arg_stack.pop();
        this.verifyVersionNotDefined(name);
        this.jj_consume_token(46);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 102: {
                this.jj_consume_token(102);
                break;
            }
            case 103: {
                this.jj_consume_token(103);
                break;
            }
            case 105: {
                this.jj_consume_token(105);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            Version version = new Version(this.token.image);
            this.addPackageVersion(name, version);
        }
        catch (NumberFormatException ex) {
            this.generateSymbolException("Parser.Require: " + ex.getMessage());
        }
        this.jj_consume_token(90);
        this.popGrammarProduction();
    }

    public final void Import() throws ParseException, SymbolException {
        this.pushGrammarProduction(3);
        String pre = "Parser.Import: ";
        Version version = null;
        this.jj_consume_token(29);
        this.ScopedIdentifier();
        String fqn = (String)this.d_arg_stack.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 102: {
                        this.jj_consume_token(102);
                        break;
                    }
                    case 103: {
                        this.jj_consume_token(103);
                        break;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    version = new Version(this.token.image);
                }
                catch (NumberFormatException nfe) {
                    this.generateSymbolException("Parser.Import: " + nfe.getMessage());
                }
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        if (version != null) {
            this.addPackageVersion(fqn, version);
        }
        this.verifyImportNotDefined(fqn);
        this.verifyImportIsPackage(fqn);
        this.addToImportPath(fqn);
        this.jj_consume_token(90);
        this.popGrammarProduction();
    }

    public final void Package() throws ParseException, SymbolException {
        this.pushGrammarProduction(4);
        String pre = "Parser.Package: ";
        boolean declared_final = false;
        Package parent = this.d_parent_stack.isEmpty() ? null : (Package)this.d_parent_stack.getFirst();
        Version version = parent != null ? parent.getSymbolID().getVersion() : new Version();
        Package p = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                declared_final = true;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        this.jj_consume_token(41);
        Comment comment = this.generateComment(this.token);
        this.ScopedIdentifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 102: {
                        this.jj_consume_token(102);
                        break;
                    }
                    case 103: {
                        this.jj_consume_token(103);
                        break;
                    }
                    case 105: {
                        this.jj_consume_token(105);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                try {
                    version = new Version(this.token.image);
                }
                catch (NumberFormatException nfe) {
                    this.generateSymbolException("Parser.Package: VERSION: Bad version number \"" + this.token.image + "\" for package " + fqn + SCOPE);
                }
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        try {
            this.verifyNotForwardReference(fqn);
            SymbolTable table = SymbolTable.getInstance();
            SymbolID id = null;
            id = new SymbolID(fqn, version);
            Symbol sym = table.resolveSymbol(id);
            p = Parser.toPackage(sym, id);
            if (p == null) {
                p = new Package(id, comment);
                p.setFinal(false);
                p.setUserSpecified(true);
                this.setMetadataValues(p);
                table.putSymbol(p);
                this.addSymbolToParentPackage(parent, id, 14);
            } else if (p.getFinal()) {
                this.generateSymbolException("Parser.Package: Attempt to reopen final package " + id.getFullName() + " version " + id.getVersion().getVersionString() + SCOPE);
            } else {
                p.setComment(Comment.combineComments(p.getComment(), comment));
            }
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException("Parser.Package: " + ex.getMessage());
        }
        this.enterScope(fqn);
        this.d_parent_stack.addFirst(p);
        this.jj_consume_token(83);
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 23: 
                case 27: 
                case 32: 
                case 35: 
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block21;
                }
            }
            this.Definition();
        }
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        this.d_parent_stack.removeFirst();
        this.leaveScope();
        if (p != null) {
            p.setFinal(declared_final);
        }
    }

    public final void Definition() throws ParseException, SymbolException {
        this.pushGrammarProduction(5);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: 
            case 23: {
                this.Class();
                break;
            }
            case 27: {
                this.Enum();
                break;
            }
            case 35: {
                this.Interface();
                break;
            }
            case 32: 
            case 41: {
                this.Package();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.popGrammarProduction();
    }

    public final void Class() throws ParseException, SymbolException {
        this.pushGrammarProduction(6);
        String pre = "Parser.Class: ";
        Comment comment = null;
        HashSet implall = new HashSet();
        boolean declared_abstract = false;
        Package parent = (Package)this.d_parent_stack.getFirst();
        Version parentVersion = parent.getSymbolID().getVersion();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                declared_abstract = true;
                comment = this.generateComment(this.token);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.jj_consume_token(23);
        if (comment == null) {
            comment = this.generateComment(this.token);
        }
        this.Identifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        SymbolID id = new SymbolID(fqn, parentVersion);
        this.verifySymbolCanBeDefined(id);
        this.removeForwardReference(fqn);
        Class cls = new Class(id, comment);
        this.setMetadataValues(cls);
        cls.setUserSpecified(true);
        try {
            SymbolTable.getInstance().putSymbol(cls);
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException("Parser.Class: " + ex.getMessage());
        }
        this.addSymbolToParentPackage(parent, id, 12);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.ScopedIdentifier();
                String identifier = (String)this.d_arg_stack.pop();
                Symbol symbol = this.resolveSymbol(identifier);
                if (symbol.getSymbolType() != 12) {
                    this.generateSymbolException("Parser.Class: EXTENDS: Symbol \"" + symbol.getSymbolID().getSymbolName() + "\" must be an class.");
                }
                this.verifyClassInheritance(cls, (Class)symbol);
                cls.setParentClass((Class)symbol);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        if (cls.getParentClass() == null && !fqn.equals(SIDL_CLASS)) {
            Class base = (Class)this.resolveFQN(SIDL_CLASS);
            this.verifyClassInheritance(cls, base);
            cls.setParentClass(base);
        }
        block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                this.AddInterface(cls, implall);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[14] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(72);
                    this.AddInterface(cls, implall);
                }
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        block13 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                this.jj_consume_token(33);
                this.AddInterface(cls, null);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block13;
                        }
                    }
                    this.jj_consume_token(72);
                    this.AddInterface(cls, null);
                }
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        this.jj_consume_token(83);
        this.Invariants(cls);
        block28: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 24: 
                case 32: 
                case 43: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block28;
                }
            }
            this.ClassMethod(cls);
        }
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        Iterator i = implall.iterator();
        while (i.hasNext()) {
            Interface ifc = (Interface)i.next();
            String name = ifc.getFullName();
            Iterator m = ifc.getMethods(true).iterator();
            while (m.hasNext()) {
                Method exist;
                Method method = (Method)m.next();
                Method defined = cls.lookupMethodByLongName(method.getLongMethodName(), false);
                if (defined != null || !(exist = cls.lookupMethodByLongName(method.getLongMethodName(), true)).isAbstract()) continue;
                Method clone = method.cloneMethod();
                clone.setDefinitionModifier(0);
                cls.addMethod(clone);
            }
        }
        this.verifyAbstract(cls, declared_abstract);
        this.popGrammarProduction();
    }

    public final void Enum() throws ParseException, SymbolException {
        this.pushGrammarProduction(7);
        String pre = "Parser.Enum: ";
        Package parent = (Package)this.d_parent_stack.getFirst();
        Version parentVersion = parent.getSymbolID().getVersion();
        this.jj_consume_token(27);
        Comment comment = this.generateComment(this.token);
        this.Identifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        SymbolID id = new SymbolID(fqn, parentVersion);
        this.verifySymbolCanBeDefined(id);
        this.verifyNotForwardReference(fqn);
        Enumeration e = new Enumeration(id, comment);
        e.setUserSpecified(true);
        this.setMetadataValues(e);
        try {
            SymbolTable.getInstance().putSymbol(e);
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException("Parser.Enum: Identifier: " + ex.getMessage());
        }
        this.addSymbolToParentPackage(parent, id, 11);
        this.jj_consume_token(83);
        this.Enumerator(e);
        while (this.jj_2_1(2)) {
            this.jj_consume_token(72);
            this.Enumerator(e);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.popGrammarProduction();
    }

    public final void Enumerator(Enumeration e) throws ParseException, SymbolException {
        this.pushGrammarProduction(8);
        String pre = "Parser.Enumerator: ";
        Comment comment = null;
        this.Identifier();
        comment = this.generateComment(this.token);
        String name = (String)this.d_arg_stack.pop();
        if (e.hasEnumerator(name)) {
            this.generateSymbolException("Parser.Enumerator: Identifier: Redefinition of enumerator \"" + name + "\".");
        }
        int value = 0;
        boolean user_defined = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                this.jj_consume_token(104);
                user_defined = true;
                try {
                    value = Integer.parseInt(this.token.image);
                }
                catch (NumberFormatException ex) {
                    this.generateSymbolException("Parser.Enumerator: EQUALS INTEGER: Invalid integer \"" + this.token.image + "\".");
                }
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
            }
        }
        if (!user_defined) {
            e.addEnumerator(name, comment);
        } else {
            e.addEnumerator(name, value, comment);
        }
        this.popGrammarProduction();
    }

    public final void Interface() throws ParseException, SymbolException {
        this.pushGrammarProduction(9);
        String pre = "Parser.Interface: ";
        Package parent = (Package)this.d_parent_stack.getFirst();
        Version parentVersion = parent.getSymbolID().getVersion();
        this.jj_consume_token(35);
        Comment comment = this.generateComment(this.token);
        this.Identifier();
        String fqn = this.getScope((String)this.d_arg_stack.pop());
        SymbolID id = new SymbolID(fqn, parentVersion);
        this.verifySymbolCanBeDefined(id);
        this.removeForwardReference(fqn);
        Interface ifc = new Interface(id, comment);
        ifc.setUserSpecified(true);
        this.setMetadataValues(ifc);
        try {
            SymbolTable.getInstance().putSymbol(ifc);
        }
        catch (SymbolRedefinitionException ex) {
            this.generateSymbolException("Parser.Interface: Identifier: " + ex.getMessage());
        }
        this.addSymbolToParentPackage(parent, id, 13);
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.AddInterface(ifc, null);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block1;
                        }
                    }
                    this.jj_consume_token(72);
                    this.AddInterface(ifc, null);
                }
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (ifc.getParentInterfaces(false).isEmpty() && !fqn.equals(SIDL_INTERFACE)) {
            Interface base = (Interface)this.resolveFQN(SIDL_INTERFACE);
            this.verifyInterfaceInheritance(ifc, base);
            ifc.addParentInterface(base);
        }
        this.jj_consume_token(83);
        this.Invariants(ifc);
        block15: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 47: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 101: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block15;
                }
            }
            this.InterfaceMethod(ifc);
        }
        this.jj_consume_token(69);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        this.popGrammarProduction();
    }

    public final void AddInterface(Extendable ext, Set set) throws ParseException, SymbolException {
        String pre = "Parser.AddInterface: ";
        this.ScopedIdentifier();
        String identifier = (String)this.d_arg_stack.pop();
        Symbol symbol = this.resolveSymbol(identifier);
        if (symbol.getSymbolType() != 13) {
            this.generateSymbolException("Parser.AddInterface: ScopedIdentifier: Symbol \"" + symbol.getSymbolID().getSymbolName() + "\" must be an interface.");
        }
        this.verifyInterfaceInheritance(ext, (Interface)symbol);
        ext.addParentInterface((Interface)symbol);
        if (set != null) {
            set.add(symbol);
        }
    }

    public final void Invariants(Extendable ext) throws ParseException, SymbolException {
        String pre = "Parser.Invariants: ";
        this.pushGrammarProduction(10);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 36: {
                this.jj_consume_token(36);
                Comment icomment = this.generateComment(this.token);
                this.Assertions(ext, null, 1, icomment);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        this.popGrammarProduction();
    }

    public final void ClassMethod(Class cls) throws ParseException, SymbolException {
        this.pushGrammarProduction(11);
        String pre = "Parser.ClassMethod: ";
        Method method = new Method();
        Comment comment = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: 
            case 32: 
            case 43: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        method.setDefinitionModifier(1);
                        break;
                    }
                    case 32: {
                        this.jj_consume_token(32);
                        method.setDefinitionModifier(2);
                        break;
                    }
                    case 43: {
                        this.jj_consume_token(43);
                        method.setDefinitionModifier(3);
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                comment = this.generateComment(this.token);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
            }
        }
        if (comment == null) {
            comment = this.generateComment(this.getToken(1));
        }
        method.setComment(comment);
        this.Method(cls, method);
        String name = cls.getFullName();
        this.verifyMethodRedefinition(cls, method);
        this.verifyMethodSignature(cls, method, name);
        this.verifyMethodStatic(cls, method, name);
        this.verifyMethodOverride(cls, method);
        cls.addMethod(method);
        this.popGrammarProduction();
    }

    public final void InterfaceMethod(Interface ifc) throws ParseException, SymbolException {
        Method method = new Method();
        method.setComment(this.generateComment(this.getToken(1)));
        this.Method(ifc, method);
        method.setDefinitionModifier(1);
        String name = ifc.getFullName();
        this.verifyMethodRedefinition(ifc, method);
        this.verifyMethodSignature(ifc, method, name);
        ifc.addMethod(method);
    }

    public final void Method(Extendable ext, Method m) throws ParseException, SymbolException {
        this.pushGrammarProduction(12);
        String pre = "Parser.Method: ";
        Comment comment = null;
        boolean copy = false;
        boolean hasAsserts = false;
        int assertType = 0;
        String short_name = null;
        String extension = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                this.jj_consume_token(47);
                m.setReturnType(new Type(0));
                m.setReturnCopy(false);
                break;
            }
            case 24: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 101: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 24: {
                        this.jj_consume_token(24);
                        copy = true;
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                this.Type();
                Type t = (Type)this.d_arg_stack.pop();
                if (copy) {
                    this.verifyCopyModifierValid(t);
                }
                m.setReturnType(t);
                m.setReturnCopy(copy);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.Identifier();
        short_name = (String)this.d_arg_stack.pop();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                this.Identifier();
                extension = (String)this.d_arg_stack.pop();
                this.jj_consume_token(68);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
        this.checkMethodNameLength(short_name, extension, this.token);
        if (extension != null) {
            m.setMethodName(short_name, extension);
        } else {
            m.setMethodName(short_name);
        }
        this.jj_consume_token(84);
        block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 30: 
            case 31: 
            case 40: {
                this.Argument();
                m.addArgument((Argument)this.d_arg_stack.pop());
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[33] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(72);
                    this.Argument();
                    m.addArgument((Argument)this.d_arg_stack.pop());
                }
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        this.jj_consume_token(70);
        block16 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: 
            case 38: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 37: {
                        this.jj_consume_token(37);
                        m.setCommunicationModifier(1);
                        break block16;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        this.verifyOnewayValid(m);
                        m.setCommunicationModifier(2);
                        break block16;
                    }
                }
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        block23 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                this.ScopedIdentifier();
                this.verifyAndAddThrows(m, (String)this.d_arg_stack.pop());
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[37] = this.jj_gen;
                            break block23;
                        }
                    }
                    this.jj_consume_token(72);
                    this.ScopedIdentifier();
                    this.verifyAndAddThrows(m, (String)this.d_arg_stack.pop());
                }
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.jj_consume_token(90);
        HashSet<String> argSet = new HashSet<String>();
        ArrayList args = m.getArgumentList();
        Iterator a = args.iterator();
        while (a.hasNext()) {
            Argument arg = (Argument)a.next();
            if (argSet.add(arg.getFormalName().toUpperCase())) continue;
            this.generateSymbolException("Parser.Method: Not all argument names to method " + m.getLongMethodName() + " are unique.");
        }
        ArrayList args2 = m.getArgumentList();
        int resolvedIndexArgs = 0;
        boolean resolvedLastIndex = false;
        Iterator i = args2.iterator();
        while (i.hasNext()) {
            Argument arg1 = (Argument)i.next();
            if (!arg1.getType().isRarray()) continue;
            if (arg1.getMode() == 2) {
                this.generateSymbolException("Parser.Method: Rarray cannot be an OUT parameter, must be either IN or INOUT.");
            }
            m.addRarrayIndex(arg1.getType().getArrayIndices());
        }
        if (m.hasRarray()) {
            Iterator indexIt = m.getRarrayIndices().iterator();
            while (indexIt.hasNext()) {
                String indexName = (String)indexIt.next();
                Iterator argIt = args2.iterator();
                while (argIt.hasNext()) {
                    Argument arg1 = (Argument)argIt.next();
                    if (indexName.compareTo(arg1.getFormalName()) != 0) continue;
                    if (arg1.getType().getType() != 7 && arg1.getType().getType() != 8) {
                        this.generateSymbolException("Parser.Method: Rarray Index arguments must be either of type Int or Long.");
                    }
                    if (arg1.getMode() != 0) {
                        this.generateSymbolException("Parser.Method: Rarray Index arguments must be IN arguments.");
                    }
                    ++resolvedIndexArgs;
                    resolvedLastIndex = true;
                    break;
                }
                if (resolvedLastIndex) {
                    resolvedLastIndex = false;
                    continue;
                }
                this.generateSymbolException("Parser.Method: Rarray Index argument " + indexName + " cannot be resolved, please include it in the " + "argument list.");
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                assertType = 2;
                comment = this.generateComment(this.token);
                this.Assertions(ext, m, assertType, comment);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                assertType = 3;
                this.Assertions(ext, m, assertType, comment);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                comment = this.generateComment(this.token);
                assertType = 4;
                this.Assertions(ext, m, assertType, comment);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                assertType = 5;
                this.Assertions(ext, m, assertType, comment);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        this.popGrammarProduction();
    }

    public final void Argument() throws ParseException, SymbolException {
        this.pushGrammarProduction(13);
        boolean copy = false;
        int mode = 0;
        String name = null;
        Type type = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.jj_consume_token(24);
                copy = true;
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                mode = 0;
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                mode = 2;
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                mode = 1;
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 101: {
                this.Type();
                type = (Type)this.d_arg_stack.pop();
                this.Identifier();
                name = (String)this.d_arg_stack.pop();
                if (copy) {
                    this.verifyCopyModifierValid(type);
                }
                Argument arg = new Argument(copy, mode, type, name);
                this.d_arg_stack.push(arg);
                this.popGrammarProduction();
                break;
            }
            case 49: {
                this.Rarray();
                Type rarrayType = (Type)this.d_arg_stack.pop();
                name = (String)this.d_arg_stack.pop();
                Argument arg1 = new Argument(copy, mode, rarrayType, name);
                this.d_arg_stack.push(arg1);
                this.popGrammarProduction();
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void Type() throws ParseException, SymbolException {
        void var1_1;
        this.pushGrammarProduction(14);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.jj_consume_token(50);
                Type type = new Type(1);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                Type type = new Type(2);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                Type type = new Type(3);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                Type type = new Type(4);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                Type type = new Type(5);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                Type type = new Type(6);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                Type type = new Type(7);
                break;
            }
            case 57: {
                this.jj_consume_token(57);
                Type type = new Type(8);
                break;
            }
            case 58: {
                this.jj_consume_token(58);
                Type type = new Type(9);
                break;
            }
            case 59: {
                this.jj_consume_token(59);
                Type type = new Type(10);
                break;
            }
            case 48: {
                this.Array();
                Type type = (Type)this.d_arg_stack.pop();
                break;
            }
            case 101: {
                this.SymbolType();
                Type type = new Type((SymbolID)this.d_arg_stack.pop());
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.d_arg_stack.push(var1_1);
        this.popGrammarProduction();
    }

    public final void Array() throws ParseException, SymbolException {
        this.pushGrammarProduction(15);
        String pre = "Parser.Array: ";
        int dim = 1;
        int order = 0;
        Type arrayType = null;
        this.jj_consume_token(48);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 62: {
                this.jj_consume_token(62);
                arrayType = null;
                break;
            }
            case 60: {
                this.jj_consume_token(60);
                block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 101: {
                        this.Type();
                        arrayType = (Type)this.d_arg_stack.pop();
                        if (arrayType.isArray()) {
                            this.generateSymbolException("Parser.Array: Array Type: Nested arrays are not supported.");
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 72: {
                                this.jj_consume_token(72);
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 104: {
                                        this.jj_consume_token(104);
                                        try {
                                            dim = Integer.parseInt(this.token.image);
                                        }
                                        catch (NumberFormatException e) {
                                            this.generateSymbolException("Parser.Array: COMMA INTEGER: \"" + this.token.image + "\" is an llegal array dimension:" + "NumberFormatException detected.");
                                        }
                                        if (dim < 1 || 7 < dim) {
                                            this.generateSymbolException("Parser.Array: COMMA INTEGER: \"" + this.token.image + "\" is not in the valid array dimension range of 1.." + 7 + SCOPE);
                                        }
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 72: {
                                                this.jj_consume_token(72);
                                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                                    case 110: {
                                                        this.jj_consume_token(110);
                                                        order = 1;
                                                        break block5;
                                                    }
                                                    case 111: {
                                                        this.jj_consume_token(111);
                                                        order = 2;
                                                        break block5;
                                                    }
                                                }
                                                this.jj_la1[47] = this.jj_gen;
                                                this.jj_consume_token(-1);
                                                throw new ParseException();
                                            }
                                        }
                                        this.jj_la1[48] = this.jj_gen;
                                        break block5;
                                    }
                                    case 110: 
                                    case 111: {
                                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                            case 110: {
                                                this.jj_consume_token(110);
                                                order = 1;
                                                break block5;
                                            }
                                            case 111: {
                                                this.jj_consume_token(111);
                                                order = 2;
                                                break block5;
                                            }
                                        }
                                        this.jj_la1[49] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                this.jj_la1[50] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                    }
                }
                this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (null == arrayType) {
            dim = 0;
        }
        this.d_arg_stack.push(new Type(arrayType, dim, order));
        this.popGrammarProduction();
    }

    public final void Rarray() throws ParseException, SymbolException {
        this.pushGrammarProduction(17);
        String pre = "Parser.Rarray: ";
        int dim = 1;
        boolean order = true;
        Type arrayType = null;
        Object name = null;
        Vector<String> indexVector = new Vector<String>();
        this.jj_consume_token(49);
        this.jj_consume_token(60);
        this.Type();
        arrayType = (Type)this.d_arg_stack.pop();
        int intType = arrayType.getType();
        if (arrayType.isArray()) {
            this.generateSymbolException("Parser.Rarray: Nested arrays are not supported.");
        }
        if (intType < 1 || intType > 9) {
            this.generateSymbolException("Parser.Rarray: RARRAYs may only be of basic types (dcomplex, double, fcomplex, float, int, long, or opaque).");
        }
        if (intType == 1 || intType == 2) {
            this.generateSymbolException("Parser.Rarray: RARRAYs may not be of type boolean or char. Only of dcomplex, double, fcomplex, float, int, long, or opaque.");
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 72: {
                this.jj_consume_token(72);
                this.jj_consume_token(104);
                try {
                    dim = Integer.parseInt(this.token.image);
                }
                catch (NumberFormatException e) {
                    this.generateSymbolException("Parser.Rarray: COMMA INTEGER: \"" + this.token.image + "\" is an llegal array dimension:" + "NumberFormatException detected.");
                }
                if (dim >= 1 && 7 >= dim) break;
                this.generateSymbolException("Parser.Rarray: COMMA INTEGER: \"" + this.token.image + "\" is not in the valid array dimension range of " + "1.." + 7 + SCOPE);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.jj_consume_token(61);
        if (null == arrayType) {
            this.generateSymbolException("Parser.Rarray: RARRAY must have a type.");
        }
        this.Identifier();
        this.jj_consume_token(84);
        this.Identifier();
        indexVector.add((String)this.d_arg_stack.pop());
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block8;
                }
            }
            this.jj_consume_token(72);
            this.Identifier();
            indexVector.add((String)this.d_arg_stack.pop());
        }
        this.jj_consume_token(70);
        if (dim != indexVector.size()) {
            this.generateSymbolException("Parser.Rarray: The number of index variables must equal the dimension of the RARRAY.");
        }
        this.d_arg_stack.push(new Type(arrayType, dim, indexVector));
        this.popGrammarProduction();
    }

    public final void SymbolType() throws ParseException, SymbolException {
        String pre = "Parser.SymbolType: ";
        this.ScopedIdentifier();
        String identifier = (String)this.d_arg_stack.pop();
        Symbol symbol = this.tryResolveSymbol(identifier);
        if (symbol != null) {
            if (symbol.getSymbolType() == 14) {
                this.generateSymbolException("Parser.SymbolType: ScopedIdentifier: Symbol \"" + symbol.getSymbolID().getSymbolName() + "\" cannot be used as a SIDL type.");
            }
            this.d_arg_stack.push(symbol.getSymbolID());
        } else {
            String fqn = this.getScope(identifier);
            this.addForwardReference(fqn);
            this.d_arg_stack.push(new SymbolID(fqn, this.lookupVersion(fqn)));
        }
    }

    public final void Assertions(Extendable ext, Method m, int type, Comment comment) throws ParseException, SymbolException {
        this.pushGrammarProduction(20);
        String pre = "Parser.Assertions: ";
        Comment currcomment = null;
        boolean first = true;
        AssertionExpression lhs = null;
        AssertionExpression rhs = null;
        String tag = null;
        do {
            this.AssertionExpr();
            currcomment = this.generateComment(this.token);
            lhs = (AssertionExpression)this.d_arg_stack.pop();
            tag = null;
            rhs = null;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 71: {
                    this.jj_consume_token(71);
                    this.AssertionExpr();
                    rhs = (AssertionExpression)this.d_arg_stack.pop();
                    break;
                }
                default: {
                    this.jj_la1[56] = this.jj_gen;
                }
            }
            this.jj_consume_token(90);
            if (first) {
                if (comment != null && currcomment == null) {
                    currcomment = comment;
                }
                first = false;
            }
            AssertionExpression expr = null;
            String name = this.getSourceName(ext, m);
            if (rhs != null) {
                String idLitName = "gov.llnl.babel.symbols.IdentifierLiteral";
                if (!lhs.getClass().getName().equals(idLitName)) {
                    this.generateSymbolException("Parser.Assertions: Invalid use of colon operator in assertion clause of " + name + ". Tag cannot be parsed into " + "class \"" + lhs.getClass().getName() + "\" but must be an \"" + idLitName + "\" instead.");
                }
                tag = ((IdentifierLiteral)lhs).getIdentifier();
                if (((IdentifierLiteral)lhs).isReserved()) {
                    this.generateSymbolException("Parser.Assertions: reserved literal \"" + tag + "\" cannot be used as a tag in an assertion clause but found in " + name + "s \"" + lhs.toString() + "\".");
                }
                if (((IdentifierLiteral)lhs).hasParens()) {
                    this.generateSymbolException("Parser.Assertions: parentheses are not allowed for a tag in an assertion clause but found in " + name + "s \"" + lhs.toString() + "\".");
                }
                expr = rhs;
            } else {
                expr = lhs;
            }
            try {
                Assertion assertion = new Assertion(type, name, tag, currcomment);
                assertion.setExpression(expr);
                switch (type) {
                    case 1: {
                        ext.addInvariant(assertion);
                        break;
                    }
                    case 2: 
                    case 3: {
                        if (m != null) {
                            m.addAssertion(assertion);
                            break;
                        }
                        this.generateSymbolException("Parser.Assertions: " + name + ": Cannot add precondition " + "tagged \"" + tag + "\" to a null method.");
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (m != null) {
                            m.addAssertion(assertion);
                            break;
                        }
                        this.generateSymbolException("Parser.Assertions: " + name + ": Cannot add postcondition " + "tagged \"" + tag + "\" to a null method.");
                        break;
                    }
                    default: {
                        this.generateSymbolException("Parser.Assertions: " + name + ": Unrecognized assertion type" + " " + type + " encountered when attempting to add assertion " + "tagged \"" + tag + "\" to the symbol table.");
                        break;
                    }
                }
            }
            catch (AssertionException ex) {
                this.generateSymbolException("Parser.Assertions: " + ex.getMessage());
            }
        } while (this.jj_2_2(2));
        this.popGrammarProduction();
    }

    public final void AssertionExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(21);
        int op = 0;
        Object lhs = null;
        this.ConditionalExpr();
        int numOnStack = 1;
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: 
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 76: {
                    this.jj_consume_token(76);
                    op = 8;
                    break;
                }
                case 75: {
                    this.jj_consume_token(75);
                    op = 7;
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.ConditionalExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void ConditionalExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(22);
        this.InclusiveOrExpr();
        this.popGrammarProduction();
    }

    public final void InclusiveOrExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(23);
        Object lhs = null;
        this.ExclusiveOrExpr();
        int numOnStack = 1;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 85: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(85);
            this.ExclusiveOrExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, false, 16);
        }
        this.popGrammarProduction();
    }

    public final void ExclusiveOrExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(24);
        Object lhs = null;
        this.AndExpr();
        int numOnStack = 1;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(95);
            this.AndExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, false, 22);
        }
        this.popGrammarProduction();
    }

    public final void AndExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(25);
        Object lhs = null;
        this.EqualityExpr();
        int numOnStack = 1;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(65);
            this.EqualityExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, false, 1);
        }
        this.popGrammarProduction();
    }

    public final void EqualityExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(26);
        int op = 0;
        Object lhs = null;
        this.RelationalExpr();
        int numOnStack = 1;
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: 
                case 63: 
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    this.jj_consume_token(63);
                    op = 3;
                    break;
                }
                case 81: {
                    this.jj_consume_token(81);
                    op = 15;
                    break;
                }
                case 62: {
                    this.jj_consume_token(62);
                    op = 10;
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.RelationalExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void RelationalExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(27);
        int op = 0;
        Object lhs = null;
        this.ShiftExpr();
        int numOnStack = 1;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 60: 
                case 61: 
                case 73: 
                case 78: {
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 60: {
                    this.jj_consume_token(60);
                    op = 11;
                    break;
                }
                case 61: {
                    this.jj_consume_token(61);
                    op = 6;
                    break;
                }
                case 78: {
                    this.jj_consume_token(78);
                    op = 9;
                    break;
                }
                case 73: {
                    this.jj_consume_token(73);
                    op = 5;
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.ShiftExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void ShiftExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(28);
        int op = 0;
        Object lhs = null;
        this.AdditiveExpr();
        int numOnStack = 1;
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 91: 
                case 92: {
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 91: {
                    this.jj_consume_token(91);
                    op = 20;
                    break;
                }
                case 92: {
                    this.jj_consume_token(92);
                    op = 21;
                    break;
                }
                default: {
                    this.jj_la1[67] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.AdditiveExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void AdditiveExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(29);
        Object lhs = null;
        int op = 0;
        this.MultiplicativeExpr();
        int numOnStack = 1;
        while (this.jj_2_3(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    this.jj_consume_token(87);
                    op = 17;
                    break;
                }
                case 74: {
                    this.jj_consume_token(74);
                    op = 12;
                    break;
                }
                default: {
                    this.jj_la1[68] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.MultiplicativeExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void MultiplicativeExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(30);
        Object lhs = null;
        int op = 0;
        this.PowerExpr();
        int numOnStack = 1;
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: 
                case 79: 
                case 88: 
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    this.jj_consume_token(66);
                    op = 14;
                    break;
                }
                case 93: {
                    this.jj_consume_token(93);
                    op = 2;
                    break;
                }
                case 79: {
                    this.jj_consume_token(79);
                    op = 13;
                    break;
                }
                case 88: {
                    this.jj_consume_token(88);
                    op = 19;
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.PowerExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void PowerExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(30);
        Object lhs = null;
        int op = 0;
        this.UnaryExpr();
        int numOnStack = 1;
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 86: {
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: {
                    this.jj_consume_token(67);
                    op = 4;
                    break;
                }
                case 86: {
                    this.jj_consume_token(86);
                    op = 18;
                    break;
                }
                default: {
                    this.jj_la1[72] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.d_arg_stack.push(new Integer(op));
            ++numOnStack;
            this.UnaryExpr();
            ++numOnStack;
        }
        if (numOnStack > 1) {
            this.createBinaryExpressions(numOnStack, true, 0);
        }
        this.popGrammarProduction();
    }

    public final void UnaryExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(32);
        String pre = "Parser.UnaryExpr: ";
        int op = 0;
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 77: 
            case 80: 
            case 94: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 77: {
                        this.jj_consume_token(77);
                        op = 2;
                        break block1;
                    }
                    case 80: {
                        this.jj_consume_token(80);
                        op = 4;
                        break block1;
                    }
                    case 94: {
                        this.jj_consume_token(94);
                        op = 1;
                        break block1;
                    }
                }
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[74] = this.jj_gen;
            }
        }
        this.PostfixExpr();
        if (op != 0) {
            try {
                AssertionExpression expr = (AssertionExpression)this.d_arg_stack.pop();
                UnaryExpression ue = new UnaryExpression(op, expr);
                this.d_arg_stack.push(ue);
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.UnaryExpr: PostfixExpr: " + aex.getMessage());
            }
        }
        this.popGrammarProduction();
    }

    public final void PostfixExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(33);
        String pre = "Parser.PostfixExpr: ";
        MethodCall mc = null;
        if (this.jj_2_4(3)) {
            this.Identifier();
            String id = (String)this.d_arg_stack.pop();
            this.jj_consume_token(84);
            try {
                mc = new MethodCall(id);
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.PostfixExpr: OPEN_PAREN: " + aex.getMessage());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 77: 
                case 80: 
                case 83: 
                case 84: 
                case 94: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 103: 
                case 104: 
                case 108: 
                case 109: {
                    this.AddArguments(mc);
                    break;
                }
                default: {
                    this.jj_la1[75] = this.jj_gen;
                }
            }
            this.jj_consume_token(70);
            this.d_arg_stack.push(mc);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 83: 
                case 84: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 103: 
                case 104: 
                case 108: 
                case 109: {
                    this.PrimaryExpr();
                    break;
                }
                default: {
                    this.jj_la1[76] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        this.popGrammarProduction();
    }

    public final void PrimaryExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(34);
        String pre = "Parser.PrimaryExpr: ";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 103: 
            case 104: 
            case 108: 
            case 109: {
                this.LiteralExpr();
                break;
            }
            case 101: {
                this.Identifier();
                String id = (String)this.d_arg_stack.pop();
                try {
                    this.d_arg_stack.push(new IdentifierLiteral(id));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.PrimaryExpr: Identifier: " + aex.getMessage());
                }
                catch (Exception ex) {
                    this.generateSymbolException("Parser.PrimaryExpr: Identifier: Problem instantiating an IdentifierLiteral for " + id + ": " + ex.getMessage());
                }
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                this.ConditionalExpr();
                this.jj_consume_token(70);
                AssertionExpression ae = (AssertionExpression)this.d_arg_stack.pop();
                ae.setParens(true);
                this.d_arg_stack.push(ae);
                break;
            }
            default: {
                this.jj_la1[77] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.popGrammarProduction();
    }

    public final void LiteralExpr() throws ParseException, SymbolException {
        this.pushGrammarProduction(36);
        String pre = "Parser.LiteralExpr: ";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 97: {
                this.jj_consume_token(97);
                try {
                    this.d_arg_stack.push(new IdentifierLiteral("null"));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: NULL: " + aex.getMessage());
                }
                break;
            }
            case 98: {
                this.jj_consume_token(98);
                try {
                    this.d_arg_stack.push(new IdentifierLiteral("pure"));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: PURE: " + aex.getMessage());
                }
                break;
            }
            case 99: {
                this.jj_consume_token(99);
                try {
                    this.d_arg_stack.push(new IdentifierLiteral("result"));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: RESULT: " + aex.getMessage());
                }
                break;
            }
            case 100: {
                this.jj_consume_token(100);
                try {
                    this.d_arg_stack.push(new BooleanLiteral(true));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: TRUE: " + aex.getMessage());
                }
                break;
            }
            case 96: {
                this.jj_consume_token(96);
                try {
                    this.d_arg_stack.push(new BooleanLiteral(false));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: FALSE: " + aex.getMessage());
                }
                break;
            }
            case 103: {
                this.FloatLit();
                break;
            }
            case 104: {
                this.IntegerLit();
                break;
            }
            case 83: {
                this.ComplexLit();
                break;
            }
            case 109: {
                this.jj_consume_token(109);
                try {
                    int len = this.token.image.length();
                    this.d_arg_stack.push(new StringLiteral(this.token.image.substring(1, len - 1)));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: STRING: " + aex.getMessage());
                }
                break;
            }
            case 108: {
                this.jj_consume_token(108);
                try {
                    this.d_arg_stack.push(new CharacterLiteral(this.token.image.charAt(1)));
                }
                catch (AssertionException aex) {
                    this.generateSymbolException("Parser.LiteralExpr: CHARACTER: " + aex.getMessage());
                }
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.popGrammarProduction();
    }

    public final void ComplexLit() throws ParseException, SymbolException {
        String pre = "Parser.ComplexLit: ";
        DoubleLiteral rD = null;
        DoubleLiteral iD = null;
        LongLiteral rL = null;
        LongLiteral iL = null;
        this.jj_consume_token(83);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 103: {
                this.FloatLit();
                try {
                    rD = (DoubleLiteral)this.d_arg_stack.pop();
                }
                catch (NumberFormatException ex) {
                    this.generateSymbolException("Parser.ComplexLit: double.real: Invalid floating point number \"" + this.token.image + "\" detected during complex number " + "expression parsing.");
                }
                break;
            }
            case 104: {
                this.IntegerLit();
                try {
                    rL = (LongLiteral)this.d_arg_stack.pop();
                }
                catch (NumberFormatException ex) {
                    this.generateSymbolException("Parser.ComplexLit: float.real: Invalid floating point number \"" + this.token.image + "\" detected during complex number " + "expression parsing.");
                }
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(72);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 103: {
                this.FloatLit();
                try {
                    iD = (DoubleLiteral)this.d_arg_stack.pop();
                }
                catch (NumberFormatException ex) {
                    this.generateSymbolException("Parser.ComplexLit: double.imaginary: Invalid floating point number \"" + this.token.image + "\" detected during complex " + "number expression parsing.");
                }
                break;
            }
            case 104: {
                this.IntegerLit();
                try {
                    iL = (LongLiteral)this.d_arg_stack.pop();
                }
                catch (NumberFormatException ex) {
                    this.generateSymbolException("Parser.ComplexLit: float.imaginary: Invalid floating point number \"" + this.token.image + "\" detected during complex " + "number expression parsing.");
                }
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(69);
        if (rD != null && iD != null) {
            try {
                this.d_arg_stack.push(new DComplexLiteral(rD, iD));
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.ComplexLit: dcomplex: " + aex.getMessage());
            }
        } else if (rD != null && iL != null) {
            try {
                this.d_arg_stack.push(new DComplexLiteral(rD, iL));
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.ComplexLit: dcomplex: " + aex.getMessage());
            }
        } else if (rL != null && rD != null) {
            try {
                this.d_arg_stack.push(new DComplexLiteral(rD, iL));
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.ComplexLit: dcomplex: " + aex.getMessage());
            }
        } else if (rL != null && iL != null) {
            try {
                this.d_arg_stack.push(new FComplexLiteral(rL, iL));
            }
            catch (AssertionException aex) {
                this.generateSymbolException("Parser.ComplexLit: fcomplex: " + aex.getMessage());
            }
        } else {
            this.generateSymbolException("Parser.ComplexLit: complex: Unable to build a complex literal due to unrecognized or incompatible real and/or imaginary parts.");
        }
    }

    public final void FloatLit() throws ParseException, SymbolException {
        String pre = "Parser.FloatLit: ";
        this.jj_consume_token(103);
        try {
            Double dValue = Double.valueOf(this.token.image);
            this.d_arg_stack.push(new DoubleLiteral(dValue, this.token.image));
        }
        catch (AssertionException aex) {
            this.generateSymbolException("Parser.FloatLit: FLOAT: " + aex.getMessage());
        }
        catch (NumberFormatException ex) {
            this.generateSymbolException("Parser.FloatLit: FLOAT: Invalid number \"" + this.token.image + "\" detected during expression parsing.");
        }
    }

    public final void IntegerLit() throws ParseException, SymbolException {
        String pre = "Parser.IntegerLit: ";
        this.jj_consume_token(104);
        try {
            Long lValue = Long.valueOf(this.token.image);
            this.d_arg_stack.push(new LongLiteral(lValue, this.token.image));
        }
        catch (AssertionException aex) {
            this.generateSymbolException("Parser.IntegerLit: INTEGER: " + aex.getMessage());
        }
        catch (NumberFormatException ex) {
            this.generateSymbolException("Parser.IntegerLit: INTEGER: Invalid number \"" + this.token.image + "\" detected during expression parsing.");
        }
    }

    public final void AddArguments(MethodCall mc) throws ParseException, SymbolException {
        this.pushGrammarProduction(37);
        this.ConditionalExpr();
        mc.addArgument((AssertionExpression)this.d_arg_stack.pop());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 72: {
                    break;
                }
                default: {
                    this.jj_la1[81] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(72);
            this.ConditionalExpr();
            mc.addArgument((AssertionExpression)this.d_arg_stack.pop());
        }
        this.popGrammarProduction();
    }

    public final void ScopedIdentifier() throws ParseException, SymbolException {
        this.pushGrammarProduction(38);
        StringBuffer buffer = new StringBuffer();
        this.Identifier();
        buffer.append((String)this.d_arg_stack.pop());
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 89: {
                    break;
                }
                default: {
                    this.jj_la1[82] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(89);
            this.Identifier();
            buffer.append(SCOPE);
            buffer.append((String)this.d_arg_stack.pop());
        }
        this.d_arg_stack.push(buffer.toString());
        this.popGrammarProduction();
    }

    public final void Identifier() throws ParseException, SymbolException {
        this.jj_consume_token(101);
        this.verifyReservedWords(this.token.image);
        this.d_arg_stack.push(this.token.image);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_3R_28() {
        Token xsp;
        block3: {
            if (this.jj_3R_35()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_36()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(98)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(88)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_73()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_74()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_75()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_76()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_77()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_78()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_79()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_80()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_81()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_82()) {
                                                return true;
                                            }
                                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(104)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_92() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_scan_token(93)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        if (this.jj_scan_token(81)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_90()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_91()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_92()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_93()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_63()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_64()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_65()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        Token xsp;
        block3: {
            if (this.jj_3R_37()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_88()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_scan_token(103)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        Token xsp;
        block3: {
            if (this.jj_3R_56()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_57()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_59() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        if (this.jj_3R_66()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_59()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_60()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_3R_55()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token xsp;
        block3: {
            if (this.jj_3R_53()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_54()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_3R_38()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_30()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_31()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_32()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        Token xsp;
        block3: {
            if (this.jj_3R_32()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3_3()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_34()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(70)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        if (this.jj_scan_token(71)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_52()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(95)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_29()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_43() {
        Token xsp;
        block3: {
            if (this.jj_3R_47()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_48()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_3R_86()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(94)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_3R_85()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_84()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_scan_token(80)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(83)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_97()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        if (this.jj_scan_token(77)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_27() {
        if (this.jj_3R_33()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        Token xsp;
        block3: {
            if (this.jj_3R_67()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_68()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_50()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_51()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        Token xsp;
        block3: {
            if (this.jj_3R_43()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_44()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_scan_token(101)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(108)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_3R_39()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_27()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_3R_87()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        if (this.jj_3R_86()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_3R_85()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_94()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_95()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_69()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_70()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_71()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_72()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        Token xsp;
        block3: {
            if (this.jj_3R_42()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_89()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_41() {
        if (this.jj_scan_token(75)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(100)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        Token xsp;
        block3: {
            if (this.jj_3R_61()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_62()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_36() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_41()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(99)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_3R_35()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public Parser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public Parser(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 83; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            java.util.Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[113];
        for (i = 0; i < 113; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 83; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((this.jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((this.jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 113; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, ParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

