/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;

public abstract class AssertionExpression {
    private boolean d_parens = false;
    private Type d_return_type = null;
    private boolean d_valid = false;
    public static final String ERROR_SEMANTIC_VALIDATION = "Semantic Validation Failure: ";

    public AssertionExpression(boolean valid) {
        this.d_valid = valid;
    }

    public void setParens(boolean parens) {
        this.d_parens = parens;
    }

    public boolean hasParens() {
        return this.d_parens;
    }

    protected void setReturnType(int return_type) throws AssertionException {
        if (return_type != 16) {
            if (return_type < 1 || return_type > 11) {
                throw new AssertionException("Return type value \"" + return_type + "\" invalid, must be in " + 1 + "..." + 11 + " or " + 16 + ".");
            }
            if (this.d_return_type == null || this.d_return_type.getBasicType() != return_type) {
                this.d_return_type = new Type(return_type);
            }
        } else {
            throw new AssertionException("Programming Error: Cannot set return type of an array using setReturnType(int).");
        }
    }

    protected void setReturnType(Type return_type) throws AssertionException {
        if (return_type != null) {
            if (return_type.getBasicType() == 16) {
                this.d_return_type = new Type(return_type.getArrayType(), return_type.getArrayDimension(), return_type.getArrayOrder());
            } else {
                this.setReturnType(return_type.getBasicType());
            }
        } else {
            throw new AssertionException("Cannot set return type of an AssertionExpression to a null Type.");
        }
    }

    public Type getReturnType() {
        return this.d_return_type;
    }

    public String getReturnTypeName() {
        return this.d_return_type == null ? null : this.d_return_type.getTypeName();
    }

    public int getReturnTypeValue() {
        return this.d_return_type == null ? -1 : this.d_return_type.getBasicType();
    }

    public boolean returnIsArray() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 16;
    }

    public boolean returnIsBoolean() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 1;
    }

    public boolean returnIsCharacter() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 2;
    }

    public boolean returnIsDComplex() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 3;
    }

    public boolean returnIsDouble() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 4;
    }

    public boolean returnIsFComplex() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 5;
    }

    public boolean returnIsFloat() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 6;
    }

    public boolean returnIsInteger() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 7;
    }

    public boolean returnIsLong() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 8;
    }

    public boolean returnIsNumericArray() {
        return this.d_return_type != null && this.d_return_type.isNumericArray();
    }

    public boolean returnIsOpaque() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 9;
    }

    public boolean returnIsString() {
        return this.d_return_type != null && this.d_return_type.getBasicType() == 10;
    }

    protected void setReturnToBoolean() throws AssertionException {
        this.setReturnType(1);
    }

    protected void setReturnToCharacter() throws AssertionException {
        this.setReturnType(2);
    }

    protected void setReturnToDComplex() throws AssertionException {
        this.setReturnType(3);
    }

    protected void setReturnToDouble() throws AssertionException {
        this.setReturnType(4);
    }

    protected void setReturnToFComplex() throws AssertionException {
        this.setReturnType(5);
    }

    protected void setReturnToFloat() throws AssertionException {
        this.setReturnType(6);
    }

    protected void setReturnToInteger() throws AssertionException {
        this.setReturnType(7);
    }

    protected void setReturnToLong() throws AssertionException {
        this.setReturnType(8);
    }

    protected void setReturnToOpaque() throws AssertionException {
        this.setReturnType(9);
    }

    protected void setReturnToString() throws AssertionException {
        this.setReturnType(10);
    }

    public boolean isValid() {
        return this.d_return_type != null && this.d_valid;
    }

    public abstract boolean hasPure();

    public abstract boolean hasResult();

    public abstract boolean hasMethodCall();

    public abstract boolean hasReservedMethod(int var1);

    public abstract boolean hasUnreservedMethod(boolean var1);

    public abstract boolean requiresExtendableContext();

    public abstract boolean requiresMethodContext();

    protected String getExceptionPrefix(Extendable ext, Method m) {
        return ext == null ? "AssertionExpression" : (m == null ? ext.getFullName() : ext.getFullName() + "." + m.getLongMethodName());
    }

    protected String getExceptionPrefix(Extendable ext) {
        return ext == null ? "AssertionExpression" : ext.getFullName();
    }

    protected abstract void validateSemantics(Extendable var1, Method var2) throws AssertionException;

    public void validateExpression(Extendable ext, Method m) throws AssertionException {
        if (ext == null && this.requiresExtendableContext()) {
            throw new AssertionException(this.getExceptionPrefix(ext, m), "Cannot validate the expression without access to its extendable context.");
        }
        if (m == null && this.requiresMethodContext()) {
            throw new AssertionException(this.getExceptionPrefix(ext, m), "Cannot validate the expression without access to its method context.");
        }
        this.validateSemantics(ext, m);
        this.d_valid = true;
    }

    public abstract ArrayList getArrayIterMacros(String var1, int[] var2);

    public abstract int getNumArrayIterMacrosByType(char var1);

    public abstract String cExpression(String var1, int[] var2);

    public abstract String toString();
}

