/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.BadRegexException;
import gov.llnl.babel.symbols.RegexUnsupportedException;
import gov.llnl.babel.symbols.SymbolID;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class RegexMatch {
    private static Method s_compile;
    private static Class s_charSequence;
    private Object d_pattern;
    private Method d_matcher;

    public static boolean hasRegex() {
        return s_compile != null;
    }

    public RegexMatch(String regex) throws RegexUnsupportedException, BadRegexException {
        block6: {
            if (RegexMatch.hasRegex()) {
                try {
                    Object[] args = new Object[]{regex};
                    this.d_pattern = s_compile.invoke(null, args);
                    Class[] argTypes = new Class[]{s_charSequence};
                    this.d_matcher = this.d_pattern.getClass().getMethod("matcher", argTypes);
                    try {
                        this.match("");
                        break block6;
                    }
                    catch (InvocationTargetException ite) {
                        throw new RegexUnsupportedException();
                    }
                }
                catch (InvocationTargetException ite) {
                    throw new BadRegexException(ite.getTargetException().getMessage());
                }
                catch (Exception e) {
                    throw new RegexUnsupportedException();
                }
            }
            throw new RegexUnsupportedException();
        }
    }

    private boolean match(String str) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] args = new Object[]{str};
        Object matcher = this.d_matcher.invoke(this.d_pattern, args);
        Class[] argTypes = new Class[]{};
        args = new Object[]{};
        Boolean result = (Boolean)matcher.getClass().getMethod("matches", argTypes).invoke(matcher, args);
        return result;
    }

    public boolean match(SymbolID id) {
        try {
            return this.match(id.getFullName());
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("java.util.regex package is incomplete");
        }
        catch (InvocationTargetException ite) {
            System.err.println("Unexpected exception from matches.");
        }
        catch (IllegalAccessException iae) {
            System.err.println("Required method from java.util.regex package is unavailable");
        }
        return false;
    }

    static {
        try {
            Class<?> pattern = Class.forName("java.util.regex.Pattern");
            s_charSequence = Class.forName("java.lang.CharSequence");
            Class[] args = new Class[]{"".getClass()};
            s_compile = pattern.getMethod("compile", args);
        }
        catch (ClassNotFoundException cnfe) {
            s_compile = null;
        }
        catch (NoSuchMethodException nsme) {
            System.err.println("Class java.util.regex.Pattern exists but does not have compile method: " + nsme.getMessage());
            s_compile = null;
        }
        catch (SecurityException se) {
            System.err.println("Class java.util.regex.Pattern exists but does not have public compile method: " + se.getMessage());
            s_compile = null;
        }
    }
}

