// 
// File:          decaf_Framework.cc
// Symbol:        decaf.Framework-v0.6.3
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Client-side glue code for decaf.Framework
// 
// WARNING: Automatically generated; changes will be lost
// 
// babel-version = 0.10.2
// 

#ifndef included_decaf_Framework_hh
#include "decaf_Framework.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_BaseClass_hh
#include "sidl_BaseClass.hh"
#endif
#ifndef included_sidl_BaseException_hh
#include "sidl_BaseException.hh"
#endif
#include "sidl_String.h"
#include "babel_config.h"
#ifdef SIDL_DYNAMIC_LIBRARY
#include <stdio.h>
#include <stdlib.h>
#include "sidl_Loader.hh"
#endif


//////////////////////////////////////////////////
// 
// User Defined Methods
// 


/**
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */
bool
decaf::Framework::isSame( /* in */ ::sidl::BaseInterface iobj )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isSame))(d_self,
    /* in */ iobj._get_ior() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */
::sidl::BaseInterface
decaf::Framework::queryInt( /* in */ const ::std::string& name )
throw ()

{
  ::sidl::BaseInterface _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::BaseInterface( (*(d_self->d_epv->f_queryInt))(d_self,
    /* in */ name.c_str() ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */
bool
decaf::Framework::isType( /* in */ const ::std::string& name )
throw ()

{
  bool _result;
  sidl_bool _local_result;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_isType))(d_self, /* in */ name.c_str() );
  /*dispatch to ior*/
  _result = _local_result;
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return the meta-data about the class implementing this interface.
 */
::sidl::ClassInfo
decaf::Framework::getClassInfo(  )
throw ()

{
  ::sidl::ClassInfo _result;
  /*pack args to dispatch to ior*/
  _result = ::sidl::ClassInfo( (*(d_self->d_epv->f_getClassInfo))(d_self ),
    false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Return the named port from the specified component id.
 */
::gov::cca::Port
decaf::Framework::lookupPort( /* in */ ::gov::cca::ComponentID componentID,
  /* in */ const ::std::string& portName )
throw ()

{
  ::gov::cca::Port _result;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::Port( (*(d_self->d_epv->f_lookupPort))(d_self,
    /* in */ componentID._get_ior(), /* in */ portName.c_str() ), false);
  /*dispatch to ior*/
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Framework creates providing component, registers provides port and connects to
 * using port for special cases (e.g. BuilderService)
 * @param type the string name of the port type 
 * (currently accepts only "gov.cca.ports.BuilderServices" and 
 * gov.cca.ports.ConnectionEventServices)
 * @param componentID the ID of the user component
 * @param portName the userPortName on the user component
 */
void
decaf::Framework::provideRequestedServices( /* in */ ::gov::cca::ComponentID 
  componentID, /* in */ const ::std::string& portName,
  /* in */ const ::std::string& type )
throw ()

{

  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_provideRequestedServices))(d_self,
    /* in */ componentID._get_ior(), /* in */ portName.c_str(),
    /* in */ type.c_str() );
  /*dispatch to ior*/
  /*unpack results and cleanup*/
}


/**
 * user-defined non-static method.
 */
void
decaf::Framework::setInstanceRelease( /* in */ ::gov::cca::ComponentID cid,
  /* in */ ::gov::cca::ComponentRelease callback )
throw ()

{

  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setInstanceRelease))(d_self, /* in */ cid._get_ior(),
    /* in */ callback._get_ior() );
  /*dispatch to ior*/
  /*unpack results and cleanup*/
}



/**
 * 	Creates an instance of a CCA component of the type defined by the 
 * 	string className.  The string classname uniquely defines the
 * 	"type" of the component, e.g.
 * 	    doe.cca.Library.GaussianElmination. 
 * 	It has an instance name given by the string instanceName.
 * 	The instanceName may be empty (zero length) in which case
 * 	the instanceName will be assigned to the component automatically.
 * 	@throws CCAException If the Component className is unknown, or if the
 * 		instanceName has already been used, a CCAException is thrown.
 * 	@return A ComponentID corresponding to the created component. Destroying
 * 		the returned ID does not destroy the component; 
 * 		see destroyInstance instead.
 */
::gov::cca::ComponentID
decaf::Framework::createInstance( /* in */ const ::std::string& instanceName,
  /* in */ const ::std::string& className,
  /* in */ ::gov::cca::TypeMap properties )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ComponentID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_createInstance))(d_self, /* in */ instanceName.c_str(),
    /* in */ className.c_str(), /* in */ properties._get_ior(), &_exception ),
    false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Get component list.
 *  @return a ComponentID for each component currently created.
 */
::sidl::array< ::gov::cca::ComponentID>
decaf::Framework::getComponentIDs(  )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::gov::cca::ComponentID> _result;
  struct gov_cca_ComponentID__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getComponentIDs))(d_self, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Get property map for component.
 *  @return the public properties associated with the component referred to by
 *  ComponentID. 
 *  @throws a CCAException if the ComponentID is invalid.
 */
::gov::cca::TypeMap
decaf::Framework::getComponentProperties( /* in */ ::gov::cca::ComponentID cid )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_getComponentProperties))(d_self,
    /* in */ cid._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * 	Causes the framework implementation to associate the given properties 
 * 	with the component designated by cid. 
 * 	@throws CCAException if cid is invalid or if there is an attempted
 * 	change to a property locked by the framework implementation.
 */
void
decaf::Framework::setComponentProperties( /* in */ ::gov::cca::ComponentID cid,
  /* in */ ::gov::cca::TypeMap map )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setComponentProperties))(d_self, /* in */ cid._get_ior(),
    /* in */ map._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Get component id from stringified reference.
 *    @return a ComponentID from the string produced by 
 * 	ComponentID.getSerialization(). 
 *    @throws CCAException if the string does not represent the appropriate 
 * 	 serialization of a ComponentID for the underlying framework.
 */
::gov::cca::ComponentID
decaf::Framework::getDeserialization( /* in */ const ::std::string& s )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ComponentID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_getDeserialization))(d_self, /* in */ s.c_str(),
    &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Get id from name by which it was created.
 *  @return a ComponentID from the instance name of the component
 *  produced by ComponentID.getInstanceName().
 *  @throws CCAException if there is no component matching the 
 *  given componentInstanceName.
 */
::gov::cca::ComponentID
decaf::Framework::getComponentID( /* in */ const ::std::string& 
  componentInstanceName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ComponentID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ComponentID( 
    (*(d_self->d_epv->f_getComponentID))(d_self,
    /* in */ componentInstanceName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Eliminate the Component instance, from the scope of the framework.
 *  @param toDie the component to be removed.
 *  @param timeout the allowable wait; 0 means up to the framework.
 *  @throws CCAException if toDie refers to an invalid component, or
 *  if the operation takes longer than timeout seconds.
 */
void
decaf::Framework::destroyInstance( /* in */ ::gov::cca::ComponentID toDie,
  /* in */ float timeout )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_destroyInstance))(d_self, /* in */ toDie._get_ior(),
    /* in */ timeout, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 *  Get the names of Port instances provided by the identified component.
 *  @param cid the component.
 *  @throws CCAException if cid refers to an invalid component.
 */
::sidl::array< ::std::string>
decaf::Framework::getProvidedPortNames( /* in */ ::gov::cca::ComponentID cid )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::std::string> _result;
  struct sidl_string__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getProvidedPortNames))(d_self,
    /* in */ cid._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Get the names of Port instances used by the identified component.
 *  @param cid the component.
 *  @throws CCAException if cid refers to an invalid component. 
 */
::sidl::array< ::std::string>
decaf::Framework::getUsedPortNames( /* in */ ::gov::cca::ComponentID cid )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::std::string> _result;
  struct sidl_string__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getUsedPortNames))(d_self,
    /* in */ cid._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Fetch map of Port properties exposed by the framework.
 *  @return the public properties pertaining to the Port instance 
 *    portname on the component referred to by cid. 
 *  @throws CCAException when any one of the following conditions occur:<ul>
 *    <li>portname is not a registered Port on the component indicated by cid,
 *    <li>cid refers to an invalid component. </ul>
 */
::gov::cca::TypeMap
decaf::Framework::getPortProperties( /* in */ ::gov::cca::ComponentID cid,
  /* in */ const ::std::string& portName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( (*(d_self->d_epv->f_getPortProperties))(d_self,
    /* in */ cid._get_ior(), /* in */ portName.c_str(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 *  Associates the properties given in map with the Port indicated by 
 *  portname. The component must have a Port known by portname.
 *  @throws CCAException if either cid or portname are
 * 	invalid, or if this a changed property is locked by 
 * 	 the underlying framework or component.
 */
void
decaf::Framework::setPortProperties( /* in */ ::gov::cca::ComponentID cid,
  /* in */ const ::std::string& portName, /* in */ ::gov::cca::TypeMap map )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setPortProperties))(d_self, /* in */ cid._get_ior(),
    /* in */ portName.c_str(), /* in */ map._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 *   Creates a connection between ports on component user and 
 *   component provider. Destroying the ConnectionID does not
 *   cause a disconnection; for that, see disconnect().
 *   @throws CCAException when any one of the following conditions occur:<ul>
 *   <li>If either user or provider refer to an invalid component,
 *   <li>If either usingPortName or providingPortName refer to a 
 * 	 nonexistent Port on their respective component,
 *   <li>If other-- In reality there are a lot of things that can go wrong 
 * 	 with this operation, especially if the underlying connections 
 * 	 involve networking.</ul>
 */
::gov::cca::ConnectionID
decaf::Framework::connect( /* in */ ::gov::cca::ComponentID user,
  /* in */ const ::std::string& usingPortName,
  /* in */ ::gov::cca::ComponentID provider,
  /* in */ const ::std::string& providingPortName )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::ConnectionID _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::ConnectionID( (*(d_self->d_epv->f_connect))(d_self,
    /* in */ user._get_ior(), /* in */ usingPortName.c_str(),
    /* in */ provider._get_ior(), /* in */ providingPortName.c_str(),
    &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Returns a list of connections as an array of 
 * 	handles. This will return all connections involving components 
 * 	in the given componentList of ComponentIDs. This
 * 	means that ConnectionID's will be returned even if only one 
 * 	of the participants in the connection appears in componentList.
 * 
 * 	@throws CCAException if any component in componentList is invalid.
 */
::sidl::array< ::gov::cca::ConnectionID>
decaf::Framework::getConnectionIDs( /* in */ ::sidl::array< 
  ::gov::cca::ComponentID> componentList )
throw ( ::gov::cca::CCAException)

{
  ::sidl::array< ::gov::cca::ConnectionID> _result;
  struct gov_cca_ConnectionID__array* _local_result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _local_result = (*(d_self->d_epv->f_getConnectionIDs))(d_self,
    /* in */ componentList._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  _result._set_ior(_local_result);
  /*unpack results and cleanup*/
  return _result;
}



/**
 *   Fetch property map of a connection.
 *   @returns the properties for the given connection.
 *   @throws CCAException if connID is invalid.
 */
::gov::cca::TypeMap
decaf::Framework::getConnectionProperties( /* in */ ::gov::cca::ConnectionID 
  connID )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( 
    (*(d_self->d_epv->f_getConnectionProperties))(d_self,
    /* in */ connID._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Associates the properties with the connection.
 *   @param map the source of the properties.
 *   @param connID connection to receive property values.
 *   @throws CCAException if connID is invalid, or if this changes 
 * 	 a property locked by the underlying framework.
 */
void
decaf::Framework::setConnectionProperties( /* in */ ::gov::cca::ConnectionID 
  connID, /* in */ ::gov::cca::TypeMap map )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_setConnectionProperties))(d_self,
    /* in */ connID._get_ior(), /* in */ map._get_ior(), &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Disconnect the connection indicated by connID before the indicated
 *     timeout in secs. Upon successful completion, connID and the connection
 *     it represents become invalid. 
 *     @param timeout the time in seconds to wait for a connection to close; 0
 *     means to use the framework implementation default.
 *     @throws CCAException when any one of the following conditions occur: <ul>
 *     <li>id refers to an invalid ConnectionID,
 *     <li>timeout is exceeded, after which, if id was valid before 
 * disconnect() was invoked, it remains valid
 * </ul>
 * 
 */
void
decaf::Framework::disconnect( /* in */ ::gov::cca::ConnectionID connID,
  /* in */ float timeout )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_disconnect))(d_self, /* in */ connID._get_ior(),
    /* in */ timeout, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Remove all connections between components id1 and id2 within 
 *   the period of timeout secs. If id2 is null, then all connections 
 *   to id1 are removed (within the period of timeout secs).
 *   @throws CCAException when any one of the following conditions occur:<ul>
 * 	  <li>id1 or id2 refer to an invalid ComponentID (other than id2 == null),
 * 	  <li>The timeout period is exceeded before the disconnections can be made. 
 * 	  </ul>
 */
void
decaf::Framework::disconnectAll( /* in */ ::gov::cca::ComponentID id1,
  /* in */ ::gov::cca::ComponentID id2, /* in */ float timeout )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_disconnectAll))(d_self, /* in */ id1._get_ior(),
    /* in */ id2._get_ior(), /* in */ timeout, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 *  Create an empty TypeMap. Presumably this would be used in 
 *  an ensuing call to <code>getServices()</code>. The "normal" method of
 *  creating typemaps is found in the <code>Services</code> interface. It
 *  is duplicated here to break the "chicken and egg" problem.
 */
::gov::cca::TypeMap
decaf::Framework::createTypeMap(  )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::TypeMap _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::TypeMap( (*(d_self->d_epv->f_createTypeMap))(d_self,
    &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Retrieve a Services handle to the underlying framework. 
 * This interface effectively causes the calling program to 
 * appear as the image of a component inside the framework.
 * This method may be called any number of times
 * with different arguments, creating a new component image 
 * each time. 
 * The only proper method to destroy a Services obtained 
 * from this interface is to pass it to releaseServices.
 * 
 * @param selfInstanceName the Component instance name,
 * as it will appear in the framework.
 * 
 * @param selfClassName the Component type of the 
 * calling program, as it will appear in the framework. 
 * 
 * @param selfProperties (which can be null) the properties 
 * of the component image to appear. 
 * 
 * @throws CCAException in the event that selfInstanceName 
 * is already in use by another component.
 * 
 * @return  A Services object that pertains to the
 * 	    image of the this component. This is identical
 * 	    to the object passed into Component.setServices() 
 * 	    when a component is created.
 */
::gov::cca::Services
decaf::Framework::getServices( /* in */ const ::std::string& selfInstanceName,
  /* in */ const ::std::string& selfClassName,
  /* in */ ::gov::cca::TypeMap selfProperties )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::Services _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::Services( (*(d_self->d_epv->f_getServices))(d_self,
    /* in */ selfInstanceName.c_str(), /* in */ selfClassName.c_str(),
    /* in */ selfProperties._get_ior(), &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



/**
 * Inform framework that the <code>Services</code> handle is no longer needed by the 
 * caller and that the reference to its component image is to be
 * deleted from the context of the underlying framework. This invalidates
 * any <code>ComponentID</code>'s or <code>ConnectionID</code>'s associated 
 * with the given <code>Services</code>' component image. 
 * 
 * @param svc The result of getServices earlier obtained.
 * 
 * @throws CCAException if the <code>Services</code>
 *         handle has already been released or is otherwise rendered invalid 
 *         or was not obtained from <code>getServices()</code>.
 */
void
decaf::Framework::releaseServices( /* in */ ::gov::cca::Services svc )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_releaseServices))(d_self, /* in */ svc._get_ior(),
    &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Tell the framework it is no longer needed and to clean up after itself. 
 *  @throws CCAException if the framework has already been shutdown.
 */
void
decaf::Framework::shutdownFramework(  )
throw ( ::gov::cca::CCAException)

{

  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  (*(d_self->d_epv->f_shutdownFramework))(d_self, &_exception );
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
}



/**
 * Creates a new framework instance based on the same underlying 
 * framework implementation. This does not copy the existing 
 * framework, nor are any of the user-instantiated components in
 * the original framework available in the newly created 
 * <code>AbstractFramework</code>. 
 * 
 * @throws CCAException when one of the following conditions occur:
 * 
 * (1)the AbstractFramework previously had shutdownFramework() called on it, or 
 * (2)the underlying framework implementation does not permit creation 
 * of another instance.	 
 */
::gov::cca::AbstractFramework
decaf::Framework::createEmptyFramework(  )
throw ( ::gov::cca::CCAException)

{
  ::gov::cca::AbstractFramework _result;
  sidl_BaseInterface__object * _exception = 0;
  /*pack args to dispatch to ior*/
  _result = ::gov::cca::AbstractFramework( 
    (*(d_self->d_epv->f_createEmptyFramework))(d_self, &_exception ), false);
  /*dispatch to ior*/
  if (_exception != 0 ) {
    void * _p = 0;
    if ( (_p=(*(_exception->d_epv->f__cast))(_exception,
      "gov.cca.CCAException")) != 0 ) {
      struct gov_cca_CCAException__object * _realtype = reinterpret_cast< 
        struct gov_cca_CCAException__object*>(_p);
      // Note: alternate constructor does not increment refcount.
      throw ::gov::cca::CCAException( _realtype, false );
    }
  }
  /*unpack results and cleanup*/
  return _result;
}



//////////////////////////////////////////////////
// 
// End User Defined Methods
// (everything else in this file is specific to
//  Babel's C++ bindings)
// 

// static constructor
::decaf::Framework
decaf::Framework::_create() {
  ::decaf::Framework self( (*_get_ext()->createObject)(), false );
  return self;
}

// default destructor
decaf::Framework::~Framework () {
  if ( d_self != 0 ) {
    deleteRef();
  }
}

// copy constructor
decaf::Framework::Framework ( const ::decaf::Framework& original ) {
  d_self = const_cast< ior_t*>(original.d_self);
  d_weak_reference = original.d_weak_reference;
  if (d_self != 0 ) {
    addRef();
  }
}

// assignment operator
::decaf::Framework&
decaf::Framework::operator=( const ::decaf::Framework& rhs ) {
  if ( d_self != rhs.d_self ) {
    if ( d_self != 0 ) {
      deleteRef();
    }
    d_self = const_cast< ior_t*>(rhs.d_self);
    d_weak_reference = rhs.d_weak_reference;
    if ( d_self != 0 ) {
      addRef();
    }
  }
  return *this;
}

// conversion from ior to C++ class
decaf::Framework::Framework ( ::decaf::Framework::ior_t* ior ) 
    : d_self( ior ), d_weak_reference(false) {
  if ( d_self != 0 ) {
    addRef();
  }
}

// Alternate constructor: does not call addRef()
// (sets d_weak_reference=isWeak)
// For internal use by Impls (fixes bug#275)
decaf::Framework::Framework ( ::decaf::Framework::ior_t* ior, bool isWeak ) 
    : d_self( ior ), d_weak_reference(isWeak) { 
}

// conversion from a StubBase
decaf::Framework::Framework ( const ::sidl::StubBase& base )
{
  d_self = reinterpret_cast< ior_t*>(base._cast("decaf.Framework"));
  d_weak_reference = false;
  if (d_self != 0) {
    addRef();
  }
}

// protected method that implements casting
void* decaf::Framework::_cast(const char* type) const
{
  void* ptr = 0;
  if ( d_self != 0 ) {
    ptr = reinterpret_cast< void*>((*d_self->d_epv->f__cast)(d_self, type));
  }
  return ptr;
}

// Static data type
const ::decaf::Framework::ext_t * decaf::Framework::s_ext = 0;

// private static method to get static data type
const ::decaf::Framework::ext_t *
decaf::Framework::_get_ext()
  throw (::sidl::NullIORException)
{
  if (! s_ext ) {
#ifdef SIDL_STATIC_LIBRARY
    s_ext = decaf_Framework__externals();
#else
    ::sidl::DLL dll = ::sidl::DLL::_create();
    const ext_t *(*dll_f)(void);
    // check global namespace for symbol first
    if (dll._not_nil() && dll.loadLibrary("main:", TRUE, FALSE)) {
      dll_f =
        (const ext_t *(*)(void)) dll.lookupSymbol(
          "decaf_Framework__externals");
      s_ext = (dll_f ? (*dll_f)() : NULL);
    }
    if (!s_ext) {
      dll = ::sidl::Loader::findLibrary("decaf.Framework",
        "ior/impl", ::sidl::Scope_SCLSCOPE,
        ::sidl::Resolve_SCLRESOLVE);
      if (dll._not_nil()) {
        dll_f =
          (const ext_t *(*)(void)) dll.lookupSymbol(
            "decaf_Framework__externals");
        s_ext = (dll_f ? (*dll_f)() : NULL);
      }
    }
    if (!s_ext) {
      throw ::sidl::NullIORException( ::std::string (
        "cannot find implementation for decaf.Framework; please set SIDL_DLL_PATH"
      ));
    }
#endif
  }
  return s_ext;
}

extern "C" {

#include <stdlib.h>
#include <string.h>
#ifndef included_sidl_BaseClass_h
#include "sidl_BaseClass.h"
#endif
#ifndef included_sidl_ClassInfo_h
#include "sidl_ClassInfo.h"
#endif
#include "sidl_rmi_ProtocolFactory.h"
#include "sidl_rmi_InstanceHandle.h"
#include "sidl_rmi_Invocation.h"
#include "sidl_rmi_Response.h"

#ifndef NULL
#define NULL 0
#endif

#include "sidl_thread.h"
#ifdef HAVE_PTHREAD
static struct sidl_recursive_mutex_t decaf_Framework__mutex= SIDL_RECURSIVE_MUTEX_INITIALIZER;
#define LOCK_STATIC_GLOBALS sidl_recursive_mutex_lock( &decaf_Framework__mutex )
#define UNLOCK_STATIC_GLOBALS sidl_recursive_mutex_unlock( &decaf_Framework__mutex )
/* #define HAVE_LOCKED_STATIC_GLOBALS (sidl_recursive_mutex_trylock( &decaf_Framework__mutex )==EDEADLOCK) */
#else
#define LOCK_STATIC_GLOBALS
#define UNLOCK_STATIC_GLOBALS
/* #define HAVE_LOCKED_STATIC_GLOBALS (1) */
#endif

  // Static variables to hold version of IOR
  static const int32_t s_IOR_MAJOR_VERSION = 0;
  static const int32_t s_IOR_MINOR_VERSION = 9;

  // Static variables for managing EPV initialization.
  static int s_remote_initialized = 0;

  static struct decaf_Framework__epv s_rem_epv__decaf_framework;

  static struct gov_cca_AbstractFramework__epv 
    s_rem_epv__gov_cca_abstractframework;

  static struct gov_cca_Port__epv s_rem_epv__gov_cca_port;

  static struct gov_cca_ports_BuilderService__epv 
    s_rem_epv__gov_cca_ports_builderservice;

  static struct sidl_BaseClass__epv  s_rem_epv__sidl_baseclass;

  static struct sidl_BaseInterface__epv  s_rem_epv__sidl_baseinterface;

  // REMOTE CAST: dynamic type casting for remote objects.
  static void* remote_decaf_Framework__cast(
    struct decaf_Framework__object* self,
    const char* name)
  {
    return NULL;
  }

  // REMOTE DELETE: call the remote destructor for the object.
  static void remote_decaf_Framework__delete(
    struct decaf_Framework__object* self)
  {
    free((void*) self);
  }

  // REMOTE EXEC: call the exec function for the object.
  static void remote_decaf_Framework__exec(
    struct decaf_Framework__object* self,
    const char* methodName,
    sidl_io_Deserializer inArgs,
    sidl_io_Serializer outArgs)
  {
  }

  // REMOTE METHOD STUB:addRef
  static void
  remote_decaf_Framework_addRef(
    /* in */ struct decaf_Framework__object* self /* TLD */)
  {
    // FIXME  need to think through all of these special cases
  }

  // REMOTE METHOD STUB:deleteRef
  static void
  remote_decaf_Framework_deleteRef(
    /* in */ struct decaf_Framework__object* self /* TLD */)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "deleteRef", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:isSame
  static sidl_bool
  remote_decaf_Framework_isSame(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct sidl_BaseInterface__object* iobj)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // FIXME  need to think through all of these special cases
    return 0;
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    self->d_data = NULL;
    sidl_rmi_InstanceHandle_close(conn, _ex2);
    sidl_rmi_InstanceHandle_deleteRef(conn);
  }

  // REMOTE METHOD STUB:queryInt
  static struct sidl_BaseInterface__object*
  remote_decaf_Framework_queryInt(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ const char* name)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // FIXME  need to think through all of these special cases
    return 0;
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    self->d_data = NULL;
    sidl_rmi_InstanceHandle_close(conn, _ex2);
    sidl_rmi_InstanceHandle_deleteRef(conn);
  }

  // REMOTE METHOD STUB:isType
  static sidl_bool
  remote_decaf_Framework_isType(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ const char* name)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // FIXME  need to think through all of these special cases
    return 0;
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    self->d_data = NULL;
    sidl_rmi_InstanceHandle_close(conn, _ex2);
    sidl_rmi_InstanceHandle_deleteRef(conn);
  }

  // REMOTE METHOD STUB:getClassInfo
  static struct sidl_ClassInfo__object*
  remote_decaf_Framework_getClassInfo(
    /* in */ struct decaf_Framework__object* self /* TLD */)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // FIXME  need to think through all of these special cases
    return 0;
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    self->d_data = NULL;
    sidl_rmi_InstanceHandle_close(conn, _ex2);
    sidl_rmi_InstanceHandle_deleteRef(conn);
  }

  // REMOTE METHOD STUB:lookupPort
  static struct gov_cca_Port__object*
  remote_decaf_Framework_lookupPort(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* componentID,
    /* in */ const char* portName)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "lookupPort", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_Port__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "portName", portName, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:provideRequestedServices
  static void
  remote_decaf_Framework_provideRequestedServices(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* componentID,
    /* in */ const char* portName,
    /* in */ const char* type)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "provideRequestedServices", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "portName", portName, _ex2);
    sidl_rmi_Invocation_packString( inv, "type", type, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:setInstanceRelease
  static void
  remote_decaf_Framework_setInstanceRelease(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* in */ struct gov_cca_ComponentRelease__object* callback)
  {
    sidl_BaseInterface _ex = NULL;
    sidl_BaseInterface *_ex2 =&_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "setInstanceRelease", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:createInstance
  static struct gov_cca_ComponentID__object*
  remote_decaf_Framework_createInstance(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ const char* instanceName,
    /* in */ const char* className,
    /* in */ struct gov_cca_TypeMap__object* properties,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "createInstance", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_ComponentID__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "instanceName", instanceName, _ex2);
    sidl_rmi_Invocation_packString( inv, "className", className, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getComponentIDs
  static struct gov_cca_ComponentID__array*
  remote_decaf_Framework_getComponentIDs(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getComponentIDs", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_ComponentID__array* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getComponentProperties
  static struct gov_cca_TypeMap__object*
  remote_decaf_Framework_getComponentProperties(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getComponentProperties", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_TypeMap__object* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:setComponentProperties
  static void
  remote_decaf_Framework_setComponentProperties(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* in */ struct gov_cca_TypeMap__object* map,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "setComponentProperties", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:getDeserialization
  static struct gov_cca_ComponentID__object*
  remote_decaf_Framework_getDeserialization(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ const char* s,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getDeserialization", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_ComponentID__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "s", s, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getComponentID
  static struct gov_cca_ComponentID__object*
  remote_decaf_Framework_getComponentID(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ const char* componentInstanceName,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getComponentID", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_ComponentID__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "componentInstanceName",
      componentInstanceName, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:destroyInstance
  static void
  remote_decaf_Framework_destroyInstance(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* toDie,
    /* in */ float timeout,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "destroyInstance", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packFloat( inv, "timeout", timeout, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:getProvidedPortNames
  static struct sidl_string__array*
  remote_decaf_Framework_getProvidedPortNames(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getProvidedPortNames", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct sidl_string__array* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getUsedPortNames
  static struct sidl_string__array*
  remote_decaf_Framework_getUsedPortNames(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getUsedPortNames", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct sidl_string__array* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getPortProperties
  static struct gov_cca_TypeMap__object*
  remote_decaf_Framework_getPortProperties(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* in */ const char* portName,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getPortProperties", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_TypeMap__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "portName", portName, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:setPortProperties
  static void
  remote_decaf_Framework_setPortProperties(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* cid,
    /* in */ const char* portName,
    /* in */ struct gov_cca_TypeMap__object* map,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "setPortProperties", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "portName", portName, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:connect
  static struct gov_cca_ConnectionID__object*
  remote_decaf_Framework_connect(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* user,
    /* in */ const char* usingPortName,
    /* in */ struct gov_cca_ComponentID__object* provider,
    /* in */ const char* providingPortName,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "connect", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_ConnectionID__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "usingPortName", usingPortName, _ex2);
    sidl_rmi_Invocation_packString( inv, "providingPortName", providingPortName,
      _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getConnectionIDs
  static struct gov_cca_ConnectionID__array*
  remote_decaf_Framework_getConnectionIDs(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__array* componentList,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getConnectionIDs", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_ConnectionID__array* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getConnectionProperties
  static struct gov_cca_TypeMap__object*
  remote_decaf_Framework_getConnectionProperties(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ConnectionID__object* connID,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getConnectionProperties", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_TypeMap__object* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:setConnectionProperties
  static void
  remote_decaf_Framework_setConnectionProperties(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ConnectionID__object* connID,
    /* in */ struct gov_cca_TypeMap__object* map,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "setConnectionProperties", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:disconnect
  static void
  remote_decaf_Framework_disconnect(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ConnectionID__object* connID,
    /* in */ float timeout,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "disconnect", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packFloat( inv, "timeout", timeout, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:disconnectAll
  static void
  remote_decaf_Framework_disconnectAll(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_ComponentID__object* id1,
    /* in */ struct gov_cca_ComponentID__object* id2,
    /* in */ float timeout,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "disconnectAll", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packFloat( inv, "timeout", timeout, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:createTypeMap
  static struct gov_cca_TypeMap__object*
  remote_decaf_Framework_createTypeMap(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "createTypeMap", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_TypeMap__object* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:getServices
  static struct gov_cca_Services__object*
  remote_decaf_Framework_getServices(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ const char* selfInstanceName,
    /* in */ const char* selfClassName,
    /* in */ struct gov_cca_TypeMap__object* selfProperties,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "getServices", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_Services__object* _retval = NULL;

    // pack in and inout arguments
    sidl_rmi_Invocation_packString( inv, "selfInstanceName", selfInstanceName,
      _ex2);
    sidl_rmi_Invocation_packString( inv, "selfClassName", selfClassName, _ex2);

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE METHOD STUB:releaseServices
  static void
  remote_decaf_Framework_releaseServices(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* in */ struct gov_cca_Services__object* svc,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "releaseServices", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:shutdownFramework
  static void
  remote_decaf_Framework_shutdownFramework(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "shutdownFramework", _ex2 );
    sidl_rmi_Response rsvp = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
  }

  // REMOTE METHOD STUB:createEmptyFramework
  static struct gov_cca_AbstractFramework__object*
  remote_decaf_Framework_createEmptyFramework(
    /* in */ struct decaf_Framework__object* self /* TLD */,
    /* out */ struct sidl_BaseInterface__object* *_ex)
  {
    sidl_BaseInterface *_ex2 =_ex;
    // initialize a new invocation
    sidl_rmi_InstanceHandle conn = (sidl_rmi_InstanceHandle)self->d_data;
    sidl_rmi_Invocation inv = sidl_rmi_InstanceHandle_createInvocation( conn,
      "createEmptyFramework", _ex2 );
    sidl_rmi_Response rsvp = NULL;
    // TODO: Fix returning objects and arrays
    struct gov_cca_AbstractFramework__object* _retval = NULL;

    // pack in and inout arguments

    // send actual RMI request
    rsvp = sidl_rmi_Invocation_invokeMethod(inv,_ex2);

    // check if exception thrown.
    // FIXME

    // extract return value

    // unpack out and inout arguments

    // cleanup and return
    sidl_rmi_Response_done(rsvp, _ex2);
    sidl_rmi_Invocation_deleteRef(inv);
    sidl_rmi_Response_deleteRef(rsvp);
    return _retval;
  }

  // REMOTE EPV: create remote entry point vectors (EPVs).
  static void decaf_Framework__init_remote_epv(void)
  {
    // assert( HAVE_LOCKED_STATIC_GLOBALS );
    struct decaf_Framework__epv*              epv = &s_rem_epv__decaf_framework;
    struct gov_cca_AbstractFramework__epv*    e0  = 
      &s_rem_epv__gov_cca_abstractframework;
    struct gov_cca_Port__epv*                 e1  = &s_rem_epv__gov_cca_port;
    struct gov_cca_ports_BuilderService__epv* e2  = 
      &s_rem_epv__gov_cca_ports_builderservice;
    struct sidl_BaseClass__epv*               e3  = &s_rem_epv__sidl_baseclass;
    struct sidl_BaseInterface__epv*           e4  = 
      &s_rem_epv__sidl_baseinterface;

    epv->f__cast                         = remote_decaf_Framework__cast;
    epv->f__delete                       = remote_decaf_Framework__delete;
    epv->f__exec                         = remote_decaf_Framework__exec;
    epv->f__ctor                         = NULL;
    epv->f__dtor                         = NULL;
    epv->f_addRef                        = remote_decaf_Framework_addRef;
    epv->f_deleteRef                     = remote_decaf_Framework_deleteRef;
    epv->f_isSame                        = remote_decaf_Framework_isSame;
    epv->f_queryInt                      = remote_decaf_Framework_queryInt;
    epv->f_isType                        = remote_decaf_Framework_isType;
    epv->f_getClassInfo                  = remote_decaf_Framework_getClassInfo;
    epv->f_lookupPort                    = remote_decaf_Framework_lookupPort;
    epv->f_provideRequestedServices      = 
      remote_decaf_Framework_provideRequestedServices;
    epv->f_setInstanceRelease            = 
      remote_decaf_Framework_setInstanceRelease;
    epv->f_createInstance                = 
      remote_decaf_Framework_createInstance;
    epv->f_getComponentIDs               = 
      remote_decaf_Framework_getComponentIDs;
    epv->f_getComponentProperties        = 
      remote_decaf_Framework_getComponentProperties;
    epv->f_setComponentProperties        = 
      remote_decaf_Framework_setComponentProperties;
    epv->f_getDeserialization            = 
      remote_decaf_Framework_getDeserialization;
    epv->f_getComponentID                = 
      remote_decaf_Framework_getComponentID;
    epv->f_destroyInstance               = 
      remote_decaf_Framework_destroyInstance;
    epv->f_getProvidedPortNames          = 
      remote_decaf_Framework_getProvidedPortNames;
    epv->f_getUsedPortNames              = 
      remote_decaf_Framework_getUsedPortNames;
    epv->f_getPortProperties             = 
      remote_decaf_Framework_getPortProperties;
    epv->f_setPortProperties             = 
      remote_decaf_Framework_setPortProperties;
    epv->f_connect                       = remote_decaf_Framework_connect;
    epv->f_getConnectionIDs              = 
      remote_decaf_Framework_getConnectionIDs;
    epv->f_getConnectionProperties       = 
      remote_decaf_Framework_getConnectionProperties;
    epv->f_setConnectionProperties       = 
      remote_decaf_Framework_setConnectionProperties;
    epv->f_disconnect                    = remote_decaf_Framework_disconnect;
    epv->f_disconnectAll                 = remote_decaf_Framework_disconnectAll;
    epv->f_createTypeMap                 = remote_decaf_Framework_createTypeMap;
    epv->f_getServices                   = remote_decaf_Framework_getServices;
    epv->f_releaseServices               = 
      remote_decaf_Framework_releaseServices;
    epv->f_shutdownFramework             = 
      remote_decaf_Framework_shutdownFramework;
    epv->f_createEmptyFramework          = 
      remote_decaf_Framework_createEmptyFramework;

    e0->f__cast                = (void* (*)(void*,const char*)) epv->f__cast;
    e0->f__delete              = (void (*)(void*)) epv->f__delete;
    e0->f__exec                = (void (*)(void*,const char*,
      struct sidl_io_Deserializer__object*,
      struct sidl_io_Serializer__object*)) epv->f__exec;
    e0->f_addRef               = (void (*)(void*)) epv->f_addRef;
    e0->f_deleteRef            = (void (*)(void*)) epv->f_deleteRef;
    e0->f_isSame               = (sidl_bool (*)(void*,
      struct sidl_BaseInterface__object*)) epv->f_isSame;
    e0->f_queryInt             = (struct sidl_BaseInterface__object* (*)(void*,
      const char*)) epv->f_queryInt;
    e0->f_isType               = (sidl_bool (*)(void*,
      const char*)) epv->f_isType;
    e0->f_getClassInfo         = (struct sidl_ClassInfo__object* (*)(void*)) 
      epv->f_getClassInfo;
    e0->f_createTypeMap        = (struct gov_cca_TypeMap__object* (*)(void*,
      struct sidl_BaseInterface__object **)) epv->f_createTypeMap;
    e0->f_getServices          = (struct gov_cca_Services__object* (*)(void*,
      const char*,const char*,struct gov_cca_TypeMap__object*,
      struct sidl_BaseInterface__object **)) epv->f_getServices;
    e0->f_releaseServices      = (void (*)(void*,
      struct gov_cca_Services__object*,
      struct sidl_BaseInterface__object **)) epv->f_releaseServices;
    e0->f_shutdownFramework    = (void (*)(void*,
      struct sidl_BaseInterface__object **)) epv->f_shutdownFramework;
    e0->f_createEmptyFramework = (struct gov_cca_AbstractFramework__object* 
      (*)(void*,
      struct sidl_BaseInterface__object **)) epv->f_createEmptyFramework;

    e1->f__cast        = (void* (*)(void*,const char*)) epv->f__cast;
    e1->f__delete      = (void (*)(void*)) epv->f__delete;
    e1->f__exec        = (void (*)(void*,const char*,
      struct sidl_io_Deserializer__object*,
      struct sidl_io_Serializer__object*)) epv->f__exec;
    e1->f_addRef       = (void (*)(void*)) epv->f_addRef;
    e1->f_deleteRef    = (void (*)(void*)) epv->f_deleteRef;
    e1->f_isSame       = (sidl_bool (*)(void*,
      struct sidl_BaseInterface__object*)) epv->f_isSame;
    e1->f_queryInt     = (struct sidl_BaseInterface__object* (*)(void*,
      const char*)) epv->f_queryInt;
    e1->f_isType       = (sidl_bool (*)(void*,const char*)) epv->f_isType;
    e1->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*)) 
      epv->f_getClassInfo;

    e2->f__cast                   = (void* (*)(void*,const char*)) epv->f__cast;
    e2->f__delete                 = (void (*)(void*)) epv->f__delete;
    e2->f__exec                   = (void (*)(void*,const char*,
      struct sidl_io_Deserializer__object*,
      struct sidl_io_Serializer__object*)) epv->f__exec;
    e2->f_addRef                  = (void (*)(void*)) epv->f_addRef;
    e2->f_deleteRef               = (void (*)(void*)) epv->f_deleteRef;
    e2->f_isSame                  = (sidl_bool (*)(void*,
      struct sidl_BaseInterface__object*)) epv->f_isSame;
    e2->f_queryInt                = (struct sidl_BaseInterface__object* 
      (*)(void*,const char*)) epv->f_queryInt;
    e2->f_isType                  = (sidl_bool (*)(void*,
      const char*)) epv->f_isType;
    e2->f_getClassInfo            = (struct sidl_ClassInfo__object* (*)(void*)) 
      epv->f_getClassInfo;
    e2->f_createInstance          = (struct gov_cca_ComponentID__object* 
      (*)(void*,const char*,const char*,struct gov_cca_TypeMap__object*,
      struct sidl_BaseInterface__object **)) epv->f_createInstance;
    e2->f_getComponentIDs         = (struct gov_cca_ComponentID__array* 
      (*)(void*,struct sidl_BaseInterface__object **)) epv->f_getComponentIDs;
    e2->f_getComponentProperties  = (struct gov_cca_TypeMap__object* (*)(void*,
      struct gov_cca_ComponentID__object*,
      struct sidl_BaseInterface__object **)) epv->f_getComponentProperties;
    e2->f_setComponentProperties  = (void (*)(void*,
      struct gov_cca_ComponentID__object*,struct gov_cca_TypeMap__object*,
      struct sidl_BaseInterface__object **)) epv->f_setComponentProperties;
    e2->f_getDeserialization      = (struct gov_cca_ComponentID__object* 
      (*)(void*,const char*,
      struct sidl_BaseInterface__object **)) epv->f_getDeserialization;
    e2->f_getComponentID          = (struct gov_cca_ComponentID__object* 
      (*)(void*,const char*,
      struct sidl_BaseInterface__object **)) epv->f_getComponentID;
    e2->f_destroyInstance         = (void (*)(void*,
      struct gov_cca_ComponentID__object*,float,
      struct sidl_BaseInterface__object **)) epv->f_destroyInstance;
    e2->f_getProvidedPortNames    = (struct sidl_string__array* (*)(void*,
      struct gov_cca_ComponentID__object*,
      struct sidl_BaseInterface__object **)) epv->f_getProvidedPortNames;
    e2->f_getUsedPortNames        = (struct sidl_string__array* (*)(void*,
      struct gov_cca_ComponentID__object*,
      struct sidl_BaseInterface__object **)) epv->f_getUsedPortNames;
    e2->f_getPortProperties       = (struct gov_cca_TypeMap__object* (*)(void*,
      struct gov_cca_ComponentID__object*,const char*,
      struct sidl_BaseInterface__object **)) epv->f_getPortProperties;
    e2->f_setPortProperties       = (void (*)(void*,
      struct gov_cca_ComponentID__object*,const char*,
      struct gov_cca_TypeMap__object*,
      struct sidl_BaseInterface__object **)) epv->f_setPortProperties;
    e2->f_connect                 = (struct gov_cca_ConnectionID__object* 
      (*)(void*,struct gov_cca_ComponentID__object*,const char*,
      struct gov_cca_ComponentID__object*,const char*,
      struct sidl_BaseInterface__object **)) epv->f_connect;
    e2->f_getConnectionIDs        = (struct gov_cca_ConnectionID__array* 
      (*)(void*,struct gov_cca_ComponentID__array*,
      struct sidl_BaseInterface__object **)) epv->f_getConnectionIDs;
    e2->f_getConnectionProperties = (struct gov_cca_TypeMap__object* (*)(void*,
      struct gov_cca_ConnectionID__object*,
      struct sidl_BaseInterface__object **)) epv->f_getConnectionProperties;
    e2->f_setConnectionProperties = (void (*)(void*,
      struct gov_cca_ConnectionID__object*,struct gov_cca_TypeMap__object*,
      struct sidl_BaseInterface__object **)) epv->f_setConnectionProperties;
    e2->f_disconnect              = (void (*)(void*,
      struct gov_cca_ConnectionID__object*,float,
      struct sidl_BaseInterface__object **)) epv->f_disconnect;
    e2->f_disconnectAll           = (void (*)(void*,
      struct gov_cca_ComponentID__object*,struct gov_cca_ComponentID__object*,
      float,struct sidl_BaseInterface__object **)) epv->f_disconnectAll;

    e3->f__cast        = (void* (*)(struct sidl_BaseClass__object*,
      const char*)) epv->f__cast;
    e3->f__delete      = (void (*)(struct sidl_BaseClass__object*)) 
      epv->f__delete;
    e3->f__exec        = (void (*)(struct sidl_BaseClass__object*,const char*,
      struct sidl_io_Deserializer__object*,
      struct sidl_io_Serializer__object*)) epv->f__exec;
    e3->f_addRef       = (void (*)(struct sidl_BaseClass__object*)) 
      epv->f_addRef;
    e3->f_deleteRef    = (void (*)(struct sidl_BaseClass__object*)) 
      epv->f_deleteRef;
    e3->f_isSame       = (sidl_bool (*)(struct sidl_BaseClass__object*,
      struct sidl_BaseInterface__object*)) epv->f_isSame;
    e3->f_queryInt     = (struct sidl_BaseInterface__object* (*)(struct 
      sidl_BaseClass__object*,const char*)) epv->f_queryInt;
    e3->f_isType       = (sidl_bool (*)(struct sidl_BaseClass__object*,
      const char*)) epv->f_isType;
    e3->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(struct 
      sidl_BaseClass__object*)) epv->f_getClassInfo;

    e4->f__cast        = (void* (*)(void*,const char*)) epv->f__cast;
    e4->f__delete      = (void (*)(void*)) epv->f__delete;
    e4->f__exec        = (void (*)(void*,const char*,
      struct sidl_io_Deserializer__object*,
      struct sidl_io_Serializer__object*)) epv->f__exec;
    e4->f_addRef       = (void (*)(void*)) epv->f_addRef;
    e4->f_deleteRef    = (void (*)(void*)) epv->f_deleteRef;
    e4->f_isSame       = (sidl_bool (*)(void*,
      struct sidl_BaseInterface__object*)) epv->f_isSame;
    e4->f_queryInt     = (struct sidl_BaseInterface__object* (*)(void*,
      const char*)) epv->f_queryInt;
    e4->f_isType       = (sidl_bool (*)(void*,const char*)) epv->f_isType;
    e4->f_getClassInfo = (struct sidl_ClassInfo__object* (*)(void*)) 
      epv->f_getClassInfo;

    s_remote_initialized = 1;
  }

  // REMOTE: generate remote instance given URL string.
  static struct decaf_Framework__object*
  decaf_Framework__remote(const char *url, sidl_BaseInterface *_ex)
  {
    sidl_rmi_InstanceHandle instance = 
      sidl_rmi_ProtocolFactory_createInstance(url, "decaf.Framework", _ex );
    if ( instance == NULL) { return NULL; }
    struct decaf_Framework__object* self =
      (struct decaf_Framework__object*) malloc(
        sizeof(struct decaf_Framework__object));

    struct decaf_Framework__object* s0 = self;
    struct sidl_BaseClass__object*  s1 = &s0->d_sidl_baseclass;

    LOCK_STATIC_GLOBALS;
    if (!s_remote_initialized) {
      decaf_Framework__init_remote_epv();
    }
    UNLOCK_STATIC_GLOBALS;

    s1->d_sidl_baseinterface.d_epv    = &s_rem_epv__sidl_baseinterface;
    s1->d_sidl_baseinterface.d_object = (void*) instance;

    s1->d_data = (void*) instance;
    s1->d_epv  = &s_rem_epv__sidl_baseclass;

    s0->d_gov_cca_abstractframework.d_epv    = 
      &s_rem_epv__gov_cca_abstractframework;
    s0->d_gov_cca_abstractframework.d_object = (void*) instance;

    s0->d_gov_cca_port.d_epv    = &s_rem_epv__gov_cca_port;
    s0->d_gov_cca_port.d_object = (void*) instance;

    s0->d_gov_cca_ports_builderservice.d_epv    = 
      &s_rem_epv__gov_cca_ports_builderservice;
    s0->d_gov_cca_ports_builderservice.d_object = (void*) instance;

    s0->d_data = (void*) instance;
    s0->d_epv  = &s_rem_epv__decaf_framework;

    self->d_data = (void*) instance;

    return self;
  }

} // end extern "C"
