c
c     File:       argstest.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Revision:   @(#) $Revision: 4434 $
c     Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
c     Description:Exercise the FORTRAN interface
c
c
      subroutine starttest(number)
      implicit none
      integer*4 number
      integer*8 tracker
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_startPart_f(tracker, number)
      call synch_RegOut_deleteRef_f(tracker)
      end

      subroutine reporttest(test, number,  python)
      implicit none
      integer*4 number
      integer*8 tracker
      logical test, python
      call synch_RegOut_getInstance_f(tracker)
      if (test) then
         call synch_RegOut_endPart_f(tracker, number, 0)
      else
         if (python) then
            call synch_RegOut_endPart_f(tracker, number, 2)
         else
            call synch_RegOut_endPart_f(tracker, number, 1)
         endif
      endif
      call synch_RegOut_deleteRef_f(tracker)
      number = number + 1
      end

      subroutine testbool(test)
      implicit none
      integer*8 obj
      integer*4 test
      logical out, inout, retval
      
      inout = .true.
      call Args_Cbool__create_f(obj)
      call starttest(test)
      call Args_Cbool_returnback_f(obj, retval)
      call reporttest(retval, test, .false.)
      call starttest(test)
      call Args_Cbool_passin_f(obj, .true., retval)
      call reporttest(retval, test, .false.)
      call starttest(test)
      call Args_Cbool_passout_f(obj, out, retval)
      call reporttest(retval .and. out, test,
     $     .false.)
      call starttest(test)
      call Args_Cbool_passinout_f(obj, inout, retval)
      call reporttest(retval .and. .not. inout, test,
     $      .false.)
      call starttest(test)
      call Args_Cbool_passeverywhere_f(obj, .true.,
     $     out, inout, retval)
      call reporttest(retval .and. out .and. inout, test,
     $      .false.)
      call Args_Cbool_deleteRef_f(obj)
      end

      subroutine testint(test)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval
      integer*4 iretval, out, inout
      
      inout = 3
      call Args_Cint__create_f(obj)
      call starttest(test)
      call Args_Cint_returnback_f(obj, iretval)
      call reporttest(iretval .eq. 3, test,
     $     .false.)
      call starttest(test)
      call Args_Cint_passin_f(obj, 3, bretval)
      call reporttest(bretval, test,
     $    .false.)
      call starttest(test)
      call Args_Cint_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3), test,
     $      .false.)
      call starttest(test)
      call Args_Cint_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3), test,
     $      .false.)
      call starttest(test)
      call Args_Cint_passeverywhere_f(obj, 3,
     $     out, inout, iretval)
      call reporttest((iretval .eq. 3) .and.
     $     (out .eq. 3) .and.
     $     (inout .eq. 3), test, .false.)
      call Args_Cint_deleteRef_f(obj)
      end

      subroutine testchar(test)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval
      character cretval, out, inout
      
      inout = 'A'
      call Args_Cchar__create_f(obj)
      call starttest(test)
      call Args_Cchar_returnback_f(obj, cretval)
      call reporttest(cretval .eq. '3', test, 
     $      .false.)
      call starttest(test)
      call Args_Cchar_passin_f(obj, '3', bretval)
      call reporttest(bretval, test,
     $      .false.)
      call starttest(test)
      call Args_Cchar_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. '3'), test,
     $      .false.)
      call starttest(test)
      call Args_Cchar_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. 'a'), test,
     $      .false.)
      call starttest(test)
      call Args_Cchar_passeverywhere_f(obj, '3',
     $     out, inout, cretval)
      call reporttest((cretval .eq. '3') .and.
     $     (out .eq. '3') .and.
     $     (inout .eq. 'A'), test, .false.)
      call Args_Cchar_deleteRef_f(obj)
      end

      subroutine testlong(test)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval
      integer*8 out, inout, iretval, inval
      
      inout = 3
      call Args_Clong__create_f(obj)
      call starttest(test)
      call Args_Clong_returnback_f(obj, iretval)
      call reporttest(iretval .eq. 3, test,
     $      .false.)
      call starttest(test)
      inval = 3
      call Args_Clong_passin_f(obj, inval, bretval)
      call reporttest(bretval, test,
     $      .false.)
      call starttest(test)
      call Args_Clong_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3), test,
     $      .false.)
      call starttest(test)
      call Args_Clong_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3), test,
     $      .false.)
      call starttest(test)
      inval = 3
      call Args_Clong_passeverywhere_f(obj, inval,
     $     out, inout, iretval)
      call reporttest((iretval .eq. 3) .and.
     $     (out .eq. 3) .and.
     $     (inout .eq. 3), test,  .false.)
      call Args_Clong_deleteRef_f(obj)
      end

      subroutine testfloat(test, python)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval, python
      real out, inout, fretval
      
      inout = 3.1
      call Args_Cfloat__create_f(obj)
      call starttest(test)
      call Args_Cfloat_returnback_f(obj, fretval)
      call reporttest(fretval .eq. 3.1, test, .false.)
      call starttest(test)
      call Args_Cfloat_passin_f(obj, 3.1, bretval)
      call reporttest(bretval, test, python)
      call starttest(test)
      call Args_Cfloat_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3.1), test,
     $      .false.)
      call starttest(test)
      call Args_Cfloat_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3.1), test,
     $      .false.)
      call starttest(test)
      call Args_Cfloat_passeverywhere_f(obj, 3.1,
     $     out, inout, fretval)
      call reporttest((fretval .eq. 3.1) .and.
     $     (out .eq. 3.1) .and.
     $     (inout .eq. 3.1), test,
     $      python)
      call Args_Cfloat_deleteRef_f(obj)
      end

      subroutine testdouble(test)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval
      double precision out, inout, dretval
      
      inout = 3.14d0
      call Args_Cdouble__create_f(obj)
      call starttest(test)
      call Args_Cdouble_returnback_f(obj, dretval)
      call reporttest(dretval .eq. 3.14d0, test,
     $      .false.)
      call starttest(test)
      call Args_Cdouble_passin_f(obj, 3.14d0, bretval)
      call reporttest(bretval, test,
     $     .false.)
      call starttest(test)
      call Args_Cdouble_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. 3.14d0), test,
     $      .false.)
      call starttest(test)
      call Args_Cdouble_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. -3.14d0), test,
     $      .false.)
      call starttest(test)
      call Args_Cdouble_passeverywhere_f(obj, 3.14d0,
     $     out, inout, dretval)
      call reporttest((dretval .eq. 3.14d0) .and.
     $     (out .eq. 3.14d0) .and.
     $     (inout .eq. 3.14d0), test,
     $     .false.)
      call Args_Cdouble_deleteRef_f(obj)
      end

      subroutine testfcomplex(test, python)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval, python
      complex in, out, inout, cretval
      
      in = (3.1,3.1)
      inout = (3.1, 3.1)
      call Args_Cfcomplex__create_f(obj)
      call starttest(test)
      call Args_Cfcomplex_returnback_f(obj, cretval)
      call reporttest(cretval .eq. (3.1,3.1), test,
     $     .false.)
      call starttest(test)
      call Args_Cfcomplex_passin_f(obj, in, bretval)
      call reporttest(bretval, test,  python)
      call starttest(test)
      call Args_Cfcomplex_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. (3.1,3.1)), test,
     $      .false.)
      call starttest(test)
      call Args_Cfcomplex_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. (3.1,-3.1)), test,
     $      .false.)
      call starttest(test)
      call Args_Cfcomplex_passeverywhere_f(obj, in,
     $     out, inout, cretval)
      call reporttest((cretval .eq. (3.1,3.1)) .and.
     $     (out .eq. (3.1,3.1)) .and.
     $     (inout .eq. (3.1,3.1)), test,
     $    python)
      call Args_Cfcomplex_deleteRef_f(obj)
      end

      subroutine testdcomplex(test)
      implicit none
      integer*8 obj
      integer*4 test
      logical bretval
      double complex in, out, inout, cretval
      
      in = (3.14d0,3.14d0)
      inout = (3.14d0, 3.14d0)
      call Args_Cdcomplex__create_f(obj)
      call starttest(test)
      call Args_Cdcomplex_returnback_f(obj, cretval)
      call reporttest(cretval .eq. (3.14d0,3.14d0), test,
     $      .false.)
      call starttest(test)
      call Args_Cdcomplex_passin_f(obj, in, bretval)
      call reporttest(bretval, test,
     $    .false.)
      call starttest(test)
      call Args_Cdcomplex_passout_f(obj, out, bretval)
      call reporttest(bretval .and. (out .eq. (3.14d0,3.14d0)),
     $     test,  .false.)
      call starttest(test)
      call Args_Cdcomplex_passinout_f(obj, inout, bretval)
      call reporttest(bretval .and. (inout .eq. (3.14d0,-3.14d0)),
     $     test,  .false.)
      call starttest(test)
      call Args_Cdcomplex_passeverywhere_f(obj, in,
     $     out, inout, cretval)
      call reporttest((cretval .eq. (3.14d0,3.14d0)) .and.
     $     (out .eq. (3.14d0,3.14d0)) .and.
     $     (inout .eq. (3.14d0,3.14d0)), test,
     $   .false.)
      call Args_Cdcomplex_deleteRef_f(obj)
      end


      program argstest
      integer*4 test
      integer*8 tracker
      character*80 language
      language = ' '
      if (IArgc() .eq. 1) then
         callGetArg(1, language)
      endif
      test = 1
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_setExpectations_f(tracker, 40)
      call synch_RegOut_writeComment_f(tracker,
     $     'Boolean tests')
      call testbool(test)
      call synch_RegOut_writeComment_f(tracker, 'Character tests')
      call testchar(test)
      call synch_RegOut_writeComment_f(tracker, 'Integer tests')
      call testint(test)
      call synch_RegOut_writeComment_f(tracker, 'Long tests')
      call testlong(test)
      call synch_RegOut_writeComment_f(tracker, 'Float tests')
      call testfloat(test, 
     $     language .eq. 'Python')
      call synch_RegOut_writeComment_f(tracker, 'Double tests')
      call testdouble(test)
      call synch_RegOut_writeComment_f(tracker, 'Fcomplex tests')
      call testfcomplex(test, 
     $     language .eq. 'Python')
      call synch_RegOut_writeComment_f(tracker, 'Dcomplex tests')
      call testDcomplex(test)
      call synch_RegOut_close_f(tracker)
      call synch_RegOut_deleteRef_f(tracker)
      end
