/*
 * File:          sidl_rmi_ProtocolFactory_jniStub.c
 * Symbol:        sidl.rmi.ProtocolFactory-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.rmi.ProtocolFactory
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_rmi_ProtocolFactory_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * External reference to IOR methods.
 */

static const struct sidl_rmi_ProtocolFactory__external* s_external = NULL;

/*
 * External reference to static EPV.
 */

static const struct sidl_rmi_ProtocolFactory__sepv* s_sepv = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Associate a particular prefix in the URL to a typeName <code>sidl.Loader</code> can find.
 * The actual type is expected to implement <code>sidl.rmi.InstanceHandle</code>
 * Return true iff the addition is successful.  (no collisions allowed)
 */

static jboolean
jni_addProtocol(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_prefix,
  jstring _arg_typeName)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_prefix = (char*) NULL;
  char* _tmp_typeName = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_prefix = sidl_Java_J2I_string(env, _arg_prefix);
  _tmp_typeName = sidl_Java_J2I_string(env, _arg_typeName);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_addProtocol))(
    _tmp_prefix,
    _tmp_typeName,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_prefix);
  sidl_String_free(_tmp_typeName);
  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Return the typeName associated with a particular prefix.
 * Return empty string if the prefix
 */

static jstring
jni_getProtocol(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_prefix)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_prefix = (char*) NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_prefix = sidl_Java_J2I_string(env, _arg_prefix);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_getProtocol))(
    _tmp_prefix,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_prefix);
  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Remove a protocol from the active list.
 */

static jboolean
jni_deleteProtocol(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_prefix)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_prefix = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_prefix = sidl_Java_J2I_string(env, _arg_prefix);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_deleteProtocol))(
    _tmp_prefix,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_prefix);
  _res = (jboolean) _ior_res;
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Create a new remote object and a return an instance handle for that object. 
 * The server and port number are in the url.  Return nil 
 * if protocol unknown or InstanceHandle.init() failed.
 */

static jobject
jni_createInstance(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_url,
  jstring _arg_typeName)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_url = (char*) NULL;
  char* _tmp_typeName = (char*) NULL;
  struct sidl_rmi_InstanceHandle__object* _ior_res = (struct 
    sidl_rmi_InstanceHandle__object*) NULL;
  jobject _res = (jobject) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_url = sidl_Java_J2I_string(env, _arg_url);
  _tmp_typeName = sidl_Java_J2I_string(env, _arg_typeName);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_createInstance))(
    _tmp_url,
    _tmp_typeName,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_url);
  sidl_String_free(_tmp_typeName);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.rmi.InstanceHandle");
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Create an new connection linked to an already existing object on a remote 
 * server.  The server and port number are in the url, the objectID is the unique ID
 * of the remote object in the remote instance registry. 
 * Return nil if protocol unknown or InstanceHandle.init() failed.
 */

static jobject
jni_connectInstance(
  JNIEnv* env,
  jclass  cls,
  jstring _arg_url,
  jstring _arg_typeName,
  jstring _arg_objectID)
{
  /*
   * Declare return and temporary variables.
   */

  char* _tmp_url = (char*) NULL;
  char* _tmp_typeName = (char*) NULL;
  char* _tmp_objectID = (char*) NULL;
  struct sidl_rmi_InstanceHandle__object* _ior_res = (struct 
    sidl_rmi_InstanceHandle__object*) NULL;
  jobject _res = (jobject) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _tmp_url = sidl_Java_J2I_string(env, _arg_url);
  _tmp_typeName = sidl_Java_J2I_string(env, _arg_typeName);
  _tmp_objectID = sidl_Java_J2I_string(env, _arg_objectID);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(s_sepv->f_connectInstance))(
    _tmp_url,
    _tmp_typeName,
    _tmp_objectID,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_url);
  sidl_String_free(_tmp_typeName);
  sidl_String_free(_tmp_objectID);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.rmi.InstanceHandle");
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.rmi.NetworkException",
    NULL);

  return _res;
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_rmi_ProtocolFactory__register(JNIEnv* env)
{
  JNINativeMethod methods[6];
  jclass cls;

  s_external = sidl_rmi_ProtocolFactory__externals();
  s_sepv = (*(s_external->getStaticEPV))();

  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "addProtocol";
  methods[1].signature = "(Ljava/lang/String;Ljava/lang/String;)Z";
  methods[1].fnPtr     = (void *)jni_addProtocol;
  methods[2].name      = "getProtocol";
  methods[2].signature = "(Ljava/lang/String;)Ljava/lang/String;";
  methods[2].fnPtr     = (void *)jni_getProtocol;
  methods[3].name      = "deleteProtocol";
  methods[3].signature = "(Ljava/lang/String;)Z";
  methods[3].fnPtr     = (void *)jni_deleteProtocol;
  methods[4].name      = "createInstance";
  methods[4].signature = "(Ljava/lang/String;Ljava/lang/String;)Lsidl/rmi/InstanceHandle;";
  methods[4].fnPtr     = (void *)jni_createInstance;
  methods[5].name      = "connectInstance";
  methods[5].signature = "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lsidl/rmi/InstanceHandle;";
  methods[5].fnPtr     = (void *)jni_connectInstance;


  cls = (*env)->FindClass(env, "sidl/rmi/ProtocolFactory");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 6);
    (*env)->DeleteLocalRef(env, cls);
  }
}
