!
! File:       arraytests.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Revision:   @(#) $Revision: 4434 $
! Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description:Exercise the FORTRAN interface
!
!
#include "ArrayTest_ArrayOps_fAbbrev.h"
#include "sidl_bool_fAbbrev.h"
#include "sidl_char_fAbbrev.h"
#include "sidl_dcomplex_fAbbrev.h"
#include "sidl_double_fAbbrev.h"
#include "sidl_fcomplex_fAbbrev.h"
#include "sidl_float_fAbbrev.h"
#include "sidl_int_fAbbrev.h"
#include "sidl_long_fAbbrev.h"
#include "sidl_string_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
#include "synch_ResultType_fAbbrev.h"

subroutine starttest(number)
  use synch_RegOut
 integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call startPart(tracker, number)
  call deleteRef(tracker)
end subroutine starttest

subroutine reporttest(test, number,  python)
  use synch_RegOut
  use synch_ResultType
  integer (kind=selected_int_kind(9)) :: number
  logical                             :: test, python
!    implicit none
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  if (test) then
     call endPart(tracker, number, PASS)
  else
     if (python) then
        call endPart(tracker, number, XFAIL)
     else
        call endPart(tracker, number, FAIL)
     endif
  endif
  call deleteRef(tracker)
  number = number + 1
end subroutine reporttest

logical function my_isprime(num)
  integer (selected_int_kind(18)) :: num
!    implicit none
  integer (selected_int_kind(18)) :: i
  i = 3
  do while (i*i .le. num)
     if (mod(num,i) .eq. 0) then
        my_isprime = .false.
        return
     endif
     i = i + 1
  enddo
  my_isprime = .true.
  return
end function my_isprime


integer (selected_int_kind(18)) function my_nextprime(prev)
  integer (selected_int_kind(18)) :: prev
!    implicit none
  logical :: my_isprime
  if (prev .le. 1) then
     my_nextprime = 2
     return
  endif
  if (prev .eq. 2) then
     my_nextprime = 3
     return
  endif
  prev = prev + 2
  do while (.not. my_isprime(prev))
     prev = prev + 2
  enddo
  my_nextprime = prev
  return
end function my_nextprime

subroutine my_force_float(f)
  real(selected_real_kind(6,37)) :: f
  return
end subroutine my_force_float

subroutine my_force_fcomplex(f)
  complex(selected_real_kind(6,37)) :: f
  return
end subroutine my_force_fcomplex

subroutine checkBoolArrays(test,  python)
  use sidl_bool_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_bool_1d) :: barray
  
  call set_null(barray)

  call starttest(test)
  call createBool(217,barray)
  call reporttest(not_null(barray), test,  python)

  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseBool(barray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(barray)

  call set_null(barray)

  call makeBool(218, barray)

  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseBool(barray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(barray)

  call set_null(barray)

  call makeBool(9, barray)
  call starttest(test)
  call reverseBool(barray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkBool(barray, retval)
  call reporttest(retval, test,  python)
  call deleteRef(barray)

  call set_null(barray)

  call starttest(test)
  call makeBool(-1, barray)
  call reporttest(is_null(barray), test,  python)
  
  if (not_null(barray)) then
     call deleteRef(barray)
  endif
  
end subroutine CheckBoolArrays

subroutine CheckCharArrays(test,  python)
  use sidl_char_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_char_1d) :: carray

  call set_null(carray)

  call starttest(test)
  call createChar(217,carray)
  call reporttest(not_null(carray), test,  python)

  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseChar(carray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(carray)

  call set_null(carray)

  call makeChar(218, carray)

  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseChar(carray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(carray)

  call set_null(carray)

  call makeChar(9, carray)
  call starttest(test)
  call reverseChar(carray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkChar(carray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(carray)

  call set_null(carray)

  call starttest(test)
  call makeChar(-1, carray)
  call reporttest(is_null(carray), test,  python)
  
  if (not_null(carray)) then
     call deleteRef(carray)
  endif
  
end subroutine CheckCharArrays

subroutine CheckIntArrays(test,  python)
  use sidl_int_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_int_1d) :: iarray

  call set_null(iarray)

  call starttest(test)
  call createInt(217,iarray)
  call reporttest(not_null(iarray), test,  python)

  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseInt(iarray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(iarray)

  call set_null(iarray)

  call makeInt(218, iarray)

  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseInt(iarray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(iarray)

  call set_null(iarray)

  call makeInt(9, iarray)
  call starttest(test)
  call reverseInt(iarray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkInt(iarray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(iarray)

  call set_null(iarray)

  call starttest(test)
  call makeInt(-1, iarray)
  call reporttest(is_null(iarray), test,  python)
  
  if (not_null(iarray)) then
     call deleteRef(iarray)
  endif
  
end subroutine CheckIntArrays

subroutine CheckLongArrays(test,  python)
  use sidl_long_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_long_1d) :: larray

  call set_null(larray)

  call starttest(test)
  call createLong(217,larray)
  call reporttest(not_null(larray), test,  python)

  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseLong(larray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(larray)

  call set_null(larray)

  call makeLong(218, larray)

  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseLong(larray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(larray)

  call set_null(larray)

  call makeLong(9, larray)
  call starttest(test)
  call reverseLong(larray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkLong(larray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(larray)

  call set_null(larray)

  call starttest(test)
  call makeLong(-1, larray)
  call reporttest(is_null(larray), test,  python)
  
  if (not_null(larray)) then
     call deleteRef(larray)
  endif
  
end subroutine CheckLongArrays

subroutine CheckStringArrays(test,  python)
  use sidl_string_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_string_1d) :: sarray

  call set_null(sarray)

  call starttest(test)
  call createString(217,sarray)
  call reporttest(not_null(sarray), test,  python)

  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseString(sarray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(sarray)

  call set_null(sarray)

  call makeString(218, sarray)

  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseString(sarray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(sarray)

  call set_null(sarray)

  call makeString(9, sarray)
  call starttest(test)
  call reverseString(sarray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkString(sarray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(sarray)

  call set_null(sarray)

  call starttest(test)
  call makeString(-1, sarray)
  call reporttest(is_null(sarray), test,  python)
  
  if (not_null(sarray)) then
     call deleteRef(sarray)
  endif
  
end subroutine CheckStringArrays

subroutine CheckDoubleArrays(test,  python)
  use sidl_double_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_double_1d) :: darray

  call set_null(darray)

  call starttest(test)
  call createDouble(217,darray)
  call reporttest(not_null(darray), test,  python)

  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseDouble(darray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(darray)

  call set_null(darray)

  call makeDouble(218, darray)

  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseDouble(darray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(darray)

  call set_null(darray)

  call makeDouble(9, darray)
  call starttest(test)
  call reverseDouble(darray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkDouble(darray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(darray)

  call set_null(darray)

  call starttest(test)
  call makeDouble(-1, darray)
  call reporttest(is_null(darray), test,  python)
  
  if (not_null(darray)) then
     call deleteRef(darray)
  endif
  
end subroutine CheckDoubleArrays

subroutine CheckFloatArrays(test,  python)
  use sidl_float_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_float_1d) :: farray

  call set_null(farray)

  call starttest(test)
  call createFloat(217,farray)
  call reporttest(not_null(farray), test,  python)

  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseFloat(farray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(farray)

  call set_null(farray)

  call makeFloat(218, farray)

  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseFloat(farray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(farray)

  call set_null(farray)

  call makeFloat(9, farray)
  call starttest(test)
  call reverseFloat(farray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkFloat(farray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(farray)

  call set_null(farray)

  call starttest(test)
  call makeFloat(-1, farray)
  call reporttest(is_null(farray), test,  python)
  
  if (not_null(farray)) then
     call deleteRef(farray)
  endif
  
end subroutine CheckFloatArrays

subroutine CheckFcomplexArrays(test,  python)
  use sidl_fcomplex_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_fcomplex_1d) :: fcarray

  call set_null(fcarray)

  call starttest(test)
  call createFcomplex(217,fcarray)
  call reporttest(not_null(fcarray), test,  python)

  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseFcomplex(fcarray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(fcarray)

  call set_null(fcarray)

  call makeFcomplex(218, fcarray)

  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseFcomplex(fcarray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(fcarray)

  call set_null(fcarray)

  call makeFcomplex(9, fcarray)
  call starttest(test)
  call reverseFcomplex(fcarray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkFcomplex(fcarray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(fcarray)

  call set_null(fcarray)

  call starttest(test)
  call makeFcomplex(-1, fcarray)
  call reporttest(is_null(fcarray), test,  python)
  
  if (not_null(fcarray)) then
     call deleteRef(fcarray)
  endif
  
end subroutine CheckFcomplexArrays

subroutine CheckDcomplexArrays(test,  python)
  use sidl_dcomplex_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
!    implicit none
  logical ::  retval
  type(sidl_dcomplex_1d) :: dcarray

  call set_null(dcarray)

  call starttest(test)
  call createDcomplex(217,dcarray)
  call reporttest(not_null(dcarray), test,  python)

  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseDcomplex(dcarray, .true., retval)
  call reporttest(retval, test,  python)

  call deleteRef(dcarray)

  call set_null(dcarray)

  call makeDcomplex(218, dcarray)

  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call reverseDcomplex(dcarray, .false., retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(.not. retval, test,  python)
  
  call deleteRef(dcarray)

  call set_null(dcarray)

  call makeDcomplex(9, dcarray)
  call starttest(test)
  call reverseDcomplex(dcarray, .false., retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  call checkDcomplex(dcarray, retval)
  call reporttest(.not. retval, test,  python)
  call deleteRef(dcarray)

  call set_null(dcarray)

  call starttest(test)
  call makeDcomplex(-1, dcarray)
  call reporttest(is_null(dcarray), test,  python)
  
  if (not_null(dcarray)) then
     call deleteRef(dcarray)
  endif
  
end subroutine CheckDcomplexArrays

subroutine Check2DoubleArrays(test, python)
  use sidl_double_array
  use ArrayTest_ArrayOps
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in) :: python
!    implicit none
  integer :: i, j
  logical ::  retval
  real(selected_real_kind(15,307)) :: tmp
  type(sidl_double_2d) :: darray
  call starttest(test)
  call create2Double(17,35,darray)
  call reporttest(not_null(darray), test,  python)

  call starttest(test)
  call check2Double(darray, retval)
  call reporttest(retval, test,  python)

  call starttest(test)
  do i = 0, 16
     do j = 0, 34
        darray%d_data(i,j) = 2.0**(i-j)
     enddo
  enddo
  
  call check2Double(darray, retval)
  call reporttest(retval, test,  python)


  call deleteRef(darray)
  call set_null(darray)

  call starttest(test)
  call create2Double(-1, -1, darray)
  call reporttest(is_null(darray), test,  python)

end subroutine Check2DoubleArrays

subroutine CheckGenericArrays(test,  python)
  use sidl_int_array
  use sidl_array_array
  use ArrayTest_ArrayOps
  implicit none
  integer(selected_int_kind(9)), intent(inout) :: test
  logical, intent(in)  :: python
  logical ::  retval
  type(sidl_int_1d) :: icarray
  type(sidl_int_2d) :: i2array
  type(sidl_bool_1d) :: barray
  type(sidl_bool_2d) :: b2array
  type(sidl__array)  :: garray, garrayret, garrayout, garrayinout
  integer(selected_int_kind(9)) :: dim, enumtype
  dim = 1
  enumtype = 7

  call set_null(icarray)
  call set_null(garray)
  call set_null(garrayret)
  call set_null(garrayout)
  call set_null(garrayinout)
  

  call starttest(test)
  call reporttest(is_null(garray), test,  python)
  
  call starttest(test)
  call createInt(217,icarray)
  call reporttest(not_null(icarray), test,  python)

  call starttest(test)
  call cast(icarray, garray)
  call reporttest(not_null(garray), test,  python)
  call starttest(test)
  call checkGeneric(garray,dim, enumtype)
  call reporttest(dim .eq. 1, test,  python)
  call starttest(test)
  call reporttest(enumtype .eq. 7, test,  python)

 ! call deleteref(garray)
 ! call set_null(garray)
 ! call set_null(icarray)

  !Create a bool array with createGeneric
 !print *, 6
  call starttest(test)
  call createGeneric(1, 1, garray)

  call reporttest(not_null(garray), test,  python)
  call starttest(test)
  call checkGeneric(garray,dim, enumtype)
  call reporttest(dim .eq. 1, test,  python)
  call starttest(test)
  call reporttest(enumtype .eq. 1, test,  python)
  call cast(garray, barray)
 
  call starttest(test)
  call reporttest(not_null(garray), test,  python)

  call starttest(test)
  call passGeneric(garray, garrayinout, garrayout, garrayret)
  call reporttest(not_null(garray), test,  python)
  call starttest(test)
  call reporttest(not_null(garrayret), test,  python)
  call addref(garrayret)
  call starttest(test)
  call reporttest(not_null(garrayout), test,  python)
  call starttest(test)
  call reporttest(not_null(garrayinout), test,  python)

  call starttest(test)
  call checkGeneric(garray,dim, enumtype)
  call reporttest(dim .eq. 1, test,  python)
  call starttest(test)
  call reporttest(enumtype .eq. 1, test,  python)
  call starttest(test)
  call cast(garray, barray)
  call reporttest(not_null(barray), test,  python)

  call starttest(test)
  call checkGeneric(garrayret,dim, enumtype)
  call reporttest(dim .eq. 1, test,  python)
  call starttest(test)
  call reporttest(enumtype .eq. 1, test,  python)
  call starttest(test)
  call cast(garrayret, barray)
  call reporttest(not_null(barray), test,  python)

  call starttest(test)
  call checkGeneric(garrayout,dim, enumtype)
  call reporttest(dim .eq. 1, test,  python)
  call starttest(test)
  call reporttest(enumtype .eq. 1, test,  python)
  call cast(garrayout, barray)
  call starttest(test)
  call reporttest(not_null(barray), test,  python)

  call starttest(test)
  call checkGeneric(garrayinout,dim, enumtype)
  call reporttest(dim .eq. 2, test,  python)
  call starttest(test)
  call cast(garrayinout, i2array)
  call reporttest(not_null(i2array), test,  python)


end subroutine CheckGenericArrays


subroutine checkRarrays(test, python)
  use ArrayTest_ArrayOps
  implicit none
  integer (selected_int_kind(9)) :: test
  logical python, retval
  integer (selected_int_kind(9)) :: ir(0:99), ir3(0:5, 0:3, 0:3)
  integer (selected_int_kind(9)) :: ir7(0:2, 0:2, 0:2, 0:2, 0:3, 0:3, 0:3)
  real (selected_real_kind(15, 307)), dimension(0:99) :: dr(0:99)
  complex (selected_real_kind(15, 307)), dimension(0:99) :: dcr
  call starttest(test)
  call initRarray1Int(ir)
  call checkRarray1Int(ir, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call initRarray3Int(ir3)
  call checkRarray3Int(ir3, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call initRarray7Int(ir7)
  call checkRarray7Int(ir7,  retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call initRarray1Double(dr)
  call checkRarray1Double(dr, retval)
  call reporttest(retval, test,  python)
  
  call starttest(test)
  call initRarray1Dcomplex(dcr)
  call checkRarray1Dcomplex(dcr, retval)
  call reporttest(retval, test,  python)
end subroutine checkRarrays



program arraytests
  use synch_RegOut
  integer (selected_int_kind(9)) :: test
  type(synch_RegOut_t) :: tracker
  character (len=80)             :: language
  logical                        :: ispython
  language = ' '
  if (IArgc() .eq. 1) then
     call GetArg(1, language)
  endif
  ispython = language .eq. 'Python'
  test = 1
  call getInstance(tracker)
  call setExpectations(tracker,114)

  call writeComment(tracker, 'Boolean tests')
  call CheckBoolArrays(test,  ispython)

  call writeComment(tracker, 'Char tests')
  call CheckCharArrays(test,  ispython)

  call writeComment(tracker, 'Int tests')
  call CheckIntArrays(test,  ispython)

  call writeComment(tracker, 'Long tests')
  call CheckLongArrays(test,  ispython)

  call writeComment(tracker, 'String tests')
  call CheckStringArrays(test,  ispython)

  call writeComment(tracker, 'Double tests')
  call CheckDoubleArrays(test,  ispython)

  call writeComment(tracker, 'Float tests')
  call CheckFloatArrays(test,  ispython)

  call writeComment(tracker, 'Fcomplex tests')
  call CheckFcomplexArrays(test,  ispython)

  call writeComment(tracker, 'Dcomplex tests')
  call CheckDcomplexArrays(test,  ispython)

  call writeComment(tracker, '2D double tests')
  call Check2DoubleArrays(test,  ispython)
  
  call writeComment(tracker, 'Generic tests')
  call CheckGenericArrays(test,  ispython)

  call writeComment(tracker, 'Rarray tests')
  call CheckRarrays(test,  ispython)

  call close(tracker)
  call deleteRef(tracker)
end program arraytests
