! 
! File:          ExceptionTest_Fib_Impl.F90
! Symbol:        ExceptionTest.Fib-v1.0
! Symbol Type:   class
! Babel Version: 0.10.2
! Description:   Server-side implementation for ExceptionTest.Fib
! 
! WARNING: Automatically generated; only changes within splicers preserved
! 
! babel-version = 0.10.2
! 


! 
! Symbol "ExceptionTest.Fib" (version 1.0)
! 
! This class holds the method <code>getFib</code> that generates the
! requested Fibonacci numbers.
! 


#include "ExceptionTest_Fib_fAbbrev.h"
#include "ExceptionTest_NegativeValueException_fAbbrev.h"
#include "ExceptionTest_FibException_fAbbrev.h"
#include "sidl_ClassInfo_fAbbrev.h"
#include "sidl_BaseInterface_fAbbrev.h"
#include "sidl_BaseException_fAbbrev.h"
#include "sidl_BaseClass_fAbbrev.h"
! DO-NOT-DELETE splicer.begin(_miscellaneous_code_start)
#include "ExceptionTest_TooBigException_fAbbrev.h"
#include "ExceptionTest_TooDeepException_fAbbrev.h"
! DO-NOT-DELETE splicer.end(_miscellaneous_code_start)




! 
! Class constructor called when the class is created.
! 

recursive subroutine ExceptionTest_Fib__ctor_mi(self)
  use ExceptionTest_Fib
  use ExceptionTest_Fib_impl
  ! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._ctor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ExceptionTest.Fib._ctor.use)
  implicit none
  type(ExceptionTest_Fib_t) :: self ! in

! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._ctor)
! Nothing needed here...
! DO-NOT-DELETE splicer.end(ExceptionTest.Fib._ctor)
end subroutine ExceptionTest_Fib__ctor_mi


! 
! Class destructor called when the class is deleted.
! 

recursive subroutine ExceptionTest_Fib__dtor_mi(self)
  use ExceptionTest_Fib
  use ExceptionTest_Fib_impl
  ! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor.use)
  implicit none
  type(ExceptionTest_Fib_t) :: self ! in

! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._dtor)
! Nothing needed here...
! DO-NOT-DELETE splicer.end(ExceptionTest.Fib._dtor)
end subroutine ExceptionTest_Fib__dtor_mi


! 
! Static class initializer called exactly once before any user-defined method is dispatched
! 

recursive subroutine ExceptionTest_Fib__load_mi()
  use ExceptionTest_Fib
  use ExceptionTest_Fib_impl
  ! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._load.use)
  ! Insert use statements here...
  ! DO-NOT-DELETE splicer.end(ExceptionTest.Fib._load.use)
  implicit none

! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib._load)
! Insert the implementation here...
! DO-NOT-DELETE splicer.end(ExceptionTest.Fib._load)
end subroutine ExceptionTest_Fib__load_mi


! 
! <p>
! Generate the requested Fibonacci number or generate exceptions if
! the input Fibonacci number is invalid or if any of the maximum depth
! or maximum value parameters are exceeded.  The last argument of the
! method should be zero.
! </p>
! <p>
! The algorithm should be similar to the <code>Java</code> code below.
! </p>
! <pre>
! public int getFib(int n, int max_depth, int max_value, int depth)
!     throws NegativeValueException, FibException {
! 
!   if (n < 0) {
!     throw new NegativeValueException("n negative");
! 
!   } else if (depth > max_depth) {
!     throw new TooDeepException("too deep");
! 
!   } else if (n == 0) {
!     return 1;
! 
!   } else if (n == 1) {
!     return 1;
! 
!   } else {
!     int a = getFib(n-1, max_depth, max_value, depth+1);
!     int b = getFib(n-2, max_depth, max_value, depth+1);
!     if (a + b > max_value) {
!       throw new TooBigException("too big");
!     }
!     return a + b;
!   }
! } 
! </pre>
! 

recursive subroutine ExceptionTest_Fib_getFib_mi(self, n, max_depth,           &
  max_value, depth, retval, exception)
  use ExceptionTest_Fib
  use ExceptionTest_NegativeValueException
  use ExceptionTest_FibException
  use sidl_BaseInterface
  use ExceptionTest_Fib_impl
  ! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib.use)
  use ExceptionTest_TooBigException
  use ExceptionTest_TooDeepException
  ! DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib.use)
  implicit none
  type(ExceptionTest_Fib_t) :: self ! in
  integer (selected_int_kind(9)) :: n ! in
  integer (selected_int_kind(9)) :: max_depth ! in
  integer (selected_int_kind(9)) :: max_value ! in
  integer (selected_int_kind(9)) :: depth ! in
  integer (selected_int_kind(9)) :: retval ! out
  type(sidl_BaseInterface_t) :: exception ! out

! DO-NOT-DELETE splicer.begin(ExceptionTest.Fib.getFib)
  type(ExceptionTest_NegativeValueException_t) :: negexc
  type(ExceptionTest_TooDeepException_t) :: deepexc
  type(ExceptionTest_TooBigException_t) :: toobigexc
  type(ExceptionTest_FibException_t) :: fibexc
  character (len=*) myfilename 
  parameter(myfilename='ExceptionTest_Fib_Impl.f')
  integer(selected_int_kind(9)) a, b
  retval = 0
  if (n .lt. 0) then
     call new(negexc)
     if (not_null(negexc)) then
        call setNote(negexc, &
             'called with negative n')
        call add( &
             negexc, myfilename, 57, 'ExceptionTest_Fib_getFib_impl')
        call cast(negexc, exception)
        return
     endif
  else if (depth .gt. max_depth) then
     call new(deepexc)
     if (not_null(deepexc)) then
        call setNote( deepexc, &
             'exceeded specified recursion depth')
        call add( deepexc, &
             myfilename, 70, 'ExceptionTest_Fib_getFib_impl')
        call cast(deepexc, exception)
        return
     endif
  else if (n .eq. 0) then
     retval = 1
  else if (n .eq. 1) then
     retval = 1
  else 
   ! 
   ! Note that we must call the stub version of this method
   ! because g77 does not (currently) support recursion.
   ! 
     call getFib(self, &
          n-1, &
          max_depth, & 
          max_value, &
          depth+1, & 
          a, &
          exception)
     call cast(exception, fibexc)
     if (not_null(fibexc)) then
        call add( &
             fibexc, &
             myfilename, &
             90, &
             'ExceptionTest_Fib_getFib_impl')
        return
     endif
   ! 
   ! Note that we must call the stub version of this method
   ! because g77 does not (currently) support recursion.
   ! 
     call getFib(self, &
          n-2, &
          max_depth, &
          max_value, &
          depth+1, &
          b, &
          exception)
     call cast(exception, fibexc)
     if (not_null(fibexc)) then
        call add( &
             fibexc, &
             myfilename, &
             105,  &
             'ExceptionTest_Fib_getFib_impl')
        return
     endif
     retval = a+b
     if (retval .gt. max_value) then
        retval = 0
        call new(toobigexc)
        if (not_null(toobigexc)) then
           call setNote( &
                toobigexc, &
                'result exceeds specified maximum value')
           call add( &
                toobigexc, &
                myfilename, &
                103, &
                'ExceptionTest_Fib_getFib_impl')
           call cast(toobigexc, exception)
           return
        endif
     endif
  endif
! DO-NOT-DELETE splicer.end(ExceptionTest.Fib.getFib)
end subroutine ExceptionTest_Fib_getFib_mi


! DO-NOT-DELETE splicer.begin(_miscellaneous_code_end)
! Nothing needed here...
! DO-NOT-DELETE splicer.end(_miscellaneous_code_end)
