#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <time.h>
#include "objarg_Employee.h"
#include "objarg_EmployeeArray.h"
#include "sidl_BaseInterface.h"
#include "synch.h"


#define MYASSERT( AAA ) \
  synch_RegOut_startPart(tracker, ++part_no); \
  synch_RegOut_writeComment(tracker, #AAA); \
  if ( AAA ) result = synch_ResultType_PASS; \
  else result = synch_ResultType_FAIL;  \
  synch_RegOut_endPart(tracker, part_no, result);

struct TmpData_t {
  char  *name;
  int    age;
  float  salary;
  char   status;
};

struct TmpData_t TmpData[] = {
  { "John Smith", 35, 75.7e3, 'c' },
  { "Jane Doe", 40, 85.5e3, 'm' },
  { "Ella Vader", 64, 144.2e3, 'r' },
  { "Marge Inovera", 32, 483.2e3, 's' },
  { "Hughy Louis Dewey", 45, 182.9e3, 'm' },
  { "Heywood Yubuzof", 12, 20.8e3, 'x' },
  { "Picov Andropov", 90, 120.6e3, 'r' }
};

int main(int argc, char **argv) {
  int result = synch_ResultType_PASS; 
  int part_no = 0;
  int i, NewRidersFound=0;
  synch_RegOut tracker = synch_RegOut__create();
  const int numEmp = sizeof(TmpData)/sizeof(struct TmpData_t);
  objarg_EmployeeArray a = objarg_EmployeeArray__create();
  objarg_Employee f;
  srand(time(NULL));
  synch_RegOut_setExpectations(tracker, 78);
  for(i = 0; i < numEmp; ++i) {
    objarg_Employee e = objarg_Employee__create();
    objarg_Employee tmp;
    MYASSERT(objarg_Employee_init(e,
                                  TmpData[i].name, TmpData[i].age, 
                                  TmpData[i].salary, TmpData[i].status));
    MYASSERT(objarg_EmployeeArray_appendEmployee(a, e));
    MYASSERT(objarg_EmployeeArray_getLength(a) == (i+1));
    tmp = objarg_EmployeeArray_at(a, i+1);
    MYASSERT(objarg_Employee_isSame(e, (sidl_BaseInterface)tmp));
    MYASSERT(objarg_Employee_getAge(e) == TmpData[i].age);
    MYASSERT(objarg_Employee_getSalary(e) == TmpData[i].salary);
    MYASSERT(objarg_Employee_getStatus(e) == TmpData[i].status);
    if (tmp) objarg_Employee_deleteRef(tmp);
      objarg_Employee_deleteRef(e);
  }
  for(i = 0; i < numEmp; ++i) {
    /* initialize pointer to arbitrary value to make sure input is ignored */
    objarg_Employee e = (objarg_Employee)(ptrdiff_t)rand(); 
    objarg_Employee fromArray;
    int empInd = objarg_EmployeeArray_findByName(a, TmpData[i].name, &e);
    MYASSERT(empInd == (i+1));
    if (empInd != 0) {
      fromArray = objarg_EmployeeArray_at(a, empInd);
      MYASSERT(fromArray);
      if (fromArray) {
        MYASSERT(objarg_Employee_isSame(e, (sidl_BaseInterface)fromArray));
        objarg_Employee_deleteRef(fromArray);
      }
    }
    if (e) objarg_Employee_deleteRef(e);
  }
  f = objarg_Employee__create();
  objarg_Employee_init(f, "Hire High", 21, 0, 's');
  MYASSERT(objarg_EmployeeArray_promoteToMaxSalary(a, &f));
  MYASSERT(f);
  if (f) {
    MYASSERT(objarg_Employee_getSalary(f) == (float)483.2e3);
    MYASSERT(objarg_EmployeeArray_appendEmployee(a, f));
    objarg_Employee_deleteRef(f);
  }
  f = objarg_Employee__create();
  objarg_Employee_init(f, "Amadeo Avogadro, conte di Quaregna",
                       225, 6.022045e23, 'd');
  MYASSERT(!objarg_EmployeeArray_promoteToMaxSalary(a, &f));
  if (f) objarg_Employee_deleteRef(f);
  /*  Adding a NULL employee should fail  */
  MYASSERT(!objarg_EmployeeArray_appendEmployee(a, NULL));
  /* Search for a non-existent employee  */
  NewRidersFound = objarg_EmployeeArray_findByName(a, "New Riders", &f);
  MYASSERT(!(NewRidersFound || f));
  f = NULL;
  MYASSERT(!objarg_EmployeeArray_promoteToMaxSalary(a, &f));
  objarg_EmployeeArray_deleteRef(a);
  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);
  return 0;
}
