/*
 * File:          Ordering_IntOrderTest_Impl.c
 * Symbol:        Ordering.IntOrderTest-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for Ordering.IntOrderTest
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "Ordering.IntOrderTest" (version 0.1)
 * 
 * This class provides methods to verify that the array ordering
 * capabilities work for arrays of int.
 */

#include "Ordering_IntOrderTest_Impl.h"

#line 27 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
/* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._includes) */
#include <stdlib.h>

static int32_t
iFunc(const int32_t *ind, const int32_t dim)
{
  int32_t res = 0;
  int32_t i;
  for(i = 0; i < dim ; ++i) {
    res += (i+1)*ind[i];
  }
  return res;
}

static int
incIndex(int32_t ind[], const struct sidl_int__array* A, const int32_t dimen)
{
  int32_t i = 0;
  while (i < dimen) {
    if (++(ind[i]) > sidlUpper(A, i)) {
      ind[i] = sidlLower(A, i);
      ++i;
    }
    else {
      return TRUE;
    }
  }
  /* we're all done */
  return FALSE;
}

static sidl_bool
isIMatrix(const struct sidl_int__array* A)
{
  if (A) {
    const int32_t dimen = sidl_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = sidlLower(A, i);
      if (sidlLower(A,i) > sidlUpper(A,i)) {
        free(cindex);
        return TRUE;
      }
    }
    do {
      if (iFunc(cindex, dimen) != sidl_int__array_get(A, cindex)) {
        free(cindex);
        return FALSE;
      }
    } while (incIndex(cindex, A, dimen));
    free(cindex);
    return TRUE;
  }
  return FALSE;
}

static void
fillIMatrix(struct sidl_int__array* A)
{
  if (A) {
    const int32_t dimen = sidl_int__array_dimen(A);
    int32_t i;
    int32_t *cindex = malloc(sizeof(int32_t)*dimen);
    for(i = 0; i < dimen; ++i){
      cindex[i] = sidlLower(A, i);
      if (sidlLower(A,i) > sidlUpper(A,i)){
        free(cindex);
        return;
      }
    }
    do {
      sidl_int__array_set(A, cindex, iFunc(cindex, dimen));
    } while (incIndex(cindex, A, dimen));
    free(cindex);
  }
}
/* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._includes) */
#line 106 "Ordering_IntOrderTest_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest__load"

void
impl_Ordering_IntOrderTest__load(
  void)
{
#line 117 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._load) */
#line 123 "Ordering_IntOrderTest_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest__ctor"

void
impl_Ordering_IntOrderTest__ctor(
  /* in */ Ordering_IntOrderTest self)
{
#line 132 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._ctor) */
  /* Insert the implementation of the constructor method here... */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._ctor) */
#line 140 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest__dtor"

void
impl_Ordering_IntOrderTest__dtor(
  /* in */ Ordering_IntOrderTest self)
{
#line 148 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest._dtor) */
  /* Insert the implementation of the destructor method here... */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest._dtor) */
#line 158 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Create a column-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_makeColumnIMatrix"

struct sidl_int__array*
impl_Ordering_IntOrderTest_makeColumnIMatrix(
  /* in */ int32_t size,
  /* in */ sidl_bool useCreateCol)
{
#line 165 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeColumnIMatrix) */
  struct sidl_int__array *res;
  if (useCreateCol) {
    res = sidl_int__array_create2dCol(size, size);
  }
  else {
    res = sidl_int__array_create2dRow(size, size);
  }
  fillIMatrix(res);
  return res;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeColumnIMatrix) */
#line 185 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Create a row-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_makeRowIMatrix"

struct sidl_int__array*
impl_Ordering_IntOrderTest_makeRowIMatrix(
  /* in */ int32_t size,
  /* in */ sidl_bool useCreateRow)
{
#line 190 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeRowIMatrix) */
  struct sidl_int__array *res;
  if (useCreateRow) {
    res = sidl_int__array_create2dRow(size, size);
  }
  else {
    res = sidl_int__array_create2dCol(size, size);
  }
  fillIMatrix(res);
  return res;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeRowIMatrix) */
#line 212 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Create a 4-D matrix satisfying condition I.  Each dimension has
 * size elements numbers 0 through size-1.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_makeIMatrix"

struct sidl_int__array*
impl_Ordering_IntOrderTest_makeIMatrix(
  /* in */ int32_t size,
  /* in */ sidl_bool useCreateColumn)
{
#line 216 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.makeIMatrix) */
  struct sidl_int__array *res;
  static const int lower[4] = { 0, 0, 0, 0};
  int upper[4];
  upper[0] = upper[1] = upper[2] = upper[3] = size - 1;
  if (useCreateColumn) {
    res = sidl_int__array_createCol(4, lower, upper);
  }
  else {
    res = sidl_int__array_createRow(4, lower, upper);
  }
  fillIMatrix(res);
  return res;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.makeIMatrix) */
#line 243 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Create a column-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_createColumnIMatrix"

void
impl_Ordering_IntOrderTest_createColumnIMatrix(
  /* in */ int32_t size,
  /* in */ sidl_bool useCreateCol,
  /* out */ struct sidl_int__array** res)
{
#line 245 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createColumnIMatrix) */
  if (useCreateCol) {
    *res = Ordering_IntOrderTest_makeColumnIMatrix(size, TRUE);
  }
  else{
    *res = Ordering_IntOrderTest_makeRowIMatrix(size, TRUE);
  }
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createColumnIMatrix) */
#line 268 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Create a row-major matrix satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_createRowIMatrix"

void
impl_Ordering_IntOrderTest_createRowIMatrix(
  /* in */ int32_t size,
  /* in */ sidl_bool useCreateRow,
  /* out */ struct sidl_int__array** res)
{
#line 268 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.createRowIMatrix) */
  if (useCreateRow) {
    *res = Ordering_IntOrderTest_makeRowIMatrix(size, TRUE);
  }
  else{
    *res = Ordering_IntOrderTest_makeColumnIMatrix(size, TRUE);
  }
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.createRowIMatrix) */
#line 293 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Make sure an array is column-major.  No changes to the dimension or
 * values in a are made.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_ensureColumn"

void
impl_Ordering_IntOrderTest_ensureColumn(
  /* inout */ struct sidl_int__array** a)
{
#line 290 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureColumn) */
  /* no action required */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureColumn) */
#line 312 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Make sure an array is row-major.  No changes to the dimension or
 * values in a are made.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_ensureRow"

void
impl_Ordering_IntOrderTest_ensureRow(
  /* inout */ struct sidl_int__array** a)
{
#line 307 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.ensureRow) */
  /* no action required */
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.ensureRow) */
#line 331 "Ordering_IntOrderTest_Impl.c"
}

/*
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isIMatrixOne"

sidl_bool
impl_Ordering_IntOrderTest_isIMatrixOne(
  /* in */ struct sidl_int__array* A)
{
#line 324 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixOne) */
  return isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixOne) */
#line 350 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isColumnIMatrixOne"

sidl_bool
impl_Ordering_IntOrderTest_isColumnIMatrixOne(
  /* in */ struct sidl_int__array* A)
{
#line 341 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixOne) */
  return sidl_int__array_isColumnOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixOne) */
#line 369 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isRowIMatrixOne"

sidl_bool
impl_Ordering_IntOrderTest_isRowIMatrixOne(
  /* in */ struct sidl_int__array* A)
{
#line 358 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixOne) */
  return sidl_int__array_isRowOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixOne) */
#line 388 "Ordering_IntOrderTest_Impl.c"
}

/*
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isIMatrixTwo"

sidl_bool
impl_Ordering_IntOrderTest_isIMatrixTwo(
  /* in */ struct sidl_int__array* A)
{
#line 375 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixTwo) */
  return isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixTwo) */
#line 407 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isColumnIMatrixTwo"

sidl_bool
impl_Ordering_IntOrderTest_isColumnIMatrixTwo(
  /* in */ struct sidl_int__array* A)
{
#line 392 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixTwo) */
  return sidl_int__array_isColumnOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixTwo) */
#line 426 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isRowIMatrixTwo"

sidl_bool
impl_Ordering_IntOrderTest_isRowIMatrixTwo(
  /* in */ struct sidl_int__array* A)
{
#line 409 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixTwo) */
  return sidl_int__array_isRowOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixTwo) */
#line 445 "Ordering_IntOrderTest_Impl.c"
}

/*
 *  Return <code>true</code> iff the implementation sees
 *  an incoming array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isIMatrixFour"

sidl_bool
impl_Ordering_IntOrderTest_isIMatrixFour(
  /* in */ struct sidl_int__array* A)
{
#line 426 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isIMatrixFour) */
  return isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isIMatrixFour) */
#line 464 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming column-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isColumnIMatrixFour"

sidl_bool
impl_Ordering_IntOrderTest_isColumnIMatrixFour(
  /* in */ struct sidl_int__array* A)
{
#line 443 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isColumnIMatrixFour) */
  return sidl_int__array_isColumnOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isColumnIMatrixFour) */
#line 483 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation sees
 * an incoming row-major array satisfying condition I.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isRowIMatrixFour"

sidl_bool
impl_Ordering_IntOrderTest_isRowIMatrixFour(
  /* in */ struct sidl_int__array* A)
{
#line 460 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isRowIMatrixFour) */
  return sidl_int__array_isRowOrder(A) && isIMatrix(A);
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isRowIMatrixFour) */
#line 502 "Ordering_IntOrderTest_Impl.c"
}

/*
 * Return <code>true</code> iff the implementation of slice
 * and smart copy is correct.
 */

#undef __FUNC__
#define __FUNC__ "impl_Ordering_IntOrderTest_isSliceWorking"

sidl_bool
impl_Ordering_IntOrderTest_isSliceWorking(
  /* in */ sidl_bool useCreateCol)
{
#line 477 "../../../../babel/regression/ordering/libC/Ordering_IntOrderTest_Impl.c"
  /* DO-NOT-DELETE splicer.begin(Ordering.IntOrderTest.isSliceWorking) */
  sidl_bool res = TRUE;
  const int32_t maxDim = 16;
  const int32_t halfDim = maxDim >> 1;
  struct sidl_int__array *A=NULL, *B=NULL;
  int32_t ind[2];
  int32_t stride[2] = {2, 2};
  int32_t numElem[2];
  int32_t newIndex[2];
  numElem[0] = numElem[1] = halfDim;
  if (useCreateCol) {
    A = Ordering_IntOrderTest_makeColumnIMatrix(maxDim,FALSE);
  }
  else {
    A = Ordering_IntOrderTest_makeRowIMatrix(maxDim,FALSE);
  }
  B = sidl_int__array_slice(A, 2, numElem, NULL, stride, NULL);
  if (!(B && sidl_int__array_dimen(B) == 2)) {
    res = FALSE;
    goto cleanup;
  }
  for(ind[1] = newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((sidlArrayElem2(B, newIndex[0], newIndex[1]) != iFunc(ind,2)) ||
          (sidlArrayAddr2(B, newIndex[0], newIndex[1]) !=
           sidlArrayAddr2(A, ind[0], ind[1]))) {
        res = FALSE;
        goto cleanup;
      }
    }
  }

  sidl_int__array_deleteRef(B);
  ind[0] = ind[1] = 1;
  newIndex[0] = newIndex[1] = 0;
  B = sidl_int__array_slice(A, 2, numElem, ind, stride, newIndex);
  if (!(B && sidl_int__array_dimen(B) == 2)) {
    res = FALSE;
    goto cleanup;
  }
  for(newIndex[1] = 0; newIndex[1] < halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 0; newIndex[0] < halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((sidlArrayElem2(B, newIndex[0], newIndex[1]) != iFunc(ind,2)) ||
          (sidlArrayAddr2(B, newIndex[0], newIndex[1]) !=
           sidlArrayAddr2(A, ind[0], ind[1]))) {
        res = FALSE;
        goto cleanup;
      }
    }
  }

  sidl_int__array_deleteRef(B);
  ind[0] = ind[1] = 1;
  newIndex[1] = newIndex[0] = 1;
  B = sidl_int__array_slice(A, 2, numElem, ind, stride, newIndex);
  if (!(B && sidl_int__array_dimen(B) == 2)) {
    res = FALSE;
    goto cleanup;
  }
  for(newIndex[1] = 1; newIndex[1] <= halfDim; 
      ++newIndex[1], ind[1] += 2) {
    for(ind[0] = 1, newIndex[0] = 1; newIndex[0] <= halfDim;
        ++newIndex[0], ind[0] += 2) {
      if ((sidlArrayElem2(B, newIndex[0], newIndex[1]) != iFunc(ind,2)) ||
          (sidlArrayAddr2(B, newIndex[0], newIndex[1]) != 
           sidlArrayAddr2(A, ind[0], ind[1]))){
        res = FALSE;
        goto cleanup;
      }
    }
  }

  sidl_int__array_deleteRef(B);
  B = NULL;
  numElem[0] = 0;
  numElem[1] = maxDim;
  B = sidl_int__array_slice(A, 1, numElem, NULL, NULL, NULL);
  if (!(B && sidl_int__array_dimen(B) == 1)) {
    res = FALSE;
    goto cleanup;
  }
  ind[0] = newIndex[0] = 0;
  for(ind[1] = newIndex[1] = 0; newIndex[1] < maxDim; 
      ++newIndex[1], ++ind[1]) {
    if (sidlArrayAddr1(B, newIndex[1]) != 
        sidlArrayAddr2(A, ind[0], ind[1])) {
      res = FALSE;
      goto cleanup;
    }
  }
  
  sidl_int__array_deleteRef(B);
  B = NULL;
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 8;
  newIndex[0] = newIndex[1] = 0;
  B = sidl_int__array_slice(A, 1, numElem, ind, NULL, newIndex);
  if (!(B && (sidl_int__array_dimen(B) == 1))) {
    res = FALSE;
    goto cleanup;
  }
  for(ind[0] = newIndex[0] = 0; newIndex[0] < maxDim; 
      ++newIndex[0], ++ind[0]) {
    if (sidlArrayAddr1(B, newIndex[0]) != 
        sidlArrayAddr2(A, ind[0], ind[1])) {
      res = FALSE;
      goto cleanup;
    }
  }
  
  sidl_int__array_deleteRef(B);
  B = NULL;
  numElem[0] = maxDim;
  numElem[1] = 0;
  ind[0] = 0;
  ind[1] = 0;
  B = sidl_int__array_slice(A, 1, numElem, ind, NULL, NULL);
  if (!(B && (sidl_int__array_dimen(B) == 1))) {
    res = FALSE;
    goto cleanup;
  }
  if (!(Ordering_IntOrderTest_isIMatrixOne(B) &&
        Ordering_IntOrderTest_isColumnIMatrixOne(B) &&
        Ordering_IntOrderTest_isRowIMatrixOne(B))) {
    res = FALSE;
    goto cleanup;
  }
        
  
 cleanup:
  if (B) sidl_int__array_deleteRef(B);
  if (A) sidl_int__array_deleteRef(A);
  return res;
  /* DO-NOT-DELETE splicer.end(Ordering.IntOrderTest.isSliceWorking) */
#line 658 "Ordering_IntOrderTest_Impl.c"
}
