!
! File:       overloadtest.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Revision:   @(#) $Revision: 4434 $
! Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description:Simple F90 overload test client
!
!

#include "Overload_AClass_fAbbrev.h"
#include "Overload_AnException_fAbbrev.h"
#include "Overload_BClass_fAbbrev.h"
#include "Overload_ParentTest_fAbbrev.h"
#include "Overload_Test_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
#include "synch_ResultType_fAbbrev.h"

subroutine starttest(number)
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call startPart(tracker, number)
  call deleteRef(tracker)
end subroutine starttest

subroutine reporttest(test, number)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  logical                        :: test
  call getInstance(tracker)
  if (test) then
     call endPart(tracker, number, PASS)
  else
     call endPart(tracker, number, FAIL)
  endif
  call deleteRef(tracker)
  number = number + 1
end subroutine reporttest

subroutine testnone(t, test)
  use Overload_Test
  implicit none
  integer (selected_int_kind(9))  :: test
  type(Overload_Test_t) :: t
  integer (selected_int_kind(9))  :: retval

  retval = 0

  call starttest(test)
  call getValue(t, retval)
  call reporttest(retval .eq. 1, test)
end subroutine testnone

subroutine testone(t, test)
  use Overload_Test
  use Overload_AnException
  use Overload_AClass
  use Overload_BClass
  implicit none
  character*80 s1, sretval
  integer (selected_int_kind(9))       :: test
  type(Overload_Test_t)                :: t
  type(Overload_AnException_t)         :: ae
  type(Overload_AClass_t)              :: ac
  type(Overload_BClass_t)              :: bc
  integer (selected_int_kind(9))       :: i1, iretval
  real (selected_real_kind(15,307))    :: d1, dretval
  real (selected_real_kind(6,37))      :: f1, fretval
  logical                              :: b1, bretval
  complex (selected_real_kind(6,37))   :: fc, fcretval
  complex (selected_real_kind(15,307)) :: dc, dcretval

  b1 = .true.
  d1 = 1.0d0
  f1 = 1.0
  i1 = 1
  fc = (1.1, 1.1)
  dc = (2.2d0, 2.2d0)
  s1 = 'AnException'

  call starttest(test)
  call getValue(t, b1, bretval)
  call reporttest(bretval .eqv. b1, test)
  call starttest(test)
  call getValue(t, d1, dretval)
  call reporttest(dretval .eq. d1, test)
  call starttest(test)
  call getValue(t, dc, dcretval)
  call reporttest(dcretval .eq. dc, test)
  call starttest(test)
  call getValue(t, f1, fretval)
  call reporttest(fretval .eq. f1, test)
  call starttest(test)
  call getValue(t, fc, fcretval)
  call reporttest(fcretval .eq. fc, test)
  call starttest(test)
  call getValue(t, i1, iretval)
  call reporttest(iretval .eq. i1, test)
  call starttest(test)
  call getValue(t, s1, sretval)
  call reporttest(sretval .eq. s1, test)

  call new(ae)
  call starttest(test)
  call getValue(t, ae, sretval)
  call reporttest(sretval .eq. s1, test)
  call deleteRef(ae)
  call new(ac)
  call starttest(test)
  call getValue(t, ac, iretval)
  call reporttest(iretval .eq. 2, test)
  call deleteRef(ac)
  call new(bc)
  call starttest(test)
  call getValue(t, bc, iretval)
  call reporttest(iretval .eq. 2, test)
  call deleteRef(bc)
end subroutine testone

subroutine testtwo(t, test)
  use Overload_Test
  implicit none
  integer (selected_int_kind(9))    :: test
  type(Overload_Test_t)             :: t
  integer (selected_int_kind(9))    :: i1, iretval
  real (selected_real_kind(15,307)) :: d1, dretval, did
  real (selected_real_kind(6,37))   :: f1

  d1 = 1.0d0
  i1 = 1
  did =2.0d0

  call starttest(test)
  call getValue(t, d1, i1, dretval)
  call reporttest(dretval .eq. did, test)
  call starttest(test)
  call getValue(t, i1, d1, dretval)
  call reporttest(dretval .eq. did, test)
end subroutine testtwo

subroutine testthree(t, test)
  use Overload_Test
  implicit none
  type(Overload_Test_t)             :: t
  integer (selected_int_kind(9))    :: i1
  integer (selected_int_kind(9))    :: test
  real (selected_real_kind(15,307)) :: d1, difd, dretval
  real (selected_real_kind(6,37))   :: f1

  d1 = 1.0d0
  f1 = 1.0
  i1 = 1
  difd = 3.0d0

  call starttest(test)
  call getValue(t, d1, i1, f1, dretval)
  call reporttest(dretval .eq. difd, test)
  call starttest(test)
  call getValue(t, i1, d1, f1, dretval)
  call reporttest(dretval .eq. difd, test)
  call starttest(test)
  call getValue(t, d1, f1, i1, dretval)
  call reporttest(dretval .eq.  difd, test)
  call starttest(test)
  call getValue(t, i1, f1, d1, dretval)
  call reporttest(dretval .eq. difd, test)
  call starttest(test)
  call getValue(t, f1, d1, i1, dretval)
  call reporttest(dretval .eq. difd, test)
  call starttest(test)
  call getValue(t, f1, i1, d1, dretval)
  call reporttest(dretval .eq. difd, test)
end subroutine testthree


program overloadtest
  use Overload_Test
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9))  :: test
  type(Overload_Test_t) :: t
  type(synch_RegOut_t) :: tracker

  call getInstance(tracker)
  call setExpectations(tracker, 19)
  call new(t)

  test = 1

  call writeComment(tracker, 'No Argument test             ')
  call testnone(t, test)
  call writeComment(tracker, 'Single Argument tests        ')
  call testone(t, test)
  call writeComment(tracker, 'Double Argument tests        ')
  call testtwo(t, test)
  call writeComment(tracker, 'Triple Argument tests        ')
  call testthree(t, test)

  call deleteRef(t)

  call close(tracker)
  call deleteRef(tracker)
end program overloadtest
