/*
 * File:          MergeSort_Impl.java
 * Symbol:        sort.MergeSort-v0.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for sort.MergeSort
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

package sort;

import sort.SortingAlgorithm;
import sidl.ClassInfo;
import sort.Comparator;
import sidl.BaseInterface;
import sort.Counter;
import sort.Container;
import sidl.BaseClass;

// DO-NOT-DELETE splicer.begin(sort.MergeSort._imports)
// Put additional imports here...
// DO-NOT-DELETE splicer.end(sort.MergeSort._imports)

/**
 * Symbol "sort.MergeSort" (version 0.1)
 * 
 * Merge sort
 */
public class MergeSort_Impl extends MergeSort
{

  // DO-NOT-DELETE splicer.begin(sort.MergeSort._data)
  static void
    mergeLists(sort.Container  elems,
               sort.Comparator comp,
               sort.Counter    cmp,
               sort.Counter    swp,
               int             start,
               int             mid,
               int             end)
{
  int j;
  while ((start < mid) && (mid < end)) {
    cmp.inc();
    if (elems.compare(start, mid, comp) > 0) {
      /* move first element of upper list into place */
      for(j = mid;j > start; --j) {
        swp.inc();
        elems.swap(j, j - 1);
      }
      ++mid;
    }
    ++start;
  }
}
  /**
 * end is one past the end
 */
  static void
    mergeSort(sort.Container  elems,
              sort.Comparator comp,
              sort.Counter    cmp,
              sort.Counter    swp,
              int             start,
              int             end)
{
  if ((end - start) > 1) {
    int mid = (start + end) >> 1;
    mergeSort(elems, comp, cmp, swp, start, mid);
    mergeSort(elems, comp, cmp, swp, mid, end);
    mergeLists(elems, comp, cmp, swp, start, mid, end);
  }
}

  // DO-NOT-DELETE splicer.end(sort.MergeSort._data)

  static { 
  // DO-NOT-DELETE splicer.begin(sort.MergeSort._load)
  // Put load function implementation here...
  // DO-NOT-DELETE splicer.end(sort.MergeSort._load)
  }

  /**
   * User defined constructor
   */
  public MergeSort_Impl(long IORpointer){
    super(IORpointer);
    // DO-NOT-DELETE splicer.begin(sort.MergeSort.MergeSort)
    // add construction details here
    // DO-NOT-DELETE splicer.end(sort.MergeSort.MergeSort)
  }

  /**
   * User defined destructing method
   */
  public void finalize() throws Throwable{
    super.finalize();
    // DO-NOT-DELETE splicer.begin(sort.MergeSort._dtor)
    // add destruction details here
    // DO-NOT-DELETE splicer.end(sort.MergeSort._dtor)
  }

  // user defined static methods: (none)

  // user defined non-static methods:
  /**
   * Sort elements using Merge Sort.
   */
  public void sort_Impl (
    /*in*/ sort.Container elems,
    /*in*/ sort.Comparator comp ) 
  {
    // DO-NOT-DELETE splicer.begin(sort.MergeSort.sort)
    // insert implementation here
    int num = elems.getLength();
    sort.Counter cmp = getCompareCounter();
    sort.Counter swp = getSwapCounter();
    mergeSort(elems, comp, cmp, swp, 0, num);
    return ;
    // DO-NOT-DELETE splicer.end(sort.MergeSort.sort)
  }

  /**
   * Return merge sort.
   */
  public java.lang.String getName_Impl () 
  {
    // DO-NOT-DELETE splicer.begin(sort.MergeSort.getName)
    // insert implementation here
    return new java.lang.String("Merge sort");
    // DO-NOT-DELETE splicer.end(sort.MergeSort.getName)
  }


  // DO-NOT-DELETE splicer.begin(sort.MergeSort._misc)
  // Put miscellaneous code here
  // DO-NOT-DELETE splicer.end(sort.MergeSort._misc)

} // end class MergeSort

