c
c     File:       sorttest.f
c     Copyright:  (c) 2002 The Regents of the University of California
c     Revision:   @(#) $Revision: 4434 $
c     Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
c     Description:Exercise the FORTRAN interface for sorting
c
c
      subroutine starttest(number)
      implicit none
      integer*4 number
      integer*8 tracker
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_startPart_f(tracker, number)
      call synch_RegOut_deleteRef_f(tracker)
      end

      subroutine reporttest(test, number)
      implicit none
      integer*8 tracker
      integer*4 number
      logical test
      call synch_RegOut_getInstance_f(tracker)
      if (test) then
         call synch_RegOut_endPart_f(tracker, number, 0)
      else
         call synch_RegOut_endPart_f(tracker, number, 1)
      endif
      call synch_RegOut_deleteRef_f(tracker)
      number = number + 1
      end

      subroutine testsort(test)
      implicit none
      integer*8 algs, merge, quick, heap, alg
      integer*4 test
      logical retval

      call sort_SortingAlgorithm__array_create1d_f(3, algs)
      call starttest(test)
      call sort_MergeSort__create_f(merge)
      call reporttest(merge .ne. 0, test)
      call starttest(test)
      call sort_QuickSort__create_f(quick)
      call reporttest(quick .ne. 0, test)
      call starttest(test)
      call sort_HeapSort__create_f(heap)
      call reporttest(heap .ne. 0, test)

      call sort_SortingAlgorithm__cast_f(merge, alg)
      call sort_SortingAlgorithm__array_set1_f(algs, 0, alg)
      call sort_SortingAlgorithm__cast_f(heap, alg)
      call sort_SortingAlgorithm__array_set1_f(algs, 1, alg)
      call sort_SortingAlgorithm__cast_f(quick, alg)
      call sort_SortingAlgorithm__array_set1_f(algs, 2, alg)
c     remove extraneous references
      call sort_MergeSort_deleteRef_f(merge)
      call sort_QuickSort_deleteRef_f(quick)
      call sort_HeapSort_deleteRef_f(heap)

      call starttest(test)
      call sort_SortTest_stressTest_f(algs, retval)
      call reporttest(retval, test)
      call sort_SortingAlgorithm__array_deleteRef_f(algs)

      end

      program sorttest
      implicit none
      integer*4 test
      integer*8 tracker
      test = 1
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_setExpectations_f(tracker, 4)
      call synch_RegOut_writeComment_f(tracker,
     $      'Sort tests')
      call testsort(test)
      call synch_RegOut_close_f(tracker)
      call synch_RegOut_deleteRef_f(tracker)
      end
