
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Strings.h"
#include "synch.h"

#define MYASSERT( AAA ) \
  synch_RegOut_startPart(tracker, ++part_no); \
  synch_RegOut_writeComment(tracker, #AAA); \
  if ( AAA ) result = synch_ResultType_PASS; \
  else result = synch_ResultType_FAIL;  \
  synch_RegOut_endPart(tracker, part_no, result);

int main(int argc, char **argv) { 
  enum synch_ResultType__enum result = synch_ResultType_PASS; 
  int part_no = 0;
  Strings_Cstring obj;
  synch_RegOut tracker = synch_RegOut__create();
  synch_RegOut_setExpectations(tracker, -1);
  
  { 
    char* out;
    char* temp;
    char* inout = (char*)(malloc(sizeof(char)*6));
    strcpy(inout,"Three");
    MYASSERT(obj = Strings_Cstring__create());
 
    MYASSERT((temp =  Strings_Cstring_returnback( obj, TRUE )) &&
             !strcmp(temp, "Three"));
    free(temp);
    MYASSERT( (!(temp = Strings_Cstring_returnback(obj, FALSE))) || 
               !strcmp(temp, ""));
    if (temp) free(temp);
    MYASSERT( Strings_Cstring_passin( obj, "Three" ) == TRUE );
    MYASSERT( Strings_Cstring_passin( obj, NULL ) == FALSE );
    MYASSERT( Strings_Cstring_passout( obj, TRUE, &out ) == TRUE && !(strcmp(out, "Three")));
    free(out);
    out = NULL;
    MYASSERT( Strings_Cstring_passout( obj, FALSE, &out ) == FALSE && 
              !(out && strcmp(out, "")));
    if (out) free(out);
    MYASSERT( Strings_Cstring_passinout( obj, &inout ) == TRUE && !(strcmp(inout,"threes")));
    MYASSERT( (temp=Strings_Cstring_passeverywhere( obj, "Three", &out,
                                                   &inout )) &&
              !(strcmp(temp, "Three"))  &&
	      !(strcmp(out, "Three")) && !(strcmp(inout, "Three")) );
    MYASSERT( Strings_Cstring_mixedarguments( obj, "Test", 'z', "Test", 'z')
              );
    MYASSERT( !Strings_Cstring_mixedarguments( obj, "Not", 'A', "Equal", 'a')
             );

    free(out);
    free(temp);
    free(inout);
    inout = NULL;
    MYASSERT( (Strings_Cstring_passinout( obj, &inout) == FALSE));
    if (inout) free(inout);
    
    Strings_Cstring_deleteRef( obj );
  }

  synch_RegOut_close(tracker);
  synch_RegOut_deleteRef(tracker);
  return 0;
}
