!
! File:       stringstest.F90
! Copyright:  (c) 2002 The Regents of the University of California
! Revision:   @(#) $Revision: 4434 $
! Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
! Description:Exercise the FORTRAN interface
!

#include "Strings_Cstring_fAbbrev.h"
#include "synch_RegOut_fAbbrev.h"
#include "synch_ResultType_fAbbrev.h"

subroutine starttest(number)
  use synch_RegOut
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  call getInstance(tracker)
  call startPart(tracker, number)
  call deleteRef(tracker)
end subroutine starttest

subroutine reporttest(test, number)
  use synch_RegOut
  use synch_ResultType
  implicit none
  integer (selected_int_kind(9)) :: number
  type(synch_RegOut_t) :: tracker
  logical                        :: test
  call getInstance(tracker)
  if (test) then
     call endPart(tracker, number, PASS)
  else
     call endPart(tracker, number, FAIL)
  endif
  call deleteRef(tracker)
  number = number + 1
end subroutine reporttest

subroutine teststring(test)
  use Strings_Cstring
  implicit none
  type(Strings_Cstring_t)         :: obj
  integer (selected_int_kind(9))  :: test
  logical                         :: retval
  character (len=80)              :: in, inout, out, sreturn
  character (len=1)               :: ch1, ch2
  call new(obj)
  sreturn = 'Not three'
  call starttest(test)
  call returnback(obj, .true., sreturn)
  call reporttest(sreturn .eq. 'Three', test)
  retval = .false.
  call starttest(test)
  call passin(obj, 'Three', retval)
  call reporttest(retval, test)
  in = 'Three'
  call starttest(test)
  call passin(obj, in, retval)
  call reporttest(retval, test)
  call starttest(test)
  call passin(obj, 'Four', retval)
  call reporttest(.not. retval, test)
  out = 'Not three'
  call starttest(test)
  call passout(obj, .true., out, retval)
  call reporttest(retval .and. out .eq. 'Three', test)
  inout = 'Three'
  call starttest(test)
  call passinout(obj, inout, retval)
  call reporttest(retval .and. inout .eq. 'threes', test)
  call starttest(test)
  call passeverywhere(obj, 'Three', out, inout, sreturn)
  call reporttest(sreturn .eq. 'Three' .and. out .eq. 'Three' .and. &
       inout .eq. 'Three', test)
  call starttest(test)
  call mixedarguments(obj, 'Test', 'z', 'Test', 'z', retval)
  call reporttest(retval, test)
  call starttest(test)
  call mixedarguments(obj, 'Not', 'A', 'Equal', 'a', retval)
  call reporttest(.not. retval, test)
  ch1 = 'z'
  ch2 = 'z'
  call starttest(test)
  call mixedarguments(obj, 'Test', ch1, 'Test', ch1, retval)
  call reporttest(retval, test)
  call starttest(test)
  call mixedarguments(obj, 'Test', ch1, 'Test', ch2, retval)
  call reporttest(retval, test)
  ch2 = 'A'
  call starttest(test)
  call mixedarguments(obj, 'Not', ch1, 'Equal', ch2, retval)
  call reporttest(.not. retval, test)
  call deleteRef(obj)

end subroutine teststring

program stringstest
  use synch_RegOut
  integer (selected_int_kind(9)) :: test
  type(synch_RegOut_t) :: tracker
  test = 1
  call getInstance(tracker)
  call setExpectations(tracker, 12)
  call writeComment(tracker, 'String tests')
  call teststring(test)
  call close(tracker)
  call deleteRef(tracker)
end program stringstest
