/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf;

import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFEngine;
import com.ibm.bsf.BSFException;
import com.ibm.cs.util.CodeBuffer;
import com.ibm.cs.util.ObjectRegistry;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class BSFManager {
    protected static Hashtable registeredEngines = new Hashtable();
    protected static Hashtable extn2Lang = new Hashtable();
    protected Hashtable loadedEngines = new Hashtable();
    protected ObjectRegistry objectRegistry = new ObjectRegistry();
    protected PropertyChangeSupport pcs;
    protected ClassLoader classLoader = this.getClass().getClassLoader();
    protected String tempDir = ".";
    protected String classPath;
    protected PrintStream debugStream = System.err;
    protected Vector declaredBeans = new Vector();
    boolean debug = false;

    public static void registerScriptingEngine(String string, String string2, String[] stringArray) {
        registeredEngines.put(string, string2);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                extn2Lang.put(stringArray[n], string);
                ++n;
            }
        }
    }

    public static boolean isLanguageRegistered(String string) {
        return registeredEngines.get(string) != null;
    }

    public static String getLangFromFilename(String string) throws BSFException {
        String string2;
        String string3;
        int n = string.lastIndexOf(".");
        if (n != -1 && (string3 = (String)extn2Lang.get(string2 = string.substring(n + 1))) != null) {
            return string3;
        }
        throw new BSFException(BSFException.REASON_OTHER_ERROR, "file extension missing or unknown: unable to determine language for '" + string + "'");
    }

    public BSFManager() {
        this.pcs = new PropertyChangeSupport(this);
    }

    public void setObjectRegistry(ObjectRegistry objectRegistry) {
        this.objectRegistry = objectRegistry;
    }

    public ObjectRegistry getObjectRegistry() {
        return this.objectRegistry;
    }

    public void setDebugStream(PrintStream printStream) {
        this.pcs.firePropertyChange("debugStream", this.debugStream, printStream);
        this.debugStream = printStream;
    }

    public PrintStream getDebugStream() {
        return this.debugStream;
    }

    public void setDebug(boolean bl) {
        this.pcs.firePropertyChange("debug", new Boolean(this.debug), new Boolean(bl));
        this.debug = bl;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setClassPath(String string) {
        this.pcs.firePropertyChange("classPath", this.classPath, string);
        this.classPath = string;
    }

    public String getClassPath() {
        block2: {
            if (this.classPath != null) break block2;
            try {
                this.classPath = System.getProperty("java.class.path");
            }
            catch (Throwable throwable) {}
        }
        return this.classPath;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.pcs.firePropertyChange("classLoader", this.classLoader, classLoader);
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setTempDir(String string) {
        this.pcs.firePropertyChange("tempDir", this.tempDir, string);
        this.tempDir = string;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public BSFEngine loadScriptingEngine(String string) throws BSFException {
        BSFEngine bSFEngine = (BSFEngine)this.loadedEngines.get(string);
        if (bSFEngine != null) {
            return bSFEngine;
        }
        String string2 = (String)registeredEngines.get(string);
        if (string2 == null) {
            throw new BSFException(BSFException.REASON_UNKNOWN_LANGUAGE, "unsupported language: " + string);
        }
        try {
            Class<?> clazz = this.classLoader == null ? Class.forName(string2) : this.classLoader.loadClass(string2);
            bSFEngine = (BSFEngine)clazz.newInstance();
            bSFEngine.initialize(this, string, this.declaredBeans);
            this.loadedEngines.put(string, bSFEngine);
            this.pcs.addPropertyChangeListener(bSFEngine);
            return bSFEngine;
        }
        catch (Throwable throwable) {
            throw new BSFException(BSFException.REASON_OTHER_ERROR, "unable to load language: " + string, throwable);
        }
    }

    public void registerBean(String string, Object object) {
        this.objectRegistry.register(string, object);
    }

    public void unregisterBean(String string) {
        this.objectRegistry.unregister(string);
    }

    public Object lookupBean(String string) {
        try {
            return this.objectRegistry.lookup(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public void declareBean(String string, Object object, Class clazz) throws BSFException {
        this.registerBean(string, object);
        BSFDeclaredBean bSFDeclaredBean = new BSFDeclaredBean(string, object, clazz);
        this.declaredBeans.addElement(bSFDeclaredBean);
        Enumeration enumeration = this.loadedEngines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            bSFEngine.declareBean(bSFDeclaredBean);
        }
    }

    public void undeclareBean(String string) throws BSFException {
        this.unregisterBean(string);
        BSFDeclaredBean bSFDeclaredBean = null;
        int n = 0;
        while (n < this.declaredBeans.size()) {
            bSFDeclaredBean = (BSFDeclaredBean)this.declaredBeans.elementAt(n);
            if (bSFDeclaredBean.name.equals(string)) break;
            ++n;
        }
        if (bSFDeclaredBean != null) {
            this.declaredBeans.removeElement(bSFDeclaredBean);
            Enumeration enumeration = this.loadedEngines.elements();
            while (enumeration.hasMoreElements()) {
                BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
                bSFEngine.undeclareBean(bSFDeclaredBean);
            }
        }
    }

    public void exec(String string, String string2, int n, int n2, Object object) throws BSFException {
        BSFEngine bSFEngine = this.loadScriptingEngine(string);
        bSFEngine.exec(string2, n, n2, object);
    }

    public Object eval(String string, String string2, int n, int n2, Object object) throws BSFException {
        BSFEngine bSFEngine = this.loadScriptingEngine(string);
        return bSFEngine.eval(string2, n, n2, object);
    }

    public void compileExpr(String string, String string2, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        BSFEngine bSFEngine = this.loadScriptingEngine(string);
        bSFEngine.compileExpr(string2, n, n2, object, codeBuffer);
    }

    public void compileScript(String string, String string2, int n, int n2, Object object, CodeBuffer codeBuffer) throws BSFException {
        BSFEngine bSFEngine = this.loadScriptingEngine(string);
        bSFEngine.compileScript(string2, n, n2, object, codeBuffer);
    }

    static {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.bsf.Languages");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = resourceBundle.getString(string);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string4, "|");
                String[] stringArray = new String[stringTokenizer2.countTokens()];
                int n = 0;
                while (stringTokenizer2.hasMoreTokens()) {
                    stringArray[n] = stringTokenizer2.nextToken().trim();
                    ++n;
                }
                BSFManager.registerScriptingEngine(string, string3, stringArray);
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            System.err.println("Syntax error in Languages resource bundle");
            return;
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.err.println("Initialization error: " + missingResourceException.toString());
            return;
        }
    }
}

