/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.AreaTree;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.Box;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.InlineArea;
import org.apache.fop.layout.InlineSpace;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.LinkSet;
import org.apache.fop.layout.LinkedRectangle;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.RuleArea;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPathPaint;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.pdf.FontSetup;
import org.apache.fop.svg.LineGraphic;
import org.apache.fop.svg.RectGraphic;
import org.apache.fop.svg.SVGArea;
import org.apache.fop.svg.TextGraphic;

public class PDFRenderer
implements Renderer {
    protected PDFDocument pdfDoc = new PDFDocument();
    protected PDFResources pdfResources;
    PDFStream currentStream;
    PDFAnnotList currentAnnotList;
    PDFPage currentPage;
    protected String currentFontName;
    protected int currentFontSize;
    protected PDFPathPaint currentStroke = null;
    protected PDFPathPaint currentFill = null;
    protected float currentRed = 0.0f;
    protected float currentGreen = 0.0f;
    protected float currentBlue = 0.0f;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;

    protected void addLine(int n, int n2, int n3, int n4, int n5, PDFPathPaint pDFPathPaint) {
        this.currentStream.add(String.valueOf(pDFPathPaint.getColorSpaceOut(false)) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " m " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " l " + (float)n5 / 1000.0f + " w S\n" + "0 0 0 RG\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint) {
        this.currentStream.add(String.valueOf(pDFPathPaint.getColorSpaceOut(false)) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re S\n" + "0 0 0 RG\n");
    }

    protected void addRect(int n, int n2, int n3, int n4, PDFPathPaint pDFPathPaint, PDFPathPaint pDFPathPaint2) {
        this.currentStream.add(String.valueOf(pDFPathPaint2.getColorSpaceOut(true)) + pDFPathPaint.getColorSpaceOut(false) + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re S\n" + (float)n / 1000.0f + " " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " " + (float)n4 / 1000.0f + " re f\n" + "0 0 0 RG 0 0 0 rg\n");
    }

    private void doFrame(Area area) {
        int n = this.currentAreaContainerXPosition;
        int n2 = area.getContentWidth();
        if (area instanceof BlockArea) {
            n += ((BlockArea)area).getStartIndent();
        }
        int n3 = area.getContentHeight();
        int n4 = this.currentYPosition;
        ColorType colorType = area.getBackgroundColor();
        n -= area.getPaddingLeft();
        n4 += area.getPaddingTop();
        n2 = n2 + area.getPaddingLeft() + area.getPaddingRight();
        n3 = n3 + area.getPaddingTop() + area.getPaddingBottom();
        if (colorType != null && colorType.alpha() == 0.0f) {
            this.addRect(n, n4, n2, -n3, new PDFColor(colorType), new PDFColor(colorType));
        }
        n -= area.borderWidthLeft;
        n4 += area.borderWidthTop;
        n2 = n2 + area.borderWidthLeft + area.borderWidthRight;
        n3 = n3 + area.borderWidthTop + area.borderWidthBottom;
        if (area.borderWidthTop != 0) {
            this.addLine(n, n4, n + n2, n4, area.borderWidthTop, new PDFColor(area.borderColorTop));
        }
        if (area.borderWidthLeft != 0) {
            this.addLine(n, n4, n, n4 - n3, area.borderWidthLeft, new PDFColor(area.borderColorLeft));
        }
        if (area.borderWidthRight != 0) {
            this.addLine(n + n2, n4, n + n2, n4 - n3, area.borderWidthRight, new PDFColor(area.borderColorRight));
        }
        if (area.borderWidthBottom != 0) {
            this.addLine(n, n4 - n3, n + n2, n4 - n3, area.borderWidthBottom, new PDFColor(area.borderColorBottom));
        }
    }

    public void render(AreaTree areaTree, PrintWriter printWriter) throws IOException {
        System.err.println("rendering areas to PDF");
        this.pdfResources = this.pdfDoc.getResources();
        Enumeration enumeration = areaTree.getPages().elements();
        while (enumeration.hasMoreElements()) {
            this.renderPage((Page)enumeration.nextElement());
        }
        System.err.println("writing out PDF");
        this.pdfDoc.output(printWriter);
    }

    public void renderAreaContainer(AreaContainer areaContainer) {
        int n = this.currentYPosition;
        int n2 = this.currentAreaContainerXPosition;
        if (areaContainer.getPosition() == 3) {
            this.currentYPosition = areaContainer.getYPosition() - 2 * areaContainer.getPaddingTop() - 2 * areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition = areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 2) {
            this.currentYPosition -= areaContainer.getYPosition();
            this.currentAreaContainerXPosition += areaContainer.getXPosition();
        } else if (areaContainer.getPosition() == 1) {
            this.currentYPosition -= areaContainer.getPaddingTop() + areaContainer.borderWidthTop;
            this.currentAreaContainerXPosition += areaContainer.getPaddingLeft() + areaContainer.borderWidthLeft;
        }
        this.doFrame(areaContainer);
        Enumeration enumeration = areaContainer.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        if (areaContainer.getPosition() != 1) {
            this.currentYPosition = n;
            this.currentAreaContainerXPosition = n2;
        } else {
            this.currentYPosition -= areaContainer.getHeight();
        }
    }

    public void renderBlockArea(BlockArea blockArea) {
        this.doFrame(blockArea);
        Enumeration enumeration = blockArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
    }

    public void renderDisplaySpace(DisplaySpace displaySpace) {
        int n = displaySpace.getSize();
        this.currentYPosition -= n;
    }

    public void renderImageArea(ImageArea imageArea) {
        int n = this.currentAreaContainerXPosition + imageArea.getXOffset();
        int n2 = this.currentYPosition;
        int n3 = imageArea.getContentWidth();
        int n4 = imageArea.getHeight();
        this.currentYPosition -= n4;
        FopImage fopImage = imageArea.getImage();
        int n5 = this.pdfDoc.addImage(fopImage);
        this.currentStream.add("ET\nq\n" + (float)fopImage.getWidth() / 1000.0f + " 0 0 " + (float)fopImage.getHeight() / 1000.0f + " " + (float)(n + fopImage.getX()) / 1000.0f + " " + (float)(n2 - n4 - fopImage.getY()) / 1000.0f + " cm\n" + "/Im" + n5 + " Do\nQ\nBT\n");
    }

    public void renderInlineArea(InlineArea inlineArea) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = inlineArea.getFontState().getFontName();
        int n = inlineArea.getFontState().getFontSize();
        PDFColor pDFColor = new PDFColor(inlineArea.getRed(), inlineArea.getGreen(), inlineArea.getBlue());
        if (!string.equals(this.currentFontName) || n != this.currentFontSize) {
            this.currentFontName = string;
            this.currentFontSize = n;
            stringBuffer = stringBuffer.append("/" + string + " " + n / 1000 + " Tf\n");
        }
        this.currentFill = pDFColor;
        stringBuffer = stringBuffer.append(this.currentFill.getColorSpaceOut(true));
        int n2 = this.currentXPosition;
        int n3 = this.currentYPosition;
        stringBuffer = stringBuffer.append("1 0 0 1 " + (float)n2 / 1000.0f + " " + (float)n3 / 1000.0f + " Tm (");
        String string2 = inlineArea.getText();
        int n4 = string2.length();
        int n5 = 0;
        while (n5 < n4) {
            char c = string2.charAt(n5);
            if (c > '\u007f') {
                stringBuffer = stringBuffer.append("\\");
                stringBuffer = stringBuffer.append(Integer.toOctalString(c));
            } else {
                switch (c) {
                    case '(': {
                        stringBuffer = stringBuffer.append("\\(");
                        break;
                    }
                    case ')': {
                        stringBuffer = stringBuffer.append("\\)");
                        break;
                    }
                    case '\\': {
                        stringBuffer = stringBuffer.append("\\\\");
                        break;
                    }
                    default: {
                        stringBuffer = stringBuffer.append(c);
                        break;
                    }
                }
            }
            ++n5;
        }
        stringBuffer = stringBuffer.append(") Tj\n");
        this.currentStream.add(stringBuffer.toString());
        this.currentXPosition += inlineArea.getContentWidth();
    }

    public void renderInlineSpace(InlineSpace inlineSpace) {
        this.currentXPosition += inlineSpace.getSize();
    }

    public void renderLineArea(LineArea lineArea) {
        int n = this.currentAreaContainerXPosition + lineArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = lineArea.getContentWidth();
        int n4 = lineArea.getHeight();
        this.currentYPosition -= lineArea.getPlacementOffset();
        this.currentXPosition = n;
        int n5 = this.currentYPosition;
        Enumeration enumeration = lineArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            Box box = (Box)enumeration.nextElement();
            box.render(this);
        }
        this.currentYPosition = n2 - n4;
    }

    public void renderPage(Page page) {
        this.currentStream = this.pdfDoc.makeStream();
        AreaContainer areaContainer = page.getBody();
        AreaContainer areaContainer2 = page.getBefore();
        AreaContainer areaContainer3 = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = 0;
        this.currentStream.add("BT\n");
        this.renderAreaContainer(areaContainer);
        if (areaContainer2 != null) {
            this.renderAreaContainer(areaContainer2);
        }
        if (areaContainer3 != null) {
            this.renderAreaContainer(areaContainer3);
        }
        this.currentStream.add("ET\n");
        this.currentPage = this.pdfDoc.makePage(this.pdfResources, this.currentStream, page.getWidth() / 1000, page.getHeight() / 1000);
        if (page.hasLinks()) {
            this.currentAnnotList = this.pdfDoc.makeAnnotList();
            this.currentPage.setAnnotList(this.currentAnnotList);
            Enumeration enumeration = page.getLinkSets().elements();
            while (enumeration.hasMoreElements()) {
                LinkSet linkSet = (LinkSet)enumeration.nextElement();
                linkSet.align();
                String string = linkSet.getDest();
                Enumeration enumeration2 = linkSet.getRects().elements();
                while (enumeration2.hasMoreElements()) {
                    LinkedRectangle linkedRectangle = (LinkedRectangle)enumeration2.nextElement();
                    this.currentAnnotList.addLink(this.pdfDoc.makeLink(linkedRectangle.getRectangle(), string));
                }
            }
        } else {
            this.currentAnnotList = null;
        }
    }

    public void renderRuleArea(RuleArea ruleArea) {
        int n = this.currentAreaContainerXPosition + ruleArea.getStartIndent();
        int n2 = this.currentYPosition;
        int n3 = ruleArea.getContentWidth();
        int n4 = ruleArea.getHeight();
        int n5 = ruleArea.getRuleThickness();
        this.addLine(n, n2, n + n3, n2, n5, new PDFColor(ruleArea.getRed(), ruleArea.getGreen(), ruleArea.getBlue()));
    }

    public void renderSVGArea(SVGArea sVGArea) {
        int n = this.currentAreaContainerXPosition;
        int n2 = this.currentYPosition;
        int n3 = sVGArea.getContentWidth();
        int n4 = sVGArea.getHeight();
        this.currentYPosition -= n4;
        Enumeration enumeration = sVGArea.getChildren().elements();
        while (enumeration.hasMoreElements()) {
            int n5;
            int n6;
            int n7;
            Object e = enumeration.nextElement();
            if (e instanceof RectGraphic) {
                n7 = ((RectGraphic)e).x;
                n6 = ((RectGraphic)e).y;
                int n8 = ((RectGraphic)e).width;
                n5 = ((RectGraphic)e).height;
                this.addRect(n + n7, n2 - n6, n8, -n5, new PDFColor(0.0, 0.0, 0.0));
                continue;
            }
            if (e instanceof LineGraphic) {
                n7 = ((LineGraphic)e).x1;
                n6 = ((LineGraphic)e).y1;
                int n9 = ((LineGraphic)e).x2;
                n5 = ((LineGraphic)e).y2;
                this.addLine(n + n7, n2 - n6, n + n9, n2 - n5, 0, new PDFColor(0.0, 0.0, 0.0));
                continue;
            }
            if (!(e instanceof TextGraphic)) continue;
            n7 = ((TextGraphic)e).x;
            n6 = ((TextGraphic)e).y;
            String string = ((TextGraphic)e).s;
            this.currentStream.add("1 0 0 1 " + (float)(n + n7) / 1000.0f + " " + (float)(n2 - n6) / 1000.0f + " Tm " + "(" + string + ") Tj\n");
        }
    }

    public void setProducer(String string) {
        this.pdfDoc.setProducer(string);
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
        FontSetup.addToResources(this.pdfDoc, fontInfo);
    }
}

