/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.fop.render.awt.AWTRenderer;
import org.apache.fop.viewer.Command;
import org.apache.fop.viewer.IconToolBar;
import org.apache.fop.viewer.PreviewDialogAboutBox;
import org.apache.fop.viewer.ProgressListener;
import org.apache.fop.viewer.Translator;

public class PreviewDialog
extends JFrame
implements ProgressListener {
    protected Translator res;
    protected int currentPage = 0;
    protected int pageCount = 0;
    protected AWTRenderer renderer;
    protected IconToolBar toolBar = new IconToolBar();
    protected Command printAction;
    protected Command firstPageAction;
    protected Command previousPageAction;
    protected Command nextPageAction;
    protected Command lastPageAction;
    protected JLabel zoomLabel = new JLabel();
    protected JComboBox scale = new JComboBox(){

        public float getAlignmentY() {
            return 0.5f;
        }
    };
    protected JScrollPane previewArea = new JScrollPane();
    protected JPanel statusBar = new JPanel();
    protected GridBagLayout statusBarLayout = new GridBagLayout();
    protected JLabel statisticsStatus = new JLabel();
    protected JLabel processStatus = new JLabel();
    protected JLabel infoStatus = new JLabel();
    protected JLabel previewImageLabel = new JLabel();

    public PreviewDialog(AWTRenderer aWTRenderer, Translator translator) {
        this.res = translator;
        this.renderer = aWTRenderer;
        this.printAction = new Command(this.res.getString("Print"), "Print"){

            public void doit() {
                PreviewDialog.this.print();
            }
        };
        this.firstPageAction = new Command(this.res.getString("First page"), "firstpg"){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        };
        this.previousPageAction = new Command(this.res.getString("Previous page"), "prevpg"){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        };
        this.nextPageAction = new Command(this.res.getString("Next page"), "nextpg"){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        };
        this.lastPageAction = new Command(this.res.getString("Last page"), "lastpg"){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        };
        this.setDefaultCloseOperation(2);
        ((Component)this).setSize(new Dimension(379, 476));
        this.previewArea.setMinimumSize(new Dimension(50, 50));
        this.setTitle("FOP: AWT-" + this.res.getString("Preview"));
        this.scale.addItem("25");
        this.scale.addItem("50");
        this.scale.addItem("75");
        this.scale.addItem("100");
        this.scale.addItem("150");
        this.scale.addItem("200");
        this.scale.setMaximumSize(new Dimension(80, 24));
        this.scale.setPreferredSize(new Dimension(80, 24));
        this.scale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreviewDialog.this.scale_actionPerformed(actionEvent);
            }
        });
        this.scale.setSelectedItem("100");
        this.renderer.setScaleFactor(100.0);
        this.zoomLabel.setText(this.res.getString("Zoom"));
        this.setJMenuBar(this.setupMenue());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.toolBar.add(this.printAction);
        this.toolBar.addSeparator();
        this.toolBar.add(this.firstPageAction);
        this.toolBar.add(this.previousPageAction);
        this.toolBar.add(this.nextPageAction);
        this.toolBar.add(this.lastPageAction);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.zoomLabel, null);
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.scale, null);
        this.getContentPane().add((Component)this.previewArea, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.statisticsStatus.setBorder(BorderFactory.createEtchedBorder());
        this.processStatus.setBorder(BorderFactory.createEtchedBorder());
        this.infoStatus.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setLayout(this.statusBarLayout);
        this.processStatus.setPreferredSize(new Dimension(200, 21));
        this.statisticsStatus.setPreferredSize(new Dimension(100, 21));
        this.infoStatus.setPreferredSize(new Dimension(100, 21));
        this.processStatus.setMinimumSize(new Dimension(200, 21));
        this.statisticsStatus.setMinimumSize(new Dimension(100, 21));
        this.infoStatus.setMinimumSize(new Dimension(100, 21));
        this.statusBar.add((Component)this.processStatus, new GridBagConstraints(0, 0, 2, 1, 2.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.statusBar.add((Component)this.statisticsStatus, new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.statusBar.add((Component)this.infoStatus, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.previewArea.getViewport().add(this.previewImageLabel);
        this.showPage();
    }

    private void goToFirstPage(ActionEvent actionEvent) {
        if (this.currentPage == 0) {
            return;
        }
        this.currentPage = 0;
        this.goToPage(this.currentPage);
    }

    private void goToLastPage(ActionEvent actionEvent) {
        if (this.currentPage == this.pageCount - 1) {
            return;
        }
        this.currentPage = this.pageCount - 1;
        this.goToPage(this.currentPage);
    }

    private void goToNextPage(ActionEvent actionEvent) {
        if (this.currentPage >= this.pageCount - 1) {
            return;
        }
        ++this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void goToPage(int n) {
        this.currentPage = n;
        this.renderer.setPageNumber(n);
        this.showPage();
    }

    private void goToPreviousPage(ActionEvent actionEvent) {
        if (this.currentPage <= 0) {
            return;
        }
        --this.currentPage;
        this.goToPage(this.currentPage);
    }

    private void print() {
        block2: {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPageable(this.renderer);
            if (!printerJob.printDialog()) break block2;
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public void progress(int n) {
        this.processStatus.setText(String.valueOf(n) + "%");
    }

    public void progress(int n, String string) {
        this.processStatus.setText(String.valueOf(string) + " " + n + "%");
    }

    public void progress(String string) {
        this.processStatus.setText(string);
    }

    void scale_actionPerformed(ActionEvent actionEvent) {
        this.setScale(new Double((String)this.scale.getSelectedItem()));
    }

    public void setScale(double d) {
        if (d == 25.0) {
            this.scale.setSelectedIndex(0);
        } else if (d == 50.0) {
            this.scale.setSelectedIndex(1);
        } else if (d == 75.0) {
            this.scale.setSelectedIndex(2);
        } else if (d == 100.0) {
            this.scale.setSelectedIndex(3);
        } else if (d == 150.0) {
            this.scale.setSelectedIndex(4);
        } else if (d == 200.0) {
            this.scale.setSelectedIndex(5);
        }
        this.renderer.setScaleFactor(d);
        this.showPage();
    }

    private JMenuBar setupMenue() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(this.res.getString("File"));
        JMenu jMenu2 = new JMenu("OutputFormat");
        jMenu2.add(new Command("mHTML"));
        jMenu2.add(new Command("mPDF"));
        jMenu2.add(new Command("mRTF"));
        jMenu2.add(new Command("mTEXT"));
        jMenu.add(new Command(this.res.getString("Print")){

            public void doit() {
                PreviewDialog.this.print();
            }
        });
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("Exit")){

            public void doit() {
                PreviewDialog.this.dispose();
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.res.getString("View"));
        jMenu.add(new Command(this.res.getString("First page")){

            public void doit() {
                PreviewDialog.this.goToFirstPage(null);
            }
        });
        jMenu.add(new Command(this.res.getString("Previous page")){

            public void doit() {
                PreviewDialog.this.goToPreviousPage(null);
            }
        });
        jMenu.add(new Command(this.res.getString("Next page")){

            public void doit() {
                PreviewDialog.this.goToNextPage(null);
            }
        });
        jMenu.add(new Command(this.res.getString("Last page")){

            public void doit() {
                PreviewDialog.this.goToLastPage(null);
            }
        });
        jMenu.addSeparator();
        jMenu2 = new JMenu(this.res.getString("Zoom"));
        jMenu2.add(new Command("25%"){

            public void doit() {
                PreviewDialog.this.setScale(25.0);
            }
        });
        jMenu2.add(new Command("50%"){

            public void doit() {
                PreviewDialog.this.setScale(50.0);
            }
        });
        jMenu2.add(new Command("75%"){

            public void doit() {
                PreviewDialog.this.setScale(75.0);
            }
        });
        jMenu2.add(new Command("100%"){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenu2.add(new Command("150%"){

            public void doit() {
                PreviewDialog.this.setScale(150.0);
            }
        });
        jMenu2.add(new Command("200%"){

            public void doit() {
                PreviewDialog.this.setScale(200.0);
            }
        });
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("Default zoom")){

            public void doit() {
                PreviewDialog.this.setScale(100.0);
            }
        });
        jMenuBar.add(jMenu);
        jMenu = new JMenu(this.res.getString("Help"));
        jMenu.add(new Command(this.res.getString("Index")));
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("Introduction")));
        jMenu.addSeparator();
        jMenu.add(new Command(this.res.getString("About")){

            public void doit() {
                PreviewDialog.this.startHelpAbout(null);
            }
        });
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void showPage() {
        BufferedImage bufferedImage = null;
        Graphics graphics = null;
        this.renderer.render(this.currentPage);
        bufferedImage = this.renderer.getLastRenderedPage();
        graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1);
        this.previewImageLabel.setIcon(new ImageIcon(bufferedImage));
        this.pageCount = this.renderer.getPageCount();
        this.statisticsStatus.setText(String.valueOf(this.res.getString("Page")) + " " + (this.currentPage + 1) + " " + this.res.getString("of") + " " + this.pageCount);
    }

    public void startHelpAbout(ActionEvent actionEvent) {
        PreviewDialogAboutBox previewDialogAboutBox = new PreviewDialogAboutBox(this);
        Dimension dimension = previewDialogAboutBox.getPreferredSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        ((Component)previewDialogAboutBox).setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
        previewDialogAboutBox.setModal(true);
        previewDialogAboutBox.show();
    }
}

