/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.db.pool;

import java.sql.Connection;
import java.util.Stack;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.db.pool.DB;
import org.apache.turbine.util.db.pool.DBConnection;
import org.apache.turbine.util.db.pool.DBFactory;

public class ConnectionPool {
    private Stack pool = new Stack();
    private int totalConnections = 0;
    private int maxConnections = 10;
    private long expiryTime = 3600000L;
    private long maxConnectionAttempts = 50L;
    private long connectionAttemptsCounter = 0L;
    private long dbCheckFrequency = 5000L;
    private DB db = null;

    protected ConnectionPool() {
        this.maxConnections = TurbineResources.getInt("database.maxConnections", 10);
        this.expiryTime = TurbineResources.getLong("database.expiryTime", 3600000L);
        this.maxConnectionAttempts = TurbineResources.getLong("database.maxConnectionAttempts", 50L);
    }

    protected ConnectionPool(int maxCons, long expiryTime) {
        this.maxConnections = maxCons;
        this.expiryTime = expiryTime;
    }

    private void closeConnection(DBConnection dbcon) {
        try {
            Connection conn = dbcon.getConnection();
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (Exception exception) {}
    }

    protected void finalize() throws Throwable {
        while (!this.pool.empty()) {
            DBConnection dbcon = (DBConnection)this.pool.pop();
            this.closeConnection(dbcon);
        }
    }

    protected synchronized DBConnection getConnection(String driver, String url, String username, String password) throws Exception {
        DBConnection connection = null;
        connection = this.pool.empty() && this.totalConnections < this.maxConnections ? this.getNewConnection(driver, url, username, password) : this.getPooledConnection(driver, url, username, password);
        return connection;
    }

    public DB getDB() {
        return this.db;
    }

    private DBConnection getNewConnection(String driver, String url, String username, String password) throws Exception {
        if (this.db == null) {
            this.db = DBFactory.create(driver);
            this.db.init(url, username, password);
        }
        ++this.totalConnections;
        return new DBConnection(this.db.getConnection(), url);
    }

    private synchronized DBConnection getPooledConnection(String driver, String url, String username, String password) throws Exception {
        while (true) {
            if (!this.pool.empty()) {
                DBConnection con = (DBConnection)this.pool.pop();
                if (this.isValid(con)) {
                    this.connectionAttemptsCounter = 0L;
                    return con;
                }
                this.closeConnection(con);
                --this.totalConnections;
                this.connectionAttemptsCounter = 0L;
                if (!this.pool.empty()) continue;
                return this.getNewConnection(driver, url, username, password);
            }
            ++this.connectionAttemptsCounter;
            this.wait();
        }
    }

    private boolean isExpired(DBConnection connection) throws Exception {
        return System.currentTimeMillis() - connection.getTimestamp() > this.expiryTime;
    }

    private boolean isValid(DBConnection connection) throws Exception {
        return connection.getConnection() != null && !connection.getConnection().isClosed() && !this.isExpired(connection);
    }

    protected synchronized void releaseConnection(DBConnection connection) throws Exception {
        if (this.isValid(connection)) {
            this.pool.push(connection);
            this.notify();
        } else {
            this.closeConnection(connection);
            --this.totalConnections;
        }
    }
}

