/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.ErrorHandler;

public class DefaultApplyXSL
extends ApplyXSL {
    protected OrderedProps ourMediaProps = null;
    protected static final String STYLESHEET_ATTRIBUTE = "media";
    protected static final String HEADER_NAME = "user-Agent";

    protected XSLTInputSource getDocument(XSLTProcessor xSLTProcessor, HttpServletRequest httpServletRequest, ApplyXSLListener applyXSLListener) throws ApplyXSLException {
        try {
            String string = null;
            string = httpServletRequest.getPathInfo();
            if (string != null) {
                applyXSLListener.out.println("Parsing XML Document from PathInfo: " + string);
                return this.makeDocument(xSLTProcessor, httpServletRequest, new URL("http", ((DefaultApplyXSLProperties)this.ourDefaultParameters).getLocalHost(), string.replace('\\', '/')).openStream(), applyXSLListener);
            }
            string = this.ourDefaultParameters.getXMLurl(httpServletRequest);
            if (string != null) {
                applyXSLListener.out.println("Parsing XML Document from request parameter: " + string);
                return this.makeDocument(xSLTProcessor, httpServletRequest, new URL(string).openStream(), applyXSLListener);
            }
            String string2 = httpServletRequest.getContentType();
            if (string2 != null && string2.startsWith("text/xml")) {
                applyXSLListener.out.println("Parsing XML Document from request chain");
                return this.makeDocument(xSLTProcessor, httpServletRequest, (InputStream)httpServletRequest.getInputStream(), applyXSLListener);
            }
        }
        catch (IOException iOException) {
            throw new ApplyXSLException(iOException, 404);
        }
        catch (Exception exception) {
            throw new ApplyXSLException(exception, 500);
        }
        return null;
    }

    public String getMedia(HttpServletRequest httpServletRequest) {
        return this.ourMediaProps.getValue(httpServletRequest.getHeader(HEADER_NAME));
    }

    protected XSLTInputSource getStylesheet(HttpServletRequest httpServletRequest, XSLTInputSource xSLTInputSource, ApplyXSLListener applyXSLListener, XSLTProcessor xSLTProcessor) throws ApplyXSLException {
        try {
            String string = ((DefaultApplyXSLProperties)this.ourDefaultParameters).getXSLRequestURL(httpServletRequest);
            if (string != null) {
                applyXSLListener.out.println("Parsing XSL Stylesheet Document from request parameter: " + string);
            } else {
                if (xSLTInputSource != null) {
                    applyXSLListener.out.println("calling getXSLURLfromDoc and getMedia " + this.getMedia(httpServletRequest));
                    string = DefaultApplyXSL.getXSLURLfromDoc(xSLTInputSource, STYLESHEET_ATTRIBUTE, this.getMedia(httpServletRequest), xSLTProcessor);
                }
                if (string != null) {
                    applyXSLListener.out.println("Parsing XSL Stylesheet Document from XML Document tag: " + string);
                } else {
                    string = this.ourDefaultParameters.getXSLurl(null);
                    if (string != null) {
                        applyXSLListener.out.println("Parsing XSL Stylesheet Document from configuration: " + string);
                    }
                }
            }
            return new XSLTInputSource(string);
        }
        catch (IOException iOException) {
            throw new ApplyXSLException(iOException, 404);
        }
        catch (Exception exception) {
            throw new ApplyXSLException(exception, 500);
        }
    }

    public static String getXSLURLfromDoc(XSLTInputSource xSLTInputSource, String string, String string2, XSLTProcessor xSLTProcessor) {
        String string3 = null;
        String string4 = null;
        try {
            Node node = xSLTProcessor.getSourceTreeFromInput(xSLTInputSource);
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                PIA pIA;
                ProcessingInstruction processingInstruction;
                if (node2.getNodeType() == 7 && (processingInstruction = (ProcessingInstruction)node2).getNodeName().equals("xml-stylesheet") && "text/xsl".equals((pIA = new PIA(processingInstruction)).getAttribute("type"))) {
                    string3 = pIA.getAttribute("href");
                    String string5 = pIA.getAttribute(string);
                    if (string5 != null && string5.indexOf(string2) > -1) {
                        return string3;
                    }
                    if (!"yes".equals(pIA.getAttribute("alternate"))) {
                        string4 = string3;
                    }
                }
                node2 = node2.getNextSibling();
            }
        }
        catch (Exception exception) {}
        return string4;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.setMediaProps(servletConfig.getInitParameter("mediaURL"));
    }

    public XSLTInputSource makeDocument(XSLTProcessor xSLTProcessor, HttpServletRequest httpServletRequest, InputStream inputStream, ErrorHandler errorHandler) throws Exception {
        XSLTInputSource xSLTInputSource = new XSLTInputSource(inputStream);
        return xSLTInputSource;
    }

    protected void setDefaultParameters(ServletConfig servletConfig) {
        this.ourDefaultParameters = new DefaultApplyXSLProperties(servletConfig);
    }

    protected void setMediaProps(String string) {
        block9: {
            block8: {
                if (string == null) break block8;
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        uRL = new URL("file", "", String.valueOf(ApplyXSL.CURRENTDIR) + string);
                    }
                    catch (MalformedURLException malformedURLException2) {
                        this.writeLog("Unable to find the media properties file based on parameter 'mediaURL' = " + string, 202, malformedURLException2);
                        uRL = null;
                    }
                }
                if (uRL == null) break block9;
                try {
                    this.ourMediaProps = new OrderedProps(uRL.openStream());
                }
                catch (IOException iOException) {
                    this.writeLog("Exception occurred while opening media properties file: " + string + ".  Media table may be invalid.", 202, iOException);
                }
                break block9;
            }
            String string2 = String.valueOf(ApplyXSL.CURRENTDIR) + "media.properties";
            try {
                this.ourMediaProps = new OrderedProps(new FileInputStream(string2));
            }
            catch (IOException iOException) {
                this.writeLog("Default media properties file " + string2 + " not found.", 202, iOException);
            }
        }
    }

    protected URLConnection toAcceptLanguageConnection(URL uRL, HttpServletRequest httpServletRequest) throws Exception {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setRequestProperty("Accept-Language", httpServletRequest.getHeader("Accept-Language"));
        return uRLConnection;
    }
}

