/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;

public class Ant
extends Task {
    private File dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    Vector properties = new Vector();
    Project p1;

    public void init() {
        this.p1 = new Project();
        this.p1.setJavaVersionProperty();
        this.p1.addTaskDefinition("property", (Class)this.project.getTaskDefinitions().get("property"));
    }

    private void reinit() {
        this.init();
        int n = 0;
        while (n < this.properties.size()) {
            Property property = (Property)this.properties.elementAt(n);
            Property property2 = (Property)this.p1.createTask("property");
            property2.setName(property.getName());
            if (property.getValue() != null) {
                property2.setValue(property.getValue());
            }
            if (property.getFile() != null) {
                property2.setFile(property.getFile());
            }
            if (property.getResource() != null) {
                property2.setResource(property.getResource());
            }
            this.properties.setElementAt(property2, n);
            ++n;
        }
    }

    private void initializeProject() {
        Object object;
        Object object2;
        Enumeration enumeration;
        Object object3;
        Object object4;
        Object object5;
        Vector vector = this.project.getBuildListeners();
        int n = 0;
        while (n < vector.size()) {
            this.p1.addBuildListener((BuildListener)vector.elementAt(n));
            ++n;
        }
        if (this.output != null) {
            try {
                object5 = new PrintStream(new FileOutputStream(this.output));
                object4 = new DefaultLogger();
                ((DefaultLogger)object4).setMessageOutputLevel(2);
                ((DefaultLogger)object4).setOutputPrintStream((PrintStream)object5);
                ((DefaultLogger)object4).setErrorPrintStream((PrintStream)object5);
                this.p1.addBuildListener((BuildListener)object4);
            }
            catch (IOException iOException) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        object5 = this.project.getTaskDefinitions();
        object4 = ((Hashtable)object5).keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            enumeration = (Class)((Hashtable)object5).get(object3);
            this.p1.addTaskDefinition((String)object3, (Class)((Object)enumeration));
        }
        object3 = this.project.getDataTypeDefinitions();
        enumeration = ((Hashtable)object3).keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (Class)((Hashtable)object3).get(object2);
            this.p1.addDataTypeDefinition((String)object2, (Class)object);
        }
        object2 = this.project.getProperties();
        enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)((Hashtable)object2).get(object);
            this.p1.setProperty((String)object, string);
        }
    }

    public void execute() throws BuildException {
        try {
            Object object;
            if (this.p1 == null) {
                this.reinit();
            }
            if (this.dir == null) {
                this.dir = this.project.getBaseDir();
            }
            this.initializeProject();
            this.p1.setBaseDir(this.dir);
            this.p1.setUserProperty("basedir", this.dir.getAbsolutePath());
            Enumeration enumeration = this.properties.elements();
            while (enumeration.hasMoreElements()) {
                object = (Property)enumeration.nextElement();
                ((Property)object).execute();
            }
            if (this.antFile == null) {
                this.antFile = "build.xml";
            }
            if (!((File)(object = new File(this.antFile))).isAbsolute()) {
                this.antFile = new File(this.dir, this.antFile).getAbsolutePath();
                object = new File(this.antFile);
                if (!((File)object).isFile()) {
                    throw new BuildException("Build file " + object + " not found.");
                }
            }
            this.p1.setUserProperty("ant.file", this.antFile);
            ProjectHelper.configureProject(this.p1, new File(this.antFile));
            if (this.target == null) {
                this.target = this.p1.getDefaultTarget();
            }
            if (this.p1.getBaseDir().equals(this.project.getBaseDir()) && this.p1.getProperty("ant.file").equals(this.project.getProperty("ant.file")) && this.target.equals(this.getOwningTarget().getName())) {
                throw new BuildException("ant task calling its own parent target");
            }
            this.p1.executeTarget(this.target);
            Object var4_3 = null;
            this.p1 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.p1 = null;
            throw throwable;
        }
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setAntfile(String string) {
        this.antFile = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public Property createProperty() {
        if (this.p1 == null) {
            this.reinit();
        }
        Property property = (Property)this.p1.createTask("property");
        property.setUserProperty(true);
        this.properties.addElement(property);
        return property;
    }
}

