/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class FixCRLF
extends MatchingTask {
    private int addcr;
    private int addtab;
    private int ctrlz;
    private int tablength = 8;
    private File srcDir;
    private File destDir = null;

    public FixCRLF() {
        if (System.getProperty("path.separator").equals(":")) {
            this.addcr = -1;
            this.ctrlz = -1;
        } else {
            this.addcr = 1;
            this.ctrlz = 0;
        }
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setCr(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.addcr = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.addtab = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTablength(int n) throws BuildException {
        if (n < 2 || (n & n - 1) != 0) {
            throw new BuildException("tablength must be a positive power of 2", this.location);
        }
        this.tablength = n;
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.ctrlz = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: cr=" + (this.addcr == -1 ? "add" : (this.addcr == 0 ? "asis" : "remove")) + " tab=" + (this.addtab == -1 ? "add" : (this.addtab == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == -1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength, 3);
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            boolean bl;
            File file = new File(this.srcDir, stringArray[n]);
            int n3 = (int)file.length();
            byte[] byArray = new byte[n3];
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n3) {
                bl = byArray[n7];
                if (bl) {
                    ++n4;
                }
                if (bl) {
                    ++n5;
                }
                if (bl) {
                    ++n6;
                }
                ++n7;
            }
            bl = n3 > 0 && byArray[n3 - 1] == 26;
            this.log(file + ": size=" + n3 + " cr=" + n4 + " lf=" + n5 + " tab=" + n6 + " eof=" + bl, 3);
            int n8 = n3;
            if (this.addcr != 0) {
                n8 -= n4;
            }
            if (this.addcr == 1) {
                n8 += n5;
            }
            if (this.addtab == -1) {
                n8 += n6 * (this.tablength - 1);
            }
            if (this.ctrlz == 1) {
                ++n8;
            }
            byte[] byArray2 = new byte[n8];
            int n9 = n2 = 0;
            int n10 = 0;
            int n11 = 0;
            while (n11 < n3) {
                switch (byArray[n11]) {
                    case 32: {
                        if (this.addtab == 0) {
                            byArray2[n2++] = 32;
                        }
                        ++n10;
                        break;
                    }
                    case 9: {
                        if (this.addtab == 0) {
                            byArray2[n2++] = 9;
                            ++n10;
                            break;
                        }
                        n10 = (n10 | this.tablength - 1) + 1;
                        break;
                    }
                    case 13: {
                        if (this.addcr != 0) break;
                        byArray2[n2++] = 13;
                        ++n10;
                        break;
                    }
                    case 10: {
                        if (this.addcr == 1) {
                            byArray2[n2++] = 13;
                        }
                        byArray2[n2++] = 10;
                        n9 = n2;
                        n10 = 0;
                        break;
                    }
                    default: {
                        if (this.addtab > 0 && n2 + 1 < n9 + n10) {
                            int n12 = n2 - n9;
                            while ((n12 | this.tablength - 1) < n10) {
                                byArray2[n2++] = 9;
                                n12 = n2 - (n9 -= this.tablength - 1 - (n12 & this.tablength - 1));
                            }
                        }
                        while (n2 < n9 + n10) {
                            byArray2[n2++] = 32;
                        }
                        byArray2[n2++] = byArray[n11];
                        ++n10;
                    }
                }
                ++n11;
            }
            if (this.ctrlz == 1) {
                if (byArray2[n2 - 1] != 26) {
                    byArray2[n2++] = 26;
                }
            } else if (this.ctrlz == -1) {
                if (n2 > 2 && byArray2[n2 - 1] == 10 && byArray2[n2 - 2] == 26) {
                    --n2;
                }
                if (n2 > 1 && byArray2[n2 - 1] == 26) {
                    --n2;
                }
            }
            try {
                File file2 = file;
                if (this.destDir != null) {
                    file2 = new File(this.destDir, stringArray[n]);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                fileOutputStream.write(byArray2, 0, n2);
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            ++n;
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }
}

