/*
 * Decompiled with CFR 0.152.
 */
package xalanjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import xalanjdoc.ConfigurationStandard;
import xalanjdoc.SerialFieldSubWriter;
import xalanjdoc.SerialMethodSubWriter;
import xalanjdoc.Standard;
import xalanjdoc.SubWriterHolderWriter;

public class SerializedFormWriter
extends SubWriterHolderWriter {
    public SerializedFormWriter(String filename) throws IOException, DocletAbortException {
        super(filename);
    }

    public static void generate(RootDoc root) throws DocletAbortException {
        String filename = "serialized-form.html";
        try {
            SerializedFormWriter serialgen = new SerializedFormWriter(filename);
            serialgen.generateSerializedFormFile(root);
            ((PrintWriter)((Object)serialgen)).close();
        }
        catch (IOException exc) {
            Standard.configuration();
            ConfigurationStandard.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException();
        }
    }

    protected void generateContents(RootDoc root) {
        PackageDoc[] packages = Standard.configuration().packages;
        Object[] cmdlineClasses = root.specifiedClasses();
        boolean first = true;
        int i = 0;
        while (i < packages.length) {
            Object[] classes = packages[i].allClasses();
            boolean printPackageName = true;
            Arrays.sort(classes);
            int j = 0;
            while (j < classes.length) {
                Object classdoc = classes[j];
                if (classdoc.isClass() && classdoc.isSerializable()) {
                    if (printPackageName) {
                        this.hr(4, "noshade");
                        this.printPackageName(packages[i].name());
                        printPackageName = false;
                    }
                    first = false;
                    this.printSerialMemberInfo((ClassDoc)classdoc);
                }
                ++j;
            }
            ++i;
        }
        if (cmdlineClasses.length > 0) {
            Arrays.sort(cmdlineClasses);
            int i2 = 0;
            while (i2 < cmdlineClasses.length) {
                Object classdoc = cmdlineClasses[i2];
                if (classdoc.isClass() && classdoc.isSerializable()) {
                    if (!first) {
                        this.hr(4, "noshade");
                    }
                    first = false;
                    this.printSerialMemberInfo((ClassDoc)classdoc);
                }
                ++i2;
            }
        }
    }

    public void generateSerializedFormFile(RootDoc root) {
        this.printHeader(this.getText("doclet.Serialized_Form"));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Serialized_Form");
        this.h1End();
        this.centerEnd();
        this.generateContents(root);
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void printClassName(String classstr) {
        this.tableHeader();
        this.tdColspan(2);
        this.font("+2");
        this.bold(classstr);
        this.tableFooter();
    }

    protected void printMembers(ClassDoc cd) {
        new SerialMethodSubWriter(this).printMembers(cd);
        new SerialFieldSubWriter(this).printMembers(cd);
    }

    protected void printPackageName(String pkgname) {
        this.tableHeader();
        this.tdAlign("center");
        this.font("+2");
        this.boldText("doclet.Package");
        ((PrintWriter)((Object)this)).print(' ');
        this.bold(pkgname);
        this.tableFooter();
    }

    protected void printSerialMemberInfo(ClassDoc cd) {
        String classlink = this.getQualifiedClassLink(cd);
        this.anchor(cd.qualifiedName());
        this.printClassName(this.getText("doclet.Class_0_implements_serializable", classlink));
        this.printMembers(cd);
        this.p();
    }

    protected void tableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
        this.p();
    }

    protected void tableHeader() {
        this.tableIndexSummary();
        this.trBgcolorStyle("#CCCCFF", "TableSubHeadingColor");
    }
}

