/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc;

import org.sablecc.sablecc.analysis.*;
import org.sablecc.sablecc.node.*;
import java.io.*;

public class GenTokens extends DepthFirstAdapter
{
    private MacroExpander macros;
    private ResolveIds ids;
    private File pkgDir;
    private String pkgName;

//    final GenTokens instance = this;
    String text;

    public GenTokens(ResolveIds ids)
    {
        this.ids = ids;

        try
        {
            macros = new MacroExpander(
                new InputStreamReader(
                getClass().getResourceAsStream("tokens.txt")));
        }
        catch(IOException e)
        {
            throw new RuntimeException("unable to open tokens.txt.");
        }

        pkgDir = new File(ids.pkgDir, "node");
        pkgName = ids.pkgName.equals("") ? "node" : ids.pkgName + ".node";

        if(!pkgDir.exists())
        {
            if(!pkgDir.mkdir())
            {
                throw new RuntimeException("Unable to create " + pkgDir.getAbsolutePath());
            }
        }
    }

    public void inTokenDef1(TokenDef1 node)
    {
        String name = (String) ids.names.get(node);

        BufferedWriter file;

        try
        {
            file = new BufferedWriter(
                new FileWriter(
                new File(pkgDir, name + ".java")));
        }
        catch(IOException e)
        {
            throw new RuntimeException("Unable to create " + new File(pkgDir, name + ".java").getAbsolutePath());
        }

        text = null;

        RegExp1 regExp = (RegExp1) node.getNode4();

        Concat1 concat = (Concat1) regExp.getNode1();
        RegExpTails regExpTails = regExp.getNode2();

        if(regExpTails instanceof RegExpTails2)
        {
            UnExps unExps = concat.getNode1();

            if(unExps instanceof UnExps1)
            {
                UnExps unExps_2 = ((UnExps1) unExps).getNode2();

                if(unExps_2 instanceof UnExps2)
                {
                    UnExp1 unExp = (UnExp1) ((UnExps1) unExps).getNode1();

                    Basic basic = unExp.getNode1();
                    UnOpOpt unOpOpt = unExp.getNode2();

                    if((basic instanceof Basic3) &&
                        (unOpOpt instanceof UnOpOpt2))
                    {
                        text = ((Basic3) basic).getNode1().getText();
                        text = text.substring(1, text.length() - 1);
                    }
                    else if((basic instanceof Basic1) &&
                        (unOpOpt instanceof UnOpOpt2))
                    {
                        PChar pChar = ((Basic1) basic).getNode1();

                        if(pChar instanceof PChar1)
                        {
                            text = ((PChar1) pChar).getNode1().getText();
                            text = text.substring(1, text.length() - 1);
                        }
                    }
                }
            }
        }

        try
        {
            if(text == null)
            {
                ids.fixedTokens.put(node, new Boolean(false));

                macros.apply(file, "VariableTextToken", new String[] { pkgName,
                    ids.pkgName.equals("") ? "analysis" : ids.pkgName + ".analysis",
                    name});
            }
            else
            {
                ids.fixedTokens.put(node, new Boolean(true));

                macros.apply(file, "FixedTextToken", new String[] { pkgName,
                    ids.pkgName.equals("") ? "analysis" : ids.pkgName + ".analysis",
                    name, processText(text)});

                ids.errorNames.put(node, "'" + text + "'");
            }
        }
        catch(IOException e)
        {
            throw new RuntimeException("An error occured while writing to " +
                new File(pkgDir, name + ".java").getAbsolutePath());
        }

        try
        {
            file.close();
        }
        catch(IOException e)
        {
        }
    }

    private String processText(String s)
    {
        StringBuffer result = new StringBuffer();

        for(int i = 0; i < s.length(); i++)
        {
            char c = s.charAt(i);

            switch(c)
            {
            case '\b':
                {
                    result.append("\\t");
                    break;
                }
            case '\t':
                {
                    result.append("\\t");
                    break;
                }
            case '\n':
                {
                    result.append("\\n");
                    break;
                }
            case '\f':
                {
                    result.append("\\f");
                    break;
                }
            case '\r':
                {
                    result.append("\\r");
                    break;
                }
            case '\"':
                {
                    result.append("\\\"");
                    break;
                }
            case '\'':
                {
                    result.append("\\\'");
                    break;
                }
            case '\\':
                {
                    result.append("\\\\");
                    break;
                }
            default:
                {
                    result.append(c);
                }
            }
        }

        return result.toString();
    }
}


