/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of SableCC.                             *
 * See the file "LICENSE" for copyright information and the  *
 * terms and conditions for copying, distribution and        *
 * modification of SableCC.                                  *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package org.sablecc.sablecc.node;

import org.sablecc.sablecc.Switch;
import org.sablecc.sablecc.analysis.Analysis;

public final class PkgId8 extends PkgId
{
    public void apply(Switch sw)
    {
        ((Analysis) sw).casePkgId8(this);
    }

    public String getText()
    {
        return node1.getText();
    }

    public String toString()
    {
        return ""
            + node1;
    }

    private TProductionSpecifier node1;

    public TProductionSpecifier getNode1()
    {
        return node1;
    }

    public void setNode1(TProductionSpecifier node)
    {
        if(node1 != null)
        {
            node1.setParent(null);
        }

        if(node.getParent() != null)
        {
            node.getParent().removeChild(node);
        }

        node.setParent(this);

        node1 = node;
    }

    void removeChild(Node child)
    {
        if(node1 == child)
        {
            node1 = null;
        }

    }
}

